/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.soap.brk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import nl.b3p.brmo.soap.brk.BrkInfoException;
import nl.b3p.brmo.soap.brk.BrkInfoRequest;
import nl.b3p.brmo.soap.brk.BrkInfoResponse;
import nl.b3p.brmo.soap.db.BrkInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebService(targetNamespace="http://brmo.b3p.nl/brk/1.0/soap-brk", wsdlLocation="WEB-INF/wsdl/brkinfo.wsdl")
@HandlerChain(file="/handler-chain.xml")
public class GetBrkInfoImpl {
    private static final Log LOG = LogFactory.getLog(GetBrkInfoImpl.class);

    @WebMethod(operationName="getBrkInfo")
    @RequestWrapper(className="nl.b3p.brmo.soap.brk.getBrkInfo")
    @ResponseWrapper(className="nl.b3p.brmo.soap.brk.getBrkInfoResponse")
    public BrkInfoResponse getBrkInfo(@WebParam(name="request") BrkInfoRequest request) throws BrkInfoException {
        Map searchContext = BrkInfo.createSearchContext((BrkInfoRequest)request);
        if (searchContext.isEmpty()) {
            throw new BrkInfoException("Request not valid", "minimaal \u00e9\u00e9n zoekterm vereist!");
        }
        ArrayList ids = null;
        try {
            ids = BrkInfo.findKozIDs((Map)searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new BrkInfoException("Database reported errors", ex.getLocalizedMessage());
        }
        if (ids == null || ids.isEmpty()) {
            throw new BrkInfoException("Database reported", "Geen resultaten");
        }
        if (ids.size() > (Integer)searchContext.get("MaxAantalResultaten")) {
            throw new BrkInfoException("Database reported", "Meer resultaten dan toegestaan: " + (Integer)searchContext.get("MaxAantalResultaten") + ", pas uw voorwaarden aan!");
        }
        BrkInfoResponse result = null;
        try {
            result = BrkInfo.createResponse((List)ids, (Map)searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new BrkInfoException("Database reported errors", ex.getLocalizedMessage());
        }
        return result;
    }
}

