/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.stufbg204;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.brmo.stufbg204.AntwoordBodyFactory;
import nl.b3p.brmo.stufbg204.CriteriaParser;
import nl.b3p.brmo.stufbg204.util.StUFbg204Util;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.egem.stuf.sector.bg._0204.PRSAntwoord;
import nl.egem.stuf.sector.bg._0204.PRSVraag;
import nl.egem.stuf.sector.bg._0204.StUFFout;
import nl.egem.stuf.sector.bg._0204.SynchroonAntwoordBericht;
import nl.egem.stuf.sector.bg._0204.VraagBericht;
import nl.egem.stuf.stuf0204.FoutBericht;
import nl.egem.stuf.stuf0204.Stuurgegevens;
import nl.egem.stuf.stuf0204.Verwerkingssoort;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebService(serviceName="StUFBGSynchroon", portName="StUFBGSynchronePort", endpointInterface="nl.egem.stuf.sector.bg._0204.StUFBGSynchroonPortType", targetNamespace="http://www.egem.nl/StUF/sector/bg/0204", wsdlLocation="WEB-INF/wsdl/bg0204.wsdl")
@HandlerChain(file="/handler-chain.xml")
public class StUFBGsynchroon {
    private static final Log LOG = LogFactory.getLog(StUFBGsynchroon.class);

    public SynchroonAntwoordBericht beantwoordSynchroneVraag(VraagBericht vraag) throws StUFFout {
        try {
            LOG.debug((Object)("Er is vraag ontvangen van soort: " + vraag.getStuurgegevens().getBerichtsoort()));
            SynchroonAntwoordBericht antw = new SynchroonAntwoordBericht();
            antw.setStuurgegevens(StUFbg204Util.maakStuurgegevens((Stuurgegevens)vraag.getStuurgegevens()));
            SynchroonAntwoordBericht.Body b = this.process(vraag);
            antw.setBody(b);
            try {
                String vraagXml = this.getXml((Object)vraag);
                LOG.debug((Object)("Vraagbericht: " + vraagXml));
                String antwoordXml = this.getXml((Object)antw);
                LOG.debug((Object)("Antwoordbericht: " + antwoordXml));
            }
            catch (JAXBException ex) {
                LOG.debug((Object)"Cannot output vraag/antwoord:", (Throwable)ex);
            }
            return antw;
        }
        catch (SQLException | BrmoException e) {
            FoutBericht fout = StUFbg204Util.maakFout((String)"StUF011", (Exception)e);
            throw new StUFFout("Not implemented yet.", fout, e);
        }
        catch (StUFFout e) {
            throw e;
        }
    }

    private SynchroonAntwoordBericht.Body process(VraagBericht vraag) throws BrmoException, SQLException, StUFFout {
        String q = null;
        DataSource d = ConfigUtil.getDataSourceRsgb();
        Connection c = d.getConnection();
        try {
            q = this.createQuery(vraag, c);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            LOG.error((Object)"Cannot parse query: ", (Throwable)e);
            FoutBericht fout = StUFbg204Util.maakFout((String)"StUF011", (Exception)e);
            throw new StUFFout("Cannot parse query: ", fout, (Throwable)e);
        }
        List results = this.getResults(q, vraag, c);
        DbUtils.closeQuietly((Connection)c);
        this.sort(results, vraag);
        SynchroonAntwoordBericht.Body b = this.createResults(results, vraag);
        return b;
    }

    private String createQuery(VraagBericht vraag, Connection c) throws IllegalArgumentException, StUFFout, UnsupportedOperationException {
        Stuurgegevens sg = vraag.getStuurgegevens();
        String q = "select * from ";
        String entiteitType = sg.getEntiteittype();
        VraagBericht.Body b = vraag.getBody();
        switch (entiteitType) {
            case "PRS": {
                q = q + "ingeschr_nat_prs inp inner join subject s on inp.sc_identif = s.identif inner join nat_prs np on np.sc_identif = s.identif ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Entiteitstype niet ondersteund: " + entiteitType);
            }
        }
        CriteriaParser cp = new CriteriaParser();
        String whereClause = cp.getCriteria(vraag);
        if (whereClause != null) {
            q = q + whereClause;
        }
        String order = this.getOrderString(vraag);
        q = q + " " + order;
        if (vraag.getStuurgegevens().getVraag().getMaximumAantal() != null) {
            GeometryJdbcConverter converter = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)c);
            q = converter.buildLimitSql(new StringBuilder(q), vraag.getStuurgegevens().getVraag().getMaximumAantal().intValue()).toString();
        }
        return q;
    }

    private String getOrderString(VraagBericht vraag) throws StUFFout {
        String sort = "";
        BigInteger sortering = vraag.getStuurgegevens().getVraag().getSortering();
        if (sortering != null) {
            if (sortering.compareTo(new BigInteger("1")) == -1 || sortering.compareTo(new BigInteger("9")) == 1) {
                FoutBericht fout = StUFbg204Util.maakFout((String)"StUF004");
                throw new StUFFout("Sortering niet ondersteund: " + sortering, fout);
            }
            sort = "ORDER BY ";
            switch (sortering.toString()) {
                case "1": {
                    sort = sort + "nm_geslachtsnaam,nm_voorvoegsel_geslachtsnaam, na_voorletters_aanschrijving";
                    break;
                }
                case "6": {
                    sort = sort + "gb_geboortedatum,nm_geslachtsnaam,nm_voorvoegsel_geslachtsnaam, na_voorletters_aanschrijving";
                    break;
                }
                case "7": {
                    sort = sort + "bsn";
                    break;
                }
                case "8": {
                    sort = sort + "a_nummer";
                    break;
                }
                case "2": 
                case "3": 
                case "4": 
                case "5": 
                case "9": {
                    break;
                }
                default: {
                    FoutBericht fout = StUFbg204Util.maakFout((String)"StUF004");
                    throw new StUFFout("Sortering niet ondersteund: " + sortering, fout);
                }
            }
        } else {
            sort = "ORDER BY identif";
        }
        return sort;
    }

    private void sort(List<Map<String, Object>> results, VraagBericht vraag) throws StUFFout {
        BigInteger sortering = vraag.getStuurgegevens().getVraag().getSortering();
        if (sortering != null) {
            // empty if block
        }
    }

    private List<Map<String, Object>> getResults(String query, VraagBericht vraag, Connection c) throws BrmoException, SQLException {
        MapListHandler mlh = new MapListHandler();
        QueryRunner qr = new QueryRunner();
        List results = (List)qr.query(c, query, (ResultSetHandler)mlh);
        return results;
    }

    private SynchroonAntwoordBericht.Body createResults(List<Map<String, Object>> resultsMap, VraagBericht vraag) {
        String entiteitType;
        SynchroonAntwoordBericht.Body b = new SynchroonAntwoordBericht.Body();
        switch (entiteitType = vraag.getStuurgegevens().getEntiteittype()) {
            case "PRS": {
                for (Map<String, Object> obj : resultsMap) {
                    PRSAntwoord prs = AntwoordBodyFactory.createPersoon(obj, (PRSVraag)((PRSVraag)vraag.getBody().getPRS().get(2)));
                    prs.setSoortEntiteit("F");
                    String sleutel = obj.get("sc_identif").toString();
                    prs.setSleutelVerzendend(sleutel);
                    prs.setVerwerkingssoort(Verwerkingssoort.I);
                    b.getPRS().add(prs);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Entiteitstype niet ondersteund: " + entiteitType);
            }
        }
        return b;
    }

    private String getXml(Object o) throws JAXBException {
        Marshaller jaxbMarshaller = StUFbg204Util.getStufJaxbContext().createMarshaller();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jaxbMarshaller.marshal(o, (OutputStream)baos);
        return baos.toString();
    }
}

