
package nl.egem.stuf.sector.bg._0204;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import nl.egem.stuf.stuf0204.DatumMetIndicator;
import nl.egem.stuf.stuf0204.ExtraElementen;
import nl.egem.stuf.stuf0204.NoValue;
import nl.egem.stuf.stuf0204.TijdvakGeldigheid;
import nl.egem.stuf.stuf0204.Verwerkingssoort;


/**
 * entiteit adres (ADR).
 * 				Deze entiteit bestaat uit vier deels disjuncte subgroepen:
 * 				Buitenlands adres: AdresBuitenland1,AdresBuitenland2, AdresBuitenland3, Landcode
 * 				Een adres is een buitenlands adres als de landcode is gevuld met waarde ongelijk aan 6030 (de landcode voor Nederland)
 * 				Postbus adres: Postcode, Woonplaatsnaam, Postbusnummer
 * 				Een adres is een postbus adres, als het Postbusnummer is gevuld.
 * 				Antwoordnummer adres: Postcode, Woonplaatsnaam, Antwoordnummer
 * 				Een adres is een antwoordnummer adres, als het Antwoordnummer is gevuld.
 * 				Locatie adres: Postcode, Woonplaatsnaam + plus alle elementen volgend op Antwoordnummer
 * 				Een adres is een locatie-adres in alle overige gevallen
 * 				De kerngegevens voor een adres zijn de kerngegevens die binnen 1 subgroep vallen. De kerngegevens die onderdeel zijn van een andere subgroep mogen niet opgenomen worden.
 * 			
 * 
 * &lt;p&gt;Java class for ADR-fund complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ADR-fund"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="adresBuitenland1" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="adresBuitenland2" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="adresBuitenland3" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="landcode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Landcode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="postcode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Postcode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="woonplaatsnaam" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Woonplaatsnaam"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="postbusnummer" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Postbusnummer"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="antwoordnummer" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Antwoordnummer"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="straatnaam" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Straatnaam"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="huisnummer" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisnummer"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="huisletter" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisletter"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="huisnummertoevoeging" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisnummertoevoeging"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="aanduidingBijHuisnummer" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;AanduidingBijHuisnummer"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="locatieomschrijving" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Locatieomschrijving"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="locatieadresnummer" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Locatieadresnummer"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="ingangsdatum" type="{http://www.egem.nl/StUF/StUF0204}DatumMetIndicator" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="einddatum" type="{http://www.egem.nl/StUF/StUF0204}DatumMetIndicator" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="straatcode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Straatcode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="buurtcode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Buurtcode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR2" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="wijkcode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Wijkcode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR2" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="gemeentecode" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Gemeentecode"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="centroidXCoordinaat" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidXofYCoordinaat"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="centroidYCoordinaat" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidXofYCoordinaat"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="centroidZCoordinaat" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidZCoordinaat"&amp;gt;
 *                 &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
 *                 &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="tijdvakGeldigheid" type="{http://www.egem.nl/StUF/StUF0204}TijdvakGeldigheid" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="extraElementen" type="{http://www.egem.nl/StUF/StUF0204}ExtraElementen" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}fundamenteel"/&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ADR-fund", propOrder = {
    "adresBuitenland1",
    "adresBuitenland2",
    "adresBuitenland3",
    "landcode",
    "postcode",
    "woonplaatsnaam",
    "postbusnummer",
    "antwoordnummer",
    "straatnaam",
    "huisnummer",
    "huisletter",
    "huisnummertoevoeging",
    "aanduidingBijHuisnummer",
    "locatieomschrijving",
    "locatieadresnummer",
    "ingangsdatum",
    "einddatum",
    "straatcode",
    "buurtcode",
    "wijkcode",
    "gemeentecode",
    "centroidXCoordinaat",
    "centroidYCoordinaat",
    "centroidZCoordinaat",
    "tijdvakGeldigheid",
    "extraElementen"
})
@XmlSeeAlso({
    ADRKennisgeving.class,
    ADRVraag.class,
    ADRAntwoord.class
})
public class ADRFund {

    @XmlElementRef(name = "adresBuitenland1", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.AdresBuitenland1> adresBuitenland1;
    @XmlElementRef(name = "adresBuitenland2", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.AdresBuitenland2> adresBuitenland2;
    @XmlElementRef(name = "adresBuitenland3", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.AdresBuitenland3> adresBuitenland3;
    @XmlElementRef(name = "landcode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Landcode> landcode;
    @XmlElementRef(name = "postcode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Postcode> postcode;
    @XmlElementRef(name = "woonplaatsnaam", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Woonplaatsnaam> woonplaatsnaam;
    @XmlElementRef(name = "postbusnummer", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Postbusnummer> postbusnummer;
    @XmlElementRef(name = "antwoordnummer", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Antwoordnummer> antwoordnummer;
    @XmlElementRef(name = "straatnaam", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Straatnaam> straatnaam;
    @XmlElementRef(name = "huisnummer", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Huisnummer> huisnummer;
    @XmlElementRef(name = "huisletter", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Huisletter> huisletter;
    @XmlElementRef(name = "huisnummertoevoeging", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Huisnummertoevoeging> huisnummertoevoeging;
    @XmlElementRef(name = "aanduidingBijHuisnummer", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.AanduidingBijHuisnummer> aanduidingBijHuisnummer;
    @XmlElementRef(name = "locatieomschrijving", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Locatieomschrijving> locatieomschrijving;
    @XmlElementRef(name = "locatieadresnummer", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Locatieadresnummer> locatieadresnummer;
    @XmlElementRef(name = "ingangsdatum", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<DatumMetIndicator> ingangsdatum;
    @XmlElementRef(name = "einddatum", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<DatumMetIndicator> einddatum;
    @XmlElementRef(name = "straatcode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Straatcode> straatcode;
    @XmlElementRef(name = "buurtcode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Buurtcode> buurtcode;
    @XmlElementRef(name = "wijkcode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Wijkcode> wijkcode;
    @XmlElementRef(name = "gemeentecode", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.Gemeentecode> gemeentecode;
    @XmlElementRef(name = "centroidXCoordinaat", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.CentroidXCoordinaat> centroidXCoordinaat;
    @XmlElementRef(name = "centroidYCoordinaat", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.CentroidYCoordinaat> centroidYCoordinaat;
    @XmlElementRef(name = "centroidZCoordinaat", namespace = "http://www.egem.nl/StUF/sector/bg/0204", type = JAXBElement.class, required = false)
    protected JAXBElement<ADRFund.CentroidZCoordinaat> centroidZCoordinaat;
    protected TijdvakGeldigheid tijdvakGeldigheid;
    protected ExtraElementen extraElementen;
    @XmlAttribute(name = "soortEntiteit", required = true)
    protected String soortEntiteit;
    @XmlAttribute(name = "sleutelVerzendend", namespace = "http://www.egem.nl/StUF/StUF0204")
    protected String sleutelVerzendend;
    @XmlAttribute(name = "sleutelOntvangend", namespace = "http://www.egem.nl/StUF/StUF0204")
    protected String sleutelOntvangend;
    @XmlAttribute(name = "sleutelGegevensbeheer", namespace = "http://www.egem.nl/StUF/StUF0204")
    protected String sleutelGegevensbeheer;
    @XmlAttribute(name = "verwerkingssoort", namespace = "http://www.egem.nl/StUF/StUF0204")
    protected Verwerkingssoort verwerkingssoort;
    @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
    protected NoValue noValue;

    /**
     * Gets the value of the adresBuitenland1 property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland1 }{@code >}
     *     
     */
    public JAXBElement<ADRFund.AdresBuitenland1> getAdresBuitenland1() {
        return adresBuitenland1;
    }

    /**
     * Sets the value of the adresBuitenland1 property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland1 }{@code >}
     *     
     */
    public void setAdresBuitenland1(JAXBElement<ADRFund.AdresBuitenland1> value) {
        this.adresBuitenland1 = value;
    }

    /**
     * Gets the value of the adresBuitenland2 property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland2 }{@code >}
     *     
     */
    public JAXBElement<ADRFund.AdresBuitenland2> getAdresBuitenland2() {
        return adresBuitenland2;
    }

    /**
     * Sets the value of the adresBuitenland2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland2 }{@code >}
     *     
     */
    public void setAdresBuitenland2(JAXBElement<ADRFund.AdresBuitenland2> value) {
        this.adresBuitenland2 = value;
    }

    /**
     * Gets the value of the adresBuitenland3 property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland3 }{@code >}
     *     
     */
    public JAXBElement<ADRFund.AdresBuitenland3> getAdresBuitenland3() {
        return adresBuitenland3;
    }

    /**
     * Sets the value of the adresBuitenland3 property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AdresBuitenland3 }{@code >}
     *     
     */
    public void setAdresBuitenland3(JAXBElement<ADRFund.AdresBuitenland3> value) {
        this.adresBuitenland3 = value;
    }

    /**
     * Gets the value of the landcode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Landcode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Landcode> getLandcode() {
        return landcode;
    }

    /**
     * Sets the value of the landcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Landcode }{@code >}
     *     
     */
    public void setLandcode(JAXBElement<ADRFund.Landcode> value) {
        this.landcode = value;
    }

    /**
     * Gets the value of the postcode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Postcode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Postcode> getPostcode() {
        return postcode;
    }

    /**
     * Sets the value of the postcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Postcode }{@code >}
     *     
     */
    public void setPostcode(JAXBElement<ADRFund.Postcode> value) {
        this.postcode = value;
    }

    /**
     * Gets the value of the woonplaatsnaam property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Woonplaatsnaam }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Woonplaatsnaam> getWoonplaatsnaam() {
        return woonplaatsnaam;
    }

    /**
     * Sets the value of the woonplaatsnaam property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Woonplaatsnaam }{@code >}
     *     
     */
    public void setWoonplaatsnaam(JAXBElement<ADRFund.Woonplaatsnaam> value) {
        this.woonplaatsnaam = value;
    }

    /**
     * Gets the value of the postbusnummer property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Postbusnummer }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Postbusnummer> getPostbusnummer() {
        return postbusnummer;
    }

    /**
     * Sets the value of the postbusnummer property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Postbusnummer }{@code >}
     *     
     */
    public void setPostbusnummer(JAXBElement<ADRFund.Postbusnummer> value) {
        this.postbusnummer = value;
    }

    /**
     * Gets the value of the antwoordnummer property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Antwoordnummer }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Antwoordnummer> getAntwoordnummer() {
        return antwoordnummer;
    }

    /**
     * Sets the value of the antwoordnummer property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Antwoordnummer }{@code >}
     *     
     */
    public void setAntwoordnummer(JAXBElement<ADRFund.Antwoordnummer> value) {
        this.antwoordnummer = value;
    }

    /**
     * Gets the value of the straatnaam property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Straatnaam }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Straatnaam> getStraatnaam() {
        return straatnaam;
    }

    /**
     * Sets the value of the straatnaam property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Straatnaam }{@code >}
     *     
     */
    public void setStraatnaam(JAXBElement<ADRFund.Straatnaam> value) {
        this.straatnaam = value;
    }

    /**
     * Gets the value of the huisnummer property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisnummer }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Huisnummer> getHuisnummer() {
        return huisnummer;
    }

    /**
     * Sets the value of the huisnummer property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisnummer }{@code >}
     *     
     */
    public void setHuisnummer(JAXBElement<ADRFund.Huisnummer> value) {
        this.huisnummer = value;
    }

    /**
     * Gets the value of the huisletter property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisletter }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Huisletter> getHuisletter() {
        return huisletter;
    }

    /**
     * Sets the value of the huisletter property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisletter }{@code >}
     *     
     */
    public void setHuisletter(JAXBElement<ADRFund.Huisletter> value) {
        this.huisletter = value;
    }

    /**
     * Gets the value of the huisnummertoevoeging property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisnummertoevoeging }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Huisnummertoevoeging> getHuisnummertoevoeging() {
        return huisnummertoevoeging;
    }

    /**
     * Sets the value of the huisnummertoevoeging property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Huisnummertoevoeging }{@code >}
     *     
     */
    public void setHuisnummertoevoeging(JAXBElement<ADRFund.Huisnummertoevoeging> value) {
        this.huisnummertoevoeging = value;
    }

    /**
     * Gets the value of the aanduidingBijHuisnummer property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AanduidingBijHuisnummer }{@code >}
     *     
     */
    public JAXBElement<ADRFund.AanduidingBijHuisnummer> getAanduidingBijHuisnummer() {
        return aanduidingBijHuisnummer;
    }

    /**
     * Sets the value of the aanduidingBijHuisnummer property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.AanduidingBijHuisnummer }{@code >}
     *     
     */
    public void setAanduidingBijHuisnummer(JAXBElement<ADRFund.AanduidingBijHuisnummer> value) {
        this.aanduidingBijHuisnummer = value;
    }

    /**
     * Gets the value of the locatieomschrijving property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Locatieomschrijving }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Locatieomschrijving> getLocatieomschrijving() {
        return locatieomschrijving;
    }

    /**
     * Sets the value of the locatieomschrijving property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Locatieomschrijving }{@code >}
     *     
     */
    public void setLocatieomschrijving(JAXBElement<ADRFund.Locatieomschrijving> value) {
        this.locatieomschrijving = value;
    }

    /**
     * Gets the value of the locatieadresnummer property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Locatieadresnummer }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Locatieadresnummer> getLocatieadresnummer() {
        return locatieadresnummer;
    }

    /**
     * Sets the value of the locatieadresnummer property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Locatieadresnummer }{@code >}
     *     
     */
    public void setLocatieadresnummer(JAXBElement<ADRFund.Locatieadresnummer> value) {
        this.locatieadresnummer = value;
    }

    /**
     * Gets the value of the ingangsdatum property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link DatumMetIndicator }{@code >}
     *     
     */
    public JAXBElement<DatumMetIndicator> getIngangsdatum() {
        return ingangsdatum;
    }

    /**
     * Sets the value of the ingangsdatum property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link DatumMetIndicator }{@code >}
     *     
     */
    public void setIngangsdatum(JAXBElement<DatumMetIndicator> value) {
        this.ingangsdatum = value;
    }

    /**
     * Gets the value of the einddatum property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link DatumMetIndicator }{@code >}
     *     
     */
    public JAXBElement<DatumMetIndicator> getEinddatum() {
        return einddatum;
    }

    /**
     * Sets the value of the einddatum property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link DatumMetIndicator }{@code >}
     *     
     */
    public void setEinddatum(JAXBElement<DatumMetIndicator> value) {
        this.einddatum = value;
    }

    /**
     * Gets the value of the straatcode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Straatcode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Straatcode> getStraatcode() {
        return straatcode;
    }

    /**
     * Sets the value of the straatcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Straatcode }{@code >}
     *     
     */
    public void setStraatcode(JAXBElement<ADRFund.Straatcode> value) {
        this.straatcode = value;
    }

    /**
     * Gets the value of the buurtcode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Buurtcode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Buurtcode> getBuurtcode() {
        return buurtcode;
    }

    /**
     * Sets the value of the buurtcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Buurtcode }{@code >}
     *     
     */
    public void setBuurtcode(JAXBElement<ADRFund.Buurtcode> value) {
        this.buurtcode = value;
    }

    /**
     * Gets the value of the wijkcode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Wijkcode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Wijkcode> getWijkcode() {
        return wijkcode;
    }

    /**
     * Sets the value of the wijkcode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Wijkcode }{@code >}
     *     
     */
    public void setWijkcode(JAXBElement<ADRFund.Wijkcode> value) {
        this.wijkcode = value;
    }

    /**
     * Gets the value of the gemeentecode property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Gemeentecode }{@code >}
     *     
     */
    public JAXBElement<ADRFund.Gemeentecode> getGemeentecode() {
        return gemeentecode;
    }

    /**
     * Sets the value of the gemeentecode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.Gemeentecode }{@code >}
     *     
     */
    public void setGemeentecode(JAXBElement<ADRFund.Gemeentecode> value) {
        this.gemeentecode = value;
    }

    /**
     * Gets the value of the centroidXCoordinaat property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidXCoordinaat }{@code >}
     *     
     */
    public JAXBElement<ADRFund.CentroidXCoordinaat> getCentroidXCoordinaat() {
        return centroidXCoordinaat;
    }

    /**
     * Sets the value of the centroidXCoordinaat property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidXCoordinaat }{@code >}
     *     
     */
    public void setCentroidXCoordinaat(JAXBElement<ADRFund.CentroidXCoordinaat> value) {
        this.centroidXCoordinaat = value;
    }

    /**
     * Gets the value of the centroidYCoordinaat property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidYCoordinaat }{@code >}
     *     
     */
    public JAXBElement<ADRFund.CentroidYCoordinaat> getCentroidYCoordinaat() {
        return centroidYCoordinaat;
    }

    /**
     * Sets the value of the centroidYCoordinaat property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidYCoordinaat }{@code >}
     *     
     */
    public void setCentroidYCoordinaat(JAXBElement<ADRFund.CentroidYCoordinaat> value) {
        this.centroidYCoordinaat = value;
    }

    /**
     * Gets the value of the centroidZCoordinaat property.
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidZCoordinaat }{@code >}
     *     
     */
    public JAXBElement<ADRFund.CentroidZCoordinaat> getCentroidZCoordinaat() {
        return centroidZCoordinaat;
    }

    /**
     * Sets the value of the centroidZCoordinaat property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link ADRFund.CentroidZCoordinaat }{@code >}
     *     
     */
    public void setCentroidZCoordinaat(JAXBElement<ADRFund.CentroidZCoordinaat> value) {
        this.centroidZCoordinaat = value;
    }

    /**
     * Gets the value of the tijdvakGeldigheid property.
     * 
     * @return
     *     possible object is
     *     {@link TijdvakGeldigheid }
     *     
     */
    public TijdvakGeldigheid getTijdvakGeldigheid() {
        return tijdvakGeldigheid;
    }

    /**
     * Sets the value of the tijdvakGeldigheid property.
     * 
     * @param value
     *     allowed object is
     *     {@link TijdvakGeldigheid }
     *     
     */
    public void setTijdvakGeldigheid(TijdvakGeldigheid value) {
        this.tijdvakGeldigheid = value;
    }

    /**
     * Gets the value of the extraElementen property.
     * 
     * @return
     *     possible object is
     *     {@link ExtraElementen }
     *     
     */
    public ExtraElementen getExtraElementen() {
        return extraElementen;
    }

    /**
     * Sets the value of the extraElementen property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtraElementen }
     *     
     */
    public void setExtraElementen(ExtraElementen value) {
        this.extraElementen = value;
    }

    /**
     * Gets the value of the soortEntiteit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSoortEntiteit() {
        if (soortEntiteit == null) {
            return "F";
        } else {
            return soortEntiteit;
        }
    }

    /**
     * Sets the value of the soortEntiteit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSoortEntiteit(String value) {
        this.soortEntiteit = value;
    }

    /**
     * Gets the value of the sleutelVerzendend property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSleutelVerzendend() {
        return sleutelVerzendend;
    }

    /**
     * Sets the value of the sleutelVerzendend property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSleutelVerzendend(String value) {
        this.sleutelVerzendend = value;
    }

    /**
     * Gets the value of the sleutelOntvangend property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSleutelOntvangend() {
        return sleutelOntvangend;
    }

    /**
     * Sets the value of the sleutelOntvangend property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSleutelOntvangend(String value) {
        this.sleutelOntvangend = value;
    }

    /**
     * Gets the value of the sleutelGegevensbeheer property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSleutelGegevensbeheer() {
        return sleutelGegevensbeheer;
    }

    /**
     * Sets the value of the sleutelGegevensbeheer property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSleutelGegevensbeheer(String value) {
        this.sleutelGegevensbeheer = value;
    }

    /**
     * Gets the value of the verwerkingssoort property.
     * 
     * @return
     *     possible object is
     *     {@link Verwerkingssoort }
     *     
     */
    public Verwerkingssoort getVerwerkingssoort() {
        return verwerkingssoort;
    }

    /**
     * Sets the value of the verwerkingssoort property.
     * 
     * @param value
     *     allowed object is
     *     {@link Verwerkingssoort }
     *     
     */
    public void setVerwerkingssoort(Verwerkingssoort value) {
        this.verwerkingssoort = value;
    }

    /**
     * Gets the value of the noValue property.
     * 
     * @return
     *     possible object is
     *     {@link NoValue }
     *     
     */
    public NoValue getNoValue() {
        return noValue;
    }

    /**
     * Sets the value of the noValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link NoValue }
     *     
     */
    public void setNoValue(NoValue value) {
        this.noValue = value;
    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;AanduidingBijHuisnummer"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class AanduidingBijHuisnummer {

        @XmlValue
        protected nl.egem.stuf.sector.bg._0204.AanduidingBijHuisnummer value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link nl.egem.stuf.sector.bg._0204.AanduidingBijHuisnummer }
         *     
         */
        public nl.egem.stuf.sector.bg._0204.AanduidingBijHuisnummer getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link nl.egem.stuf.sector.bg._0204.AanduidingBijHuisnummer }
         *     
         */
        public void setValue(nl.egem.stuf.sector.bg._0204.AanduidingBijHuisnummer value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class AdresBuitenland1 {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR4";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class AdresBuitenland2 {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR4";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;BuitenlandsadresOms"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class AdresBuitenland3 {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR4";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Antwoordnummer"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Antwoordnummer {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Buurtcode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR2" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Buurtcode {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR2";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidXofYCoordinaat"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class CentroidXCoordinaat {

        @XmlValue
        protected BigDecimal value;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigDecimal }
         *     
         */
        public BigDecimal getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigDecimal }
         *     
         */
        public void setValue(BigDecimal value) {
            this.value = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR3";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidXofYCoordinaat"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class CentroidYCoordinaat {

        @XmlValue
        protected BigDecimal value;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigDecimal }
         *     
         */
        public BigDecimal getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigDecimal }
         *     
         */
        public void setValue(BigDecimal value) {
            this.value = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR3";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;CentroidZCoordinaat"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR3" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class CentroidZCoordinaat {

        @XmlValue
        protected BigDecimal value;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigDecimal }
         *     
         */
        public BigDecimal getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigDecimal }
         *     
         */
        public void setValue(BigDecimal value) {
            this.value = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR3";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Gemeentecode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Gemeentecode {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisletter"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Huisletter {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisnummer"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Huisnummer {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Huisnummertoevoeging"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Huisnummertoevoeging {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Landcode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR4" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Landcode {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR4";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Locatieadresnummer"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Locatieadresnummer {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Locatieomschrijving"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Locatieomschrijving {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Postbusnummer"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Postbusnummer {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Postcode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Postcode {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Straatcode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Straatcode {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Straatnaam"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR1" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Straatnaam {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR1";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Wijkcode"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="gegevengroep" type="{http://www.w3.org/2001/XMLSchema}string" fixed="ADR2" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Wijkcode {

        @XmlValue
        protected BigInteger value;
        @XmlAttribute(name = "gegevengroep")
        protected String gegevengroep;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setValue(BigInteger value) {
            this.value = value;
        }

        /**
         * Gets the value of the gegevengroep property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getGegevengroep() {
            if (gegevengroep == null) {
                return "ADR2";
            } else {
                return gegevengroep;
            }
        }

        /**
         * Sets the value of the gegevengroep property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setGegevengroep(String value) {
            this.gegevengroep = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.egem.nl/StUF/sector/bg/0204&amp;gt;Woonplaatsnaam"&amp;gt;
     *       &amp;lt;attGroup ref="{http://www.egem.nl/StUF/StUF0204}element"/&amp;gt;
     *       &amp;lt;attribute name="kerngegeven" type="{http://www.w3.org/2001/XMLSchema}boolean" fixed="true" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    public static class Woonplaatsnaam {

        @XmlValue
        protected String value;
        @XmlAttribute(name = "kerngegeven")
        protected Boolean kerngegeven;
        @XmlAttribute(name = "noValue", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected NoValue noValue;
        @XmlAttribute(name = "exact", namespace = "http://www.egem.nl/StUF/StUF0204")
        protected Boolean exact;

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(String value) {
            this.value = value;
        }

        /**
         * Gets the value of the kerngegeven property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isKerngegeven() {
            if (kerngegeven == null) {
                return true;
            } else {
                return kerngegeven;
            }
        }

        /**
         * Sets the value of the kerngegeven property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setKerngegeven(Boolean value) {
            this.kerngegeven = value;
        }

        /**
         * Gets the value of the noValue property.
         * 
         * @return
         *     possible object is
         *     {@link NoValue }
         *     
         */
        public NoValue getNoValue() {
            return noValue;
        }

        /**
         * Sets the value of the noValue property.
         * 
         * @param value
         *     allowed object is
         *     {@link NoValue }
         *     
         */
        public void setNoValue(NoValue value) {
            this.noValue = value;
        }

        /**
         * Gets the value of the exact property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isExact() {
            if (exact == null) {
                return true;
            } else {
                return exact;
            }
        }

        /**
         * Sets the value of the exact property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setExact(Boolean value) {
            this.exact = value;
        }

    }

}
