/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.stufbg204;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.egem.stuf.sector.bg._0204.ANummerE;
import nl.egem.stuf.sector.bg._0204.AdellijkeTitelPredikaatE;
import nl.egem.stuf.sector.bg._0204.BsnNummerE;
import nl.egem.stuf.sector.bg._0204.CodeGeboortelandE;
import nl.egem.stuf.sector.bg._0204.GeboortedatumE;
import nl.egem.stuf.sector.bg._0204.GeboorteplaatsE;
import nl.egem.stuf.sector.bg._0204.GeslachtsaanduidingE;
import nl.egem.stuf.sector.bg._0204.GeslachtsnaamE;
import nl.egem.stuf.sector.bg._0204.PRSFund;
import nl.egem.stuf.sector.bg._0204.PRSVraag;
import nl.egem.stuf.sector.bg._0204.VoorlettersE;
import nl.egem.stuf.sector.bg._0204.VoornamenE;
import nl.egem.stuf.sector.bg._0204.VoorvoegselGeslachtsnaamE;
import nl.egem.stuf.sector.bg._0204.VraagBericht;
import nl.egem.stuf.stuf0204.DatumMetIndicator;

public class CriteriaParser {
    private static final Map<String, String> vraagToColumn = new HashMap();

    public String getCriteria(VraagBericht bericht) throws IllegalArgumentException, UnsupportedOperationException {
        String q;
        String entiteitType = bericht.getStuurgegevens().getEntiteittype();
        VraagBericht.Body b = bericht.getBody();
        switch (entiteitType) {
            case "PRS": {
                q = this.getPRSCriterias(b);
                break;
            }
            default: {
                throw new IllegalArgumentException("Entiteitstype niet ondersteund: " + entiteitType);
            }
        }
        if (q != null) {
            q = "WHERE " + q;
        }
        return q;
    }

    private String getPRSCriterias(VraagBericht.Body b) throws IllegalArgumentException, UnsupportedOperationException {
        List prs = b.getPRS();
        String from = this.getPRSCriteria((PRSVraag)prs.get(0), true);
        String toCheck = this.getPRSCriteria((PRSVraag)prs.get(1), true);
        String to = this.getPRSCriteria((PRSVraag)prs.get(1), false);
        if (from == null && to == null) {
            return null;
        }
        String q = from.equals(toCheck) ? from.replace(">", "=") : from + " AND " + to;
        return q;
    }

    private String getPRSCriteria(PRSVraag prs, boolean first) throws IllegalArgumentException, UnsupportedOperationException {
        String vraag = null;
        Object value = null;
        boolean exact = true;
        if (prs.getANummer() != null) {
            vraag = prs.getANummer().getName().getLocalPart();
            value = ((ANummerE)prs.getANummer().getValue()).getValue();
            exact = ((ANummerE)prs.getANummer().getValue()).isExact();
        } else if (prs.getBsnNummer() != null) {
            vraag = prs.getBsnNummer().getName().getLocalPart();
            value = ((BsnNummerE)prs.getBsnNummer().getValue()).getValue();
            exact = ((BsnNummerE)prs.getBsnNummer().getValue()).isExact();
        } else if (prs.getGeboortedatum() != null) {
            vraag = prs.getGeboortedatum().getName().getLocalPart();
            value = ((GeboortedatumE)prs.getGeboortedatum().getValue()).getValue();
            exact = ((GeboortedatumE)prs.getGeboortedatum().getValue()).isExact();
        } else if (prs.getVoornamen() != null) {
            vraag = prs.getVoornamen().getName().getLocalPart();
            value = ((VoornamenE)prs.getVoornamen().getValue()).getValue();
            exact = ((VoornamenE)prs.getVoornamen().getValue()).isExact();
        } else if (prs.getVoorletters() != null) {
            vraag = prs.getVoorletters().getName().getLocalPart();
            value = ((VoorlettersE)prs.getVoorletters().getValue()).getValue();
            exact = ((VoorlettersE)prs.getVoorletters().getValue()).isExact();
        } else if (prs.getVoorvoegselGeslachtsnaam() != null) {
            vraag = prs.getVoorvoegselGeslachtsnaam().getName().getLocalPart();
            value = ((VoorvoegselGeslachtsnaamE)prs.getVoorvoegselGeslachtsnaam().getValue()).getValue();
            exact = ((VoorvoegselGeslachtsnaamE)prs.getVoorvoegselGeslachtsnaam().getValue()).isExact();
        } else if (prs.getGeslachtsnaam() != null) {
            vraag = prs.getGeslachtsnaam().getName().getLocalPart();
            value = ((GeslachtsnaamE)prs.getGeslachtsnaam().getValue()).getValue();
            exact = ((GeslachtsnaamE)prs.getGeslachtsnaam().getValue()).isExact();
        } else if (prs.getGeboorteplaats() != null) {
            vraag = prs.getGeboorteplaats().getName().getLocalPart();
            value = ((GeboorteplaatsE)prs.getGeboorteplaats().getValue()).getValue();
            exact = ((GeboorteplaatsE)prs.getGeboorteplaats().getValue()).isExact();
        } else if (prs.getCodeGeboorteland() != null) {
            vraag = prs.getCodeGeboorteland().getName().getLocalPart();
            value = ((CodeGeboortelandE)prs.getCodeGeboorteland().getValue()).getValue();
            exact = ((CodeGeboortelandE)prs.getCodeGeboorteland().getValue()).isExact();
        } else if (prs.getGeslachtsaanduiding() != null) {
            vraag = prs.getGeslachtsaanduiding().getName().getLocalPart();
            value = ((GeslachtsaanduidingE)prs.getGeslachtsaanduiding().getValue()).getValue();
            exact = ((GeslachtsaanduidingE)prs.getGeslachtsaanduiding().getValue()).isExact();
        } else if (prs.getDatumOverlijden() != null) {
            vraag = prs.getDatumOverlijden().getName().getLocalPart();
            value = ((DatumMetIndicator)prs.getDatumOverlijden().getValue()).getValue();
            exact = ((DatumMetIndicator)prs.getDatumOverlijden().getValue()).isExact();
        } else if (prs.getPlaatsOverlijden() != null) {
            vraag = prs.getPlaatsOverlijden().getName().getLocalPart();
            value = ((PRSFund.PlaatsOverlijden)prs.getPlaatsOverlijden().getValue()).getValue();
            exact = ((PRSFund.PlaatsOverlijden)prs.getPlaatsOverlijden().getValue()).isExact();
        } else if (prs.getCodeLandOverlijden() != null) {
            vraag = prs.getCodeLandOverlijden().getName().getLocalPart();
            value = ((PRSFund.CodeLandOverlijden)prs.getCodeLandOverlijden().getValue()).getValue();
            exact = ((PRSFund.CodeLandOverlijden)prs.getCodeLandOverlijden().getValue()).isExact();
        } else if (prs.getIndicatieGeheim() != null) {
            vraag = prs.getIndicatieGeheim().getName().getLocalPart();
            value = ((PRSFund.IndicatieGeheim)prs.getIndicatieGeheim().getValue()).getValue();
            exact = ((PRSFund.IndicatieGeheim)prs.getIndicatieGeheim().getValue()).isExact();
        } else if (prs.getAdellijkeTitelPredikaat() != null) {
            vraag = prs.getAdellijkeTitelPredikaat().getName().getLocalPart();
            value = ((AdellijkeTitelPredikaatE)prs.getAdellijkeTitelPredikaat().getValue()).getValue();
            exact = ((AdellijkeTitelPredikaatE)prs.getAdellijkeTitelPredikaat().getValue()).isExact();
        } else if (prs.getCodeGemeenteVanInschrijving() != null) {
            vraag = prs.getCodeGemeenteVanInschrijving().getName().getLocalPart();
            value = ((PRSFund.CodeGemeenteVanInschrijving)prs.getCodeGemeenteVanInschrijving().getValue()).getValue();
            exact = ((PRSFund.CodeGemeenteVanInschrijving)prs.getCodeGemeenteVanInschrijving().getValue()).isExact();
        } else if (prs.getDatumInschrijvingGemeente() != null) {
            vraag = prs.getDatumInschrijvingGemeente().getName().getLocalPart();
            value = ((DatumMetIndicator)prs.getDatumInschrijvingGemeente().getValue()).getValue();
            exact = ((DatumMetIndicator)prs.getDatumInschrijvingGemeente().getValue()).isExact();
        } else if (prs.getDatumOpschortingBijhouding() != null) {
            vraag = prs.getDatumOpschortingBijhouding().getName().getLocalPart();
            value = ((DatumMetIndicator)prs.getDatumOpschortingBijhouding().getValue()).getValue();
            exact = ((DatumMetIndicator)prs.getDatumOpschortingBijhouding().getValue()).isExact();
        } else if (prs.getOmschrijvingRedenOpschortingBijhouding() != null) {
            vraag = prs.getOmschrijvingRedenOpschortingBijhouding().getName().getLocalPart();
            value = ((PRSFund.OmschrijvingRedenOpschortingBijhouding)prs.getOmschrijvingRedenOpschortingBijhouding().getValue()).getValue();
            exact = ((PRSFund.OmschrijvingRedenOpschortingBijhouding)prs.getOmschrijvingRedenOpschortingBijhouding().getValue()).isExact();
        } else if (prs.getCodeLandEmigratie() != null) {
            vraag = prs.getCodeLandEmigratie().getName().getLocalPart();
            value = ((PRSFund.CodeLandEmigratie)prs.getCodeLandEmigratie().getValue()).getValue();
            exact = ((PRSFund.CodeLandEmigratie)prs.getCodeLandEmigratie().getValue()).isExact();
        } else if (prs.getDatumVertrekUitNederland() != null) {
            vraag = prs.getDatumVertrekUitNederland().getName().getLocalPart();
            value = ((DatumMetIndicator)prs.getDatumVertrekUitNederland().getValue()).getValue();
            exact = ((DatumMetIndicator)prs.getDatumVertrekUitNederland().getValue()).isExact();
        } else if (prs.getCodeLandImmigratie() != null) {
            vraag = prs.getCodeLandImmigratie().getName().getLocalPart();
            value = ((PRSFund.CodeLandImmigratie)prs.getCodeLandImmigratie().getValue()).getValue();
            exact = ((PRSFund.CodeLandImmigratie)prs.getCodeLandImmigratie().getValue()).isExact();
        } else if (prs.getDatumVestigingInNederland() != null) {
            vraag = prs.getDatumVestigingInNederland().getName().getLocalPart();
            value = ((DatumMetIndicator)prs.getDatumVestigingInNederland().getValue()).getValue();
            exact = ((DatumMetIndicator)prs.getDatumVestigingInNederland().getValue()).isExact();
        } else if (prs.getIndicatieGezagMinderjarige() != null) {
            vraag = prs.getIndicatieGezagMinderjarige().getName().getLocalPart();
            value = ((PRSFund.IndicatieGezagMinderjarige)prs.getIndicatieGezagMinderjarige().getValue()).getValue();
            exact = ((PRSFund.IndicatieGezagMinderjarige)prs.getIndicatieGezagMinderjarige().getValue()).isExact();
        } else if (prs.getIndicatieCuratelestelling() != null) {
            vraag = prs.getIndicatieCuratelestelling().getName().getLocalPart();
            value = ((PRSFund.IndicatieCuratelestelling)prs.getIndicatieCuratelestelling().getValue()).getValue();
            exact = ((PRSFund.IndicatieCuratelestelling)prs.getIndicatieCuratelestelling().getValue()).isExact();
        } else if (prs.getVerblijfstitel() != null) {
            vraag = prs.getVerblijfstitel().getName().getLocalPart();
            value = ((PRSFund.Verblijfstitel)prs.getVerblijfstitel().getValue()).getValue();
            exact = ((PRSFund.Verblijfstitel)prs.getVerblijfstitel().getValue()).isExact();
        } else if (prs.getDatumVerkrijgingVerblijfstitel() != null) {
            vraag = prs.getDatumVerkrijgingVerblijfstitel().getName().getLocalPart();
            value = ((PRSFund.DatumVerkrijgingVerblijfstitel)prs.getDatumVerkrijgingVerblijfstitel().getValue()).getValue();
            exact = ((PRSFund.DatumVerkrijgingVerblijfstitel)prs.getDatumVerkrijgingVerblijfstitel().getValue()).isExact();
        } else if (prs.getDatumVerliesVerblijfstitel() != null) {
            vraag = prs.getDatumVerliesVerblijfstitel().getName().getLocalPart();
            value = ((PRSFund.DatumVerliesVerblijfstitel)prs.getDatumVerliesVerblijfstitel().getValue()).getValue();
            exact = ((PRSFund.DatumVerliesVerblijfstitel)prs.getDatumVerliesVerblijfstitel().getValue()).isExact();
        } else if (prs.getAanduidingBijzonderNederlanderschap() != null) {
            vraag = prs.getAanduidingBijzonderNederlanderschap().getName().getLocalPart();
            value = ((PRSFund.AanduidingBijzonderNederlanderschap)prs.getAanduidingBijzonderNederlanderschap().getValue()).getValue();
            exact = ((PRSFund.AanduidingBijzonderNederlanderschap)prs.getAanduidingBijzonderNederlanderschap().getValue()).isExact();
        } else if (prs.getBurgerlijkeStaat() != null) {
            vraag = prs.getBurgerlijkeStaat().getName().getLocalPart();
            value = ((PRSFund.BurgerlijkeStaat)prs.getBurgerlijkeStaat().getValue()).getValue();
            exact = ((PRSFund.BurgerlijkeStaat)prs.getBurgerlijkeStaat().getValue()).isExact();
        } else if (prs.getAanduidingNaamgebruik() != null) {
            vraag = prs.getAanduidingNaamgebruik().getName().getLocalPart();
            value = ((PRSFund.AanduidingNaamgebruik)prs.getAanduidingNaamgebruik().getValue()).getValue();
            exact = ((PRSFund.AanduidingNaamgebruik)prs.getAanduidingNaamgebruik().getValue()).isExact();
        }
        String column = (String)vraagToColumn.get(vraag);
        if (vraag == null) {
            return null;
        }
        if (column == null) {
            throw new IllegalArgumentException("Request filtercolumn not supported: " + vraag);
        }
        String operator = null;
        String quote = "";
        String wildcard = "";
        boolean valueIsString = value instanceof String;
        if (valueIsString) {
            quote = "'";
        }
        if (!exact && !valueIsString) {
            throw new UnsupportedOperationException("Inexacte datums niet ondersteund");
        }
        if (exact) {
            operator = first ? " > " : " <= ";
        } else {
            wildcard = "%";
            operator = " LIKE ";
        }
        String valuePart = quote + wildcard + String.valueOf(value) + wildcard + quote;
        String query = column + operator + valuePart;
        return query;
    }

    static {
        vraagToColumn.put("voornamen", "nm_voornamen");
        vraagToColumn.put("voorletters", "na_voorletters_aanschrijving");
        vraagToColumn.put("voorvoegselGeslachtsnaam", "nm_voorvoegsel_geslachtsnaam");
        vraagToColumn.put("geslachtsnaam", "nm_geslachtsnaam");
        vraagToColumn.put("adellijkeTitelPredikaat", "nm_adellijke_titel_predikaat");
        vraagToColumn.put("geslachtsaanduiding", "geslachtsaand");
        vraagToColumn.put("academischeTitel", "fk_2acd_code");
        vraagToColumn.put("aanduidingNaamgebruik", "aand_naamgebruik");
        vraagToColumn.put("aNummer", "a_nummer");
        vraagToColumn.put("bsn-nummer", "bsn");
        vraagToColumn.put("burgerlijkeStaat", "burgerlijke_staat");
        vraagToColumn.put("geboortedatum", "gb_geboortedatum");
        vraagToColumn.put("datumInschrijvingGemeente", "datum_inschrijving_in_gemeente");
        vraagToColumn.put("datumVerkrijgingVerblijfstitel", "datum_verkr_nation");
        vraagToColumn.put("datumVerliesVerblijfstitel", "datum_verlies_nation");
        vraagToColumn.put("datumVertrekUitNederland", "datum_vertrek_uit_nederland");
        vraagToColumn.put("datumVestigingInNederland", "datum_vestg_in_nederland");
        vraagToColumn.put("codeGemeenteVanInschrijving", "gemeente_van_inschrijving");
        vraagToColumn.put("geboorteplaats", "gb_geboorteplaats");
        vraagToColumn.put("codeGeboorteland", "fk_gb_lnd_code_iso");
        vraagToColumn.put("datumOverlijden", "ol_overlijdensdatum");
        vraagToColumn.put("plaatsOverlijden", "fk_gb_lnd_code_iso");
        vraagToColumn.put("codeLandOverlijden", "fk_ol_lnd_code_iso");
        vraagToColumn.put("datumOpschortingBijhouding", "datum_opschorting_bijhouding");
        vraagToColumn.put("omschrijvingRedenOpschortingBijhouding", "reden_opschorting_bijhouding");
        vraagToColumn.put("eMailAdres", "emailadres");
        vraagToColumn.put("telefoonnummer", "telefoonnummer");
        vraagToColumn.put("bankgiroRekeningnummer", "rn_bankrekeningnummer");
        vraagToColumn.put("faxnummer", "fax_nummer");
        vraagToColumn.put("indicatieGeheim", "");
        vraagToColumn.put("prsadrcor", "");
        vraagToColumn.put("prsadrins", "");
        vraagToColumn.put("prsadrvbl", "");
        vraagToColumn.put("prsidb", "");
        vraagToColumn.put("prsnat", "");
        vraagToColumn.put("prsprshuw", "");
        vraagToColumn.put("prsprsknd", "");
        vraagToColumn.put("prsprsoud", "");
        vraagToColumn.put("codeLandEmigratie", "");
        vraagToColumn.put("codeLandImmigratie", "");
        vraagToColumn.put("indicatieGezagMinderjarige", "");
        vraagToColumn.put("indicatieCuratelestelling", "");
        vraagToColumn.put("verblijfstitel", "");
        vraagToColumn.put("aanduidingBijzonderNederlanderschap", "");
        vraagToColumn.put("subjectnrAKR", "");
        vraagToColumn.put("tijdvakGeldigheid", "");
        vraagToColumn.put("extraElementen", "");
    }
}

