/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.stufbg204;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import nl.b3p.brmo.stufbg204.StUFBGasynchroon;
import nl.b3p.brmo.stufbg204.util.StUFbg204Util;
import nl.egem.stuf.sector.bg._0204.AsynchroonAntwoordBericht;
import nl.egem.stuf.sector.bg._0204.KennisgevingsBericht;
import nl.egem.stuf.sector.bg._0204.VraagBericht;
import nl.egem.stuf.stuf0204.BevestigingsBericht;
import nl.egem.stuf.stuf0204.FoutBericht;
import nl.egem.stuf.stuf0204.Stuurgegevens;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@WebService(serviceName="StUFBGAsynchroon", portName="StUFBGAsynchronePort", endpointInterface="nl.egem.stuf.sector.bg._0204.StUFBGAsynchroonPortType", targetNamespace="http://www.egem.nl/StUF/sector/bg/0204", wsdlLocation="WEB-INF/wsdl/bg0204.wsdl")
@HandlerChain(file="/handler-chain.xml")
public class StUFBGasynchroon {
    private static final Log LOG = LogFactory.getLog(StUFBGasynchroon.class);
    private static final String XMLNAMESPACE = "xmlns";

    public BevestigingsBericht ontvangAsynchroneVraag(VraagBericht vraag) {
        LOG.debug((Object)("Er is een vraag ontvangen van soort: " + vraag.getStuurgegevens().getBerichtsoort()));
        BevestigingsBericht b = new BevestigingsBericht();
        b.setStuurgegevens(StUFbg204Util.maakStuurgegevens((Stuurgegevens)vraag.getStuurgegevens()));
        return b;
    }

    public BevestigingsBericht ontvangAsynchroonAntwoord(AsynchroonAntwoordBericht asynchroonAntwoord) {
        LOG.debug((Object)("Er is een antwoord ontvangen van soort: " + asynchroonAntwoord.getStuurgegevens().getBerichtsoort()));
        BevestigingsBericht b = new BevestigingsBericht();
        b.setStuurgegevens(StUFbg204Util.maakStuurgegevens((Stuurgegevens)asynchroonAntwoord.getStuurgegevens()));
        return b;
    }

    public BevestigingsBericht ontvangFout(FoutBericht fout) {
        LOG.debug((Object)("Er is een fout ontvangen van soort: " + fout.getStuurgegevens().getBerichtsoort()));
        BevestigingsBericht b = new BevestigingsBericht();
        b.setStuurgegevens(StUFbg204Util.maakStuurgegevens((Stuurgegevens)fout.getStuurgegevens()));
        return b;
    }

    public BevestigingsBericht ontvangKennisgeving(KennisgevingsBericht kennisgeving) {
        LOG.debug((Object)("Er is een kennisgeving ontvangen van soort: " + kennisgeving.getStuurgegevens().getBerichtsoort() + " en mutatiesoort " + String.valueOf(kennisgeving.getStuurgegevens().getKennisgeving().getMutatiesoort())));
        BevestigingsBericht b = new BevestigingsBericht();
        b.setStuurgegevens(StUFbg204Util.maakStuurgegevens((Stuurgegevens)kennisgeving.getStuurgegevens()));
        switch (1.$SwitchMap$nl$egem$stuf$stuf0204$Mutatiesoort[kennisgeving.getStuurgegevens().getKennisgeving().getMutatiesoort().ordinal()]) {
            case 1: {
                this.saveBericht((Object)kennisgeving, kennisgeving.getStuurgegevens().getKennisgeving().getTijdstipMutatie());
                break;
            }
            case 2: 
            case 3: {
                this.saveBericht((Object)kennisgeving, kennisgeving.getStuurgegevens().getKennisgeving().getTijdstipMutatie());
                break;
            }
            default: {
                LOG.warn((Object)"Onbekende mutatiesoort wordt niet verwerkt.");
            }
        }
        return b;
    }

    private void saveBericht(Object body, String datum) {
        try {
            DataSource ds = ConfigUtil.getDataSourceStaging();
            BrmoFramework brmo = new BrmoFramework(ds, null, null);
            InputStream in = this.getXml(body);
            Date d = StUFbg204Util.sdf.parse(datum);
            String bestand_naam = "StUF-BG upload op " + StUFbg204Util.sdf.format(new Date());
            brmo.loadFromStream("brp", in, bestand_naam, d, null);
            brmo.closeBrmoFramework();
        }
        catch (BrmoException ex) {
            LOG.error((Object)"Fout tijdens laden van StUF-BG bericht", (Throwable)ex);
        }
        catch (ParseException | JAXBException ex) {
            LOG.error((Object)"Fout tijdens parsen van bericht", ex);
        }
    }

    private InputStream getXml(Object o) throws JAXBException {
        try {
            Marshaller jaxbMarshaller = StUFbg204Util.getStufJaxbContext().createMarshaller();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            jaxbMarshaller.marshal(o, (OutputStream)baos);
            ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            ArrayList prefixes = new ArrayList();
            StUFBGasynchroon.getPrefixesRecursive((Element)doc.getDocumentElement(), prefixes);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//*[local-name() = 'body']/*");
            NodeList nodelist = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            Document newDoc = builder.newDocument();
            Element root = newDoc.createElement("root");
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Node n = nodelist.item(i);
                Node newNode = newDoc.importNode(n, true);
                root.appendChild(newNode);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(root), new StreamResult(outputStream));
            ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
            return is;
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException ex) {
            LOG.error((Object)"Cannot parse body", (Throwable)ex);
            return null;
        }
    }

    public static void getPrefixesRecursive(Element element, List<AbstractMap.SimpleEntry<String, String>> prefixes) {
        StUFBGasynchroon.getPrefixes((Element)element, prefixes);
        Node parent = element.getParentNode();
        if (parent instanceof Element) {
            StUFBGasynchroon.getPrefixesRecursive((Element)((Element)parent), prefixes);
        }
    }

    public static void getPrefixes(Element element, List<AbstractMap.SimpleEntry<String, String>> prefixes) {
        NamedNodeMap atts = element.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node = atts.item(i);
            String name = node.getNodeName();
            if (name == null || !"xmlns".equals(name) && !name.startsWith("xmlns:")) continue;
            AbstractMap.SimpleEntry<String, String> s = new AbstractMap.SimpleEntry<String, String>(name, node.getNodeValue());
            prefixes.add(s);
        }
    }
}

