/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.test.util.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ViewUtils {
    private static final Log LOG = LogFactory.getLog(ViewUtils.class);

    public static List<String> listAllMaterializedViews(BasicDataSource ds) throws SQLException {
        List mviews;
        try (Connection conn = ds.getConnection();){
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            mviews = (List)new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(conn, geomToJdbc.getMViewsSQL(), (ResultSetHandler)new ColumnListHandler());
            LOG.debug((Object)("Gevonden materialized views: " + mviews));
        }
        return mviews;
    }

    public static void refreshAllMaterializedViews(BasicDataSource ds) throws SQLException {
        List<String> mviews = ViewUtils.listAllMaterializedViews(ds);
        if (mviews != null && mviews.size() > 1) {
            ViewUtils.refreshMViews(mviews.toArray(new String[mviews.size()]), ds);
        }
    }

    public static void refreshMViews(String[] mviews, BasicDataSource ds) throws SQLException {
        try (Connection conn = ds.getConnection();){
            conn.setAutoCommit(true);
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            for (String mview : mviews) {
                try {
                    LOG.debug((Object)("Start verversen van materialized view: " + mview));
                    Integer o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).update(conn, geomToJdbc.getMViewRefreshSQL(mview));
                    LOG.trace((Object)("Klaar met verversen van materialized view: " + mview));
                }
                catch (SQLException sqle) {
                    LOG.error((Object)("Bijwerken van materialized view `" + mview + "` is mislukt. "), (Throwable)sqle);
                }
            }
        }
    }

    private ViewUtils() {
    }
}

