/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.test.util.database;

import java.sql.Connection;
import java.sql.SQLException;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceUtil {
    private static final Log LOG = LogFactory.getLog(SequenceUtil.class);

    private SequenceUtil() {
    }

    public static void updateSequence(String sequenceName, long nextVal, BasicDataSource ds) throws SQLException {
        try (Connection conn = ds.getConnection();){
            conn.setAutoCommit(true);
            GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)conn);
            LOG.debug((Object)("update sequence: " + sequenceName));
            int rowsUpdated = new QueryRunner(geomToJdbc.isPmdKnownBroken()).execute(conn, geomToJdbc.getUpdateSequenceSQL(sequenceName, nextVal), new Object[0]);
            LOG.trace((Object)("updated sequence: " + sequenceName + ", " + rowsUpdated + " rows updated met SQL: " + geomToJdbc.getUpdateSequenceSQL(sequenceName, nextVal)));
        }
    }
}

