/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.test.util.database.dbunit;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;

public class DropAllTablesOperation
extends DatabaseOperation {
    private static final Log LOG = LogFactory.getLog(DropAllTablesOperation.class);
    private final String DROP_PGSQL = "drop table %s cascade";
    private final String DROP_ORACLE = "drop table %s cascade purge";

    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        DatabaseSequenceFilter filter = new DatabaseSequenceFilter(connection);
        String dropStmt = connection.getConfig().getProperty("http://www.dbunit.org/properties/datatypeFactory").getClass().getName().contains("Oracle") ? "drop table %s cascade purge" : "drop table %s cascade";
        FilteredDataSet dataset = null == dataSet ? new FilteredDataSet((ITableFilter)filter, connection.createDataSet()) : new FilteredDataSet((ITableFilter)filter, dataSet);
        LOG.debug((Object)("to be dropped table names: " + Arrays.toString(dataset.getTableNames())));
        String[] tableNames = dataset.getTableNames();
        List<String> reversedTableNames = Arrays.asList(tableNames);
        Collections.reverse(reversedTableNames);
        LOG.debug((Object)("to be dropped table names in order: " + Arrays.toString(dataset.getTableNames())));
        try (Statement stmt = connection.getConnection().createStatement();){
            for (String table : reversedTableNames) {
                stmt.addBatch(String.format(dropStmt, table));
            }
            stmt.executeBatch();
        }
    }
}

