/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import nl.b3p.topnl.Database;
import nl.b3p.topnl.TopNLType;
import nl.b3p.topnl.TopNLTypeFactory;
import nl.b3p.topnl.converters.Converter;
import nl.b3p.topnl.converters.ConverterFactory;
import nl.b3p.topnl.entities.TopNLEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.locationtech.jts.io.ParseException;
import org.xml.sax.SAXException;

public class Processor {
    protected static final Log log = LogFactory.getLog(Processor.class);
    private Database database;
    private ConverterFactory converterFactory;
    private STATUS status = STATUS.OK;

    public Processor(DataSource ds) throws JAXBException, SQLException {
        this.database = new Database(ds);
        this.converterFactory = new ConverterFactory();
    }

    public void importIntoDb(URL in, TopNLType type) throws JDOMException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        this.resetStatus();
        try {
            log.info((Object)("Importing file " + in.toExternalForm() + ", type: " + type.getType()));
            Unmarshaller jaxbUnmarshaller = this.converterFactory.getContext(type).createUnmarshaller();
            XMLStreamReader xsr = xif.createXMLStreamReader(in.openStream());
            LocationListener ll = new LocationListener(xsr);
            jaxbUnmarshaller.setListener((Unmarshaller.Listener)ll);
            while (xsr.hasNext()) {
                int eventType = xsr.next();
                if (eventType != 1) continue;
                String localname = xsr.getLocalName();
                if (!xsr.getLocalName().equals("FeatureMember")) continue;
                JAXBElement jb = null;
                try {
                    jb = (JAXBElement)jaxbUnmarshaller.unmarshal(xsr);
                    Object obj = jb.getValue();
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(obj);
                    List<TopNLEntity> entities = this.convert(list, type);
                    this.save(entities, type);
                }
                catch (SQLException ex) {
                    log.error((Object)"Error inserting", (Throwable)ex);
                    this.status = STATUS.NOK;
                }
                catch (IOException | IllegalArgumentException | JAXBException | ParserConfigurationException | TransformerException | ParseException | SAXException ex) {
                    log.error((Object)"Error parsing", ex);
                    this.status = STATUS.NOK;
                }
                catch (ClassCastException cce) {
                    log.error((Object)String.format(Locale.ROOT, "Verwerkingsfout van element %s locatie %s", localname, jb == null ? "onbekend" : ll.getLocation(jb)), (Throwable)cce);
                }
            }
            xsr.close();
        }
        catch (IOException | JAXBException | XMLStreamException ex) {
            this.status = STATUS.NOK;
            log.error((Object)"cannot correctly stream xml file:", ex);
        }
    }

    public List parse(URL in) throws JAXBException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            TopNLType type = TopNLTypeFactory.getTopNLType(in);
            Unmarshaller jaxbUnmarshaller = this.converterFactory.getContext(type).createUnmarshaller();
            XMLInputFactory xif = XMLInputFactory.newFactory();
            XMLStreamReader xsr = xif.createXMLStreamReader(in.openStream());
            while (xsr.hasNext()) {
                int eventType = xsr.next();
                if (eventType != 1) continue;
                String localname = xsr.getLocalName();
                if (!xsr.getLocalName().equals("FeatureMember")) continue;
                JAXBElement jb = (JAXBElement)jaxbUnmarshaller.unmarshal(xsr);
                list.add(jb.getValue());
            }
            xsr.close();
        }
        catch (XMLStreamException ex) {
            log.error((Object)"cannot correctly stream xml file:", (Throwable)ex);
        }
        catch (JDOMException ex) {
            log.error((Object)"Cannot retrieve topnltype: ", (Throwable)ex);
        }
        return list;
    }

    public List<TopNLEntity> convert(List listOfJaxbObjects, TopNLType type) throws IOException, SAXException, ParserConfigurationException, TransformerException, ClassCastException {
        Converter converter = this.converterFactory.getConverter(type);
        List<TopNLEntity> entity = converter.convert(listOfJaxbObjects);
        return entity;
    }

    public void save(TopNLEntity entity, TopNLType type) throws ParseException, SQLException {
        this.database.save(entity);
    }

    public void save(List<TopNLEntity> entities, TopNLType type) throws ParseException, SQLException {
        for (TopNLEntity entity : entities) {
            this.save(entity, type);
        }
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void resetStatus() {
        this.status = STATUS.OK;
    }

    private static class LocationListener
    extends Unmarshaller.Listener {
        private XMLStreamReader xsr;
        private Map<Object, Location> locations;

        public LocationListener(XMLStreamReader xsr) {
            this.xsr = xsr;
            this.locations = new HashMap<Object, Location>();
        }

        public void beforeUnmarshal(Object target, Object parent) {
            this.locations.put(target, this.xsr.getLocation());
        }

        public Location getLocation(Object o) {
            return this.locations.get(o);
        }
    }

    public static enum STATUS {
        OK,
        NOK;

    }
}

