/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    protected String text;
    protected String html;
    protected List inlineImages = new ArrayList();
    public static final int CID_LENGTH = 10;

    public HtmlEmail setTextMsg(String aText) throws MessagingException {
        if (StringUtils.isEmpty((String)aText)) {
            throw new MessagingException("Invalid message supplied");
        }
        this.text = aText;
        return this;
    }

    public HtmlEmail setHtmlMsg(String aHtml) throws MessagingException {
        if (StringUtils.isEmpty((String)aHtml)) {
            throw new MessagingException("Invalid message supplied");
        }
        this.html = aHtml;
        return this;
    }

    public Email setMsg(String msg) throws MessagingException {
        if (StringUtils.isEmpty((String)msg)) {
            throw new MessagingException("Invalid message supplied");
        }
        this.setTextMsg(msg);
        this.setHtmlMsg(new StringBuffer().append("<html><body><pre>").append(msg).append("</pre></body></html>").toString());
        return this;
    }

    public String embed(URL url, String name) throws MessagingException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new MessagingException("Invalid URL");
        }
        URLDataSource ds = new URLDataSource(url);
        return this.embed((DataSource)ds, name);
    }

    public String embed(DataSource ds, String name) throws MessagingException {
        try {
            if (ds == null || ds.getInputStream() == null) {
                throw new MessagingException("Invalid Datasource");
            }
        }
        catch (IOException e) {
            throw new MessagingException("Invalid Datasource");
        }
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler(ds));
        mbp.setFileName(name);
        mbp.setDisposition("inline");
        String cid = RandomStringUtils.randomAlphabetic((int)10).toLowerCase();
        mbp.addHeader("Content-ID", "<" + cid + ">");
        this.inlineImages.add(mbp);
        return cid;
    }

    public void send() throws MessagingException {
        if (this.isBoolHasAttachments()) {
            this.buildAttachments();
        } else {
            this.buildNoAttachments();
        }
        super.send();
    }

    private void buildAttachments() throws MessagingException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainer = null;
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        MimeBodyPart msgHtml = null;
        MimeBodyPart msgText = null;
        container.setSubType("mixed");
        subContainer = new MimeMultipart("alternative");
        if (StringUtils.isNotEmpty((String)this.text)) {
            msgText = new MimeBodyPart();
            subContainer.addBodyPart((BodyPart)msgText);
            if (StringUtils.isNotEmpty((String)this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (StringUtils.isNotEmpty((String)this.html)) {
            if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart((BodyPart)msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                subContainer.addBodyPart((BodyPart)msgHtml);
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
        }
        this.addPart(subContainer);
        if (this.inlineImages.size() > 0) {
            this.addPart(subContainerHTML);
        }
    }

    private void buildNoAttachments() throws MessagingException {
        MimeMultipart container = this.getContainer();
        MimeMultipart subContainerHTML = new MimeMultipart("related");
        container.setSubType("alternative");
        MimeBodyPart msgText = null;
        MimeBodyPart msgHtml = null;
        if (StringUtils.isNotEmpty((String)this.text)) {
            msgText = this.getPrimaryBodyPart();
            if (StringUtils.isNotEmpty((String)this.charset)) {
                msgText.setContent((Object)this.text, "text/plain; charset=" + this.charset);
            } else {
                msgText.setContent((Object)this.text, "text/plain");
            }
        }
        if (StringUtils.isNotEmpty((String)this.html)) {
            if (msgText == null) {
                msgHtml = this.getPrimaryBodyPart();
            } else if (this.inlineImages.size() > 0) {
                msgHtml = new MimeBodyPart();
                subContainerHTML.addBodyPart((BodyPart)msgHtml);
            } else {
                msgHtml = new MimeBodyPart();
                container.addBodyPart((BodyPart)msgHtml);
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                msgHtml.setContent((Object)this.html, "text/html; charset=" + this.charset);
            } else {
                msgHtml.setContent((Object)this.html, "text/html");
            }
            Iterator iter = this.inlineImages.iterator();
            while (iter.hasNext()) {
                subContainerHTML.addBodyPart((BodyPart)iter.next());
            }
            if (this.inlineImages.size() > 0) {
                this.addPart(subContainerHTML);
            }
        }
    }
}

