/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;

public class MultiPartEmail
extends Email {
    private MimeMultipart container = null;
    private MimeBodyPart primaryBodyPart = null;
    private String subType = null;
    private boolean initialized = false;
    private boolean boolHasAttachments = false;

    public void setSubType(String aSubType) {
        this.subType = aSubType;
    }

    public String getSubType() {
        return this.subType;
    }

    public Email addPart(String content, String contentType) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)content, contentType);
        this.getContainer().addBodyPart((BodyPart)bodyPart);
        return this;
    }

    public Email addPart(MimeMultipart multipart) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Multipart)multipart);
        this.getContainer().addBodyPart((BodyPart)bodyPart);
        return this;
    }

    protected void init() throws MessagingException {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.container = new MimeMultipart();
        super.setContent(this.container);
        this.initialized = true;
    }

    public Email setMsg(String msg) throws MessagingException {
        if (StringUtils.isEmpty((String)msg)) {
            throw new MessagingException("Invalid message supplied");
        }
        if (StringUtils.isNotEmpty((String)this.charset)) {
            this.getPrimaryBodyPart().setText(msg, this.charset);
        } else {
            this.getPrimaryBodyPart().setText(msg);
        }
        return this;
    }

    public void send() throws MessagingException {
        if (this.primaryBodyPart != null) {
            MimeBodyPart body = this.getPrimaryBodyPart();
            Object content = null;
            try {
                content = body.getContent();
            }
            catch (IOException e) {
                Object var2_2 = null;
            }
        }
        if (this.subType != null) {
            this.getContainer().setSubType(this.subType);
        }
        super.send();
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws MessagingException {
        MultiPartEmail result = null;
        if (attachment == null) {
            throw new MessagingException("Invalid attachment supplied");
        }
        URL url = attachment.getURL();
        if (url == null) {
            String fileName = null;
            try {
                fileName = attachment.getPath();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException("\"" + fileName + "\" does not exist");
                }
                result = this.attach((DataSource)new FileDataSource(file), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
            catch (Exception e) {
                throw new MessagingException("Cannot attach file \"" + fileName + "\"", e);
            }
        } else {
            result = this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        return result;
    }

    public MultiPartEmail attach(URL url, String name, String description) throws MessagingException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws MessagingException {
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException e) {
            throw new MessagingException("Invalid URL set");
        }
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws MessagingException {
        try {
            if (ds == null || ds.getInputStream() == null) {
                throw new MessagingException("Invalid Datasource");
            }
        }
        catch (IOException e) {
            throw new MessagingException("Invalid Datasource");
        }
        return this.attach(ds, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, String disposition) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        this.getContainer().addBodyPart((BodyPart)mbp);
        mbp.setDisposition(disposition);
        if (StringUtils.isEmpty((String)name)) {
            name = ds.getName();
        }
        mbp.setFileName(name);
        mbp.setDescription(description);
        mbp.setDataHandler(new DataHandler(ds));
        this.boolHasAttachments = true;
        return this;
    }

    protected MimeBodyPart getPrimaryBodyPart() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        if (this.primaryBodyPart == null) {
            this.primaryBodyPart = new MimeBodyPart();
            this.getContainer().addBodyPart((BodyPart)this.primaryBodyPart);
        }
        return this.primaryBodyPart;
    }

    protected MimeMultipart getContainer() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        return this.container;
    }

    public boolean isBoolHasAttachments() {
        return this.boolHasAttachments;
    }

    public void setBoolHasAttachments(boolean b) {
        this.boolHasAttachments = b;
    }
}

