/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String SMTP = "smtp";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String ATTACHMENTS = "attachments";
    public static final String FILE_SERVER = "file.server";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String KOI8_R = "koi8-r";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String US_ASCII = "us-ascii";
    protected MimeMessage message;
    protected String charset;
    protected InternetAddress fromAddress;
    protected String subject;
    protected MimeMultipart emailBody;
    protected Object content;
    protected String contentType;
    protected boolean debug = false;
    protected Date sentDate;
    private Session session;
    protected Authenticator authenticator;
    protected String hostName;
    protected String smtpPort = "25";
    protected ArrayList toList = new ArrayList();
    protected ArrayList ccList = new ArrayList();
    protected ArrayList bccList = new ArrayList();
    protected ArrayList replyList = new ArrayList();
    protected String bounceAddress = null;
    protected Hashtable headers = new Hashtable();
    protected boolean popBeforeSmtp = false;
    protected String popHost = null;
    protected String popUsername = null;
    protected String popPassword = null;

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public void setAuthentication(String userName, String password) {
        this.authenticator = new DefaultAuthenticator(userName, password);
        this.setAuthenticator(this.authenticator);
    }

    public void setAuthenticator(Authenticator newAuthenticator) {
        this.authenticator = newAuthenticator;
    }

    public void setCharset(String newCharset) {
        this.charset = newCharset;
    }

    public void setContent(MimeMultipart aMimeMultipart) {
        this.emailBody = aMimeMultipart;
    }

    public void setContent(Object aObject, String aContentType) {
        this.content = aObject;
        if (!StringUtils.isNotEmpty((String)aContentType)) {
            this.contentType = null;
        } else {
            this.contentType = aContentType;
            String strMarker = "; charset=";
            int charsetPos = aContentType.toLowerCase().indexOf(strMarker);
            if (charsetPos != -1) {
                int intCharsetEnd = aContentType.toLowerCase().indexOf(" ", charsetPos += strMarker.length());
                this.charset = intCharsetEnd != -1 ? aContentType.substring(charsetPos, intCharsetEnd) : aContentType.substring(charsetPos);
            }
        }
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public void setSmtpPort(int aPortNumber) {
        if (aPortNumber < 1) {
            throw new IllegalArgumentException("Cannot connect to a port number that is less than 1 ( " + aPortNumber + " )");
        }
        this.smtpPort = Integer.toString(aPortNumber);
    }

    public void setMailSession(Session aSession) {
        this.session = aSession;
    }

    protected Session getMailSession() throws MessagingException {
        if (this.session == null) {
            Properties properties = new Properties(System.getProperties());
            properties.setProperty(MAIL_TRANSPORT_PROTOCOL, SMTP);
            if (!StringUtils.isNotEmpty((String)this.hostName)) {
                this.hostName = properties.getProperty(MAIL_HOST);
            }
            if (!StringUtils.isNotEmpty((String)this.hostName)) {
                throw new MessagingException("Cannot find valid hostname for mail session");
            }
            properties.setProperty(MAIL_PORT, this.smtpPort);
            properties.setProperty(MAIL_HOST, this.hostName);
            properties.setProperty(MAIL_DEBUG, String.valueOf(this.debug));
            if (this.authenticator != null) {
                properties.setProperty(MAIL_SMTP_AUTH, "true");
            }
            if (this.bounceAddress != null) {
                properties.setProperty(MAIL_SMTP_FROM, this.bounceAddress);
            }
            this.session = Session.getInstance((Properties)properties, (Authenticator)this.authenticator);
        }
        return this.session;
    }

    public Email setFrom(String email) throws MessagingException {
        return this.setFrom(email, null);
    }

    public Email setFrom(String email, String name) throws MessagingException {
        try {
            if (!StringUtils.isNotEmpty((String)name)) {
                name = email;
            }
            if (this.fromAddress == null) {
                this.fromAddress = StringUtils.isNotEmpty((String)this.charset) ? new InternetAddress(email, name, this.charset) : new InternetAddress(email, name);
            } else {
                this.fromAddress.setAddress(email);
                this.fromAddress.setPersonal(name);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("cannot set from", (Exception)e);
        }
        return this;
    }

    public Email addTo(String email) throws MessagingException {
        return this.addTo(email, null);
    }

    public Email addTo(String email, String name) throws MessagingException {
        try {
            InternetAddress ia = new InternetAddress(email);
            if (!StringUtils.isNotEmpty((String)name)) {
                name = email;
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                ia.setPersonal(name, this.charset);
                this.toList.add(ia);
            } else {
                ia.setPersonal(name);
                this.toList.add(ia);
            }
        }
        catch (AddressException ae) {
            throw new MessagingException("illegal to address", (Exception)((Object)ae));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("cannot add to", (Exception)e);
        }
        return this;
    }

    public Email setTo(Collection aCollection) throws MessagingException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new MessagingException("Address List provided was invalid");
        }
        this.toList = new ArrayList(aCollection);
        return this;
    }

    public Email addCc(String email) throws MessagingException {
        return this.addCc(email, null);
    }

    public Email addCc(String email, String name) throws MessagingException {
        try {
            InternetAddress ia = new InternetAddress(email);
            if (!StringUtils.isNotEmpty((String)name)) {
                name = email;
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                ia.setPersonal(name, this.charset);
                this.ccList.add(ia);
            } else {
                ia.setPersonal(name);
                this.ccList.add(ia);
            }
        }
        catch (AddressException ae) {
            throw new MessagingException("illegal cc address", (Exception)((Object)ae));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("cannot add cc", (Exception)e);
        }
        return this;
    }

    public Email setCc(Collection aCollection) throws MessagingException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new MessagingException("Address List provided was invalid");
        }
        this.ccList = new ArrayList(aCollection);
        return this;
    }

    public Email addBcc(String email) throws MessagingException {
        return this.addBcc(email, null);
    }

    public Email addBcc(String email, String name) throws MessagingException {
        try {
            InternetAddress ia = new InternetAddress(email);
            if (!StringUtils.isNotEmpty((String)name)) {
                name = email;
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                ia.setPersonal(name, this.charset);
                this.bccList.add(ia);
            } else {
                ia.setPersonal(name);
                this.bccList.add(ia);
            }
        }
        catch (AddressException ae) {
            throw new MessagingException("illegal bcc address", (Exception)((Object)ae));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("cannot add bcc", (Exception)e);
        }
        return this;
    }

    public Email setBcc(Collection aCollection) throws MessagingException {
        if (aCollection == null || aCollection.isEmpty()) {
            throw new MessagingException("Address List provided was invalid");
        }
        this.bccList = new ArrayList(aCollection);
        return this;
    }

    public Email addReplyTo(String email) throws MessagingException {
        return this.addReplyTo(email, null);
    }

    public Email addReplyTo(String email, String name) throws MessagingException {
        try {
            InternetAddress ia = new InternetAddress(email);
            if (!StringUtils.isNotEmpty((String)name)) {
                name = email;
            }
            if (StringUtils.isNotEmpty((String)this.charset)) {
                ia.setPersonal(name, this.charset);
                this.replyList.add(ia);
            } else {
                ia.setPersonal(name);
                this.replyList.add(ia);
            }
        }
        catch (AddressException ae) {
            throw new MessagingException("illegal replyTo address", (Exception)((Object)ae));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException("cannot add replyTo", (Exception)e);
        }
        return this;
    }

    public void setHeaders(Hashtable ht) {
        Enumeration enumKeyBad = ht.keys();
        while (enumKeyBad.hasMoreElements()) {
            String strName = (String)enumKeyBad.nextElement();
            String strValue = (String)ht.get(strName);
            if (!StringUtils.isNotEmpty((String)strName)) {
                throw new IllegalArgumentException("name can not be null");
            }
            if (StringUtils.isNotEmpty((String)strValue)) continue;
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers = ht;
    }

    public void addHeader(String name, String value) {
        if (!StringUtils.isNotEmpty((String)name)) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (!StringUtils.isNotEmpty((String)value)) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.headers.put(name, value);
    }

    public Email setSubject(String aSubject) {
        this.subject = aSubject;
        return this;
    }

    public Email setBounceAddress(String email) {
        this.bounceAddress = email;
        return this;
    }

    public abstract Email setMsg(String var1) throws MessagingException;

    public void send() throws MessagingException {
        this.getMailSession();
        this.message = new MimeMessage(this.session);
        if (StringUtils.isNotEmpty((String)this.subject)) {
            if (StringUtils.isNotEmpty((String)this.charset)) {
                this.message.setSubject(this.subject, this.charset);
            } else {
                this.message.setSubject(this.subject);
            }
        }
        if (this.content != null) {
            this.message.setContent(this.content, this.contentType);
        } else if (this.emailBody != null) {
            this.message.setContent((Multipart)this.emailBody);
        } else {
            this.message.setContent((Object)"", TEXT_PLAIN);
        }
        if (this.fromAddress == null) {
            throw new MessagingException("Sender address required");
        }
        this.message.setFrom((Address)this.fromAddress);
        if (this.toList.size() + this.ccList.size() + this.bccList.size() == 0) {
            throw new MessagingException("At least one receiver address required");
        }
        if (this.toList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
        }
        if (this.ccList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
        }
        if (this.bccList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
        }
        if (this.replyList.size() > 0) {
            this.message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
        }
        if (this.headers.size() > 0) {
            Enumeration henum = this.headers.keys();
            while (henum.hasMoreElements()) {
                String name = (String)henum.nextElement();
                String value = (String)this.headers.get(name);
                this.message.addHeader(name, value);
            }
        }
        if (this.message.getSentDate() == null) {
            this.message.setSentDate(this.getSentDate());
        }
        if (this.popBeforeSmtp) {
            Store store = this.session.getStore("pop3");
            store.connect(this.popHost, this.popUsername, this.popPassword);
        }
        Transport.send((Message)this.message);
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            return new Date();
        }
        return this.sentDate;
    }

    protected InternetAddress[] toInternetAddressArray(ArrayList aList) {
        InternetAddress[] ia = aList.toArray(new InternetAddress[0]);
        return ia;
    }

    public void setPopBeforeSmtp(boolean newPopBeforeSmtp, String newPopHost, String newPopUsername, String newPopPassword) {
        this.popBeforeSmtp = newPopBeforeSmtp;
        this.popHost = newPopHost;
        this.popUsername = newPopUsername;
        this.popPassword = newPopPassword;
    }
}

