/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import net.sf.json.JSONObject;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.gui.stripes.ActionsAction;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.gui.stripes.FileAction;
import nl.b3p.datastorelinker.gui.stripes.InputAction;
import nl.b3p.datastorelinker.json.JSONErrorResolution;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.util.DefaultErrorResolution;
import nl.b3p.datastorelinker.util.NameableComparer;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.util.DataStoreUtil;
import nl.b3p.geotools.data.linker.util.DataTypeList;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.hibernate.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@Transactional
public class InputAction
extends DefaultAction {
    private static final Log log = Log.getInstance(InputAction.class);
    private static final String LIST_JSP = "/WEB-INF/jsp/main/input/database/list.jsp";
    private static final String TABLE_LIST_JSP = "/WEB-INF/jsp/main/input/table/list.jsp";
    private static final String CREATE_DATABASE_JSP = "/WEB-INF/jsp/main/input/database/create.jsp";
    private static final String CREATE_FILE_JSP = "/WEB-INF/jsp/main/input/file/create.jsp";
    private static final String EXAMPLE_RECORD_JSP = "/WEB-INF/jsp/main/actions/exampleRecord.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/management/inputAdmin.jsp";
    private List<Inout> inputs;
    private Long selectedInputId;
    private List<Database> databases;
    private Long selectedDatabaseId;
    private String selectedFilePath;
    private List<String> tables;
    private List<String> failedTables;
    private String selectedTable;
    private List<String> columnNames;
    private List<Object> recordValues;

    @DefaultHandler
    public Resolution admin() {
        this.list();
        return new ForwardResolution(ADMIN_JSP);
    }

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.inputs = this.isUserAdmin() ? session.createQuery("from Inout where input_output_type = :type and input_output_datatype = :datatype").setParameter("type", (Object)Inout.TYPE_INPUT).setParameter("datatype", (Object)Inout.TYPE_DATABASE).list() : session.createQuery("from Inout where input_output_type = :type and input_output_datatype = :datatype and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_INPUT).setParameter("datatype", (Object)Inout.TYPE_DATABASE).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.inputs, new NameableComparer());
        return new ForwardResolution(LIST_JSP);
    }

    public Resolution delete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        if (this.selectedInputId != null && this.selectedInputId > 0L) {
            session.delete(session.get(Inout.class, (Serializable)this.selectedInputId));
        }
        return this.list();
    }

    public Resolution update() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout input = (Inout)session.get(Inout.class, (Serializable)this.selectedInputId);
        this.selectedTable = input.getTableName();
        switch (2.$SwitchMap$nl$b3p$datastorelinker$entity$Inout$Datatype[input.getDatatype().ordinal()]) {
            case 1: {
                this.selectedDatabaseId = input.getDatabase().getId();
                return this.createDatabaseInput();
            }
        }
        log.error(new Object[]{"Unknown input type."});
        return null;
    }

    public Resolution createDatabaseInput() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.databases = this.isUserAdmin() ? session.createQuery("from Database where inout_type = :type").setParameter("type", (Object)Inout.TYPE_INPUT).list() : session.createQuery("from Database where inout_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_INPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.databases, new NameableComparer());
        return new ForwardResolution(CREATE_DATABASE_JSP);
    }

    public Resolution createFileInput() {
        return new ForwardResolution(CREATE_FILE_JSP);
    }

    public Resolution createDatabaseInputComplete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Database selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        Inout dbInput = null;
        dbInput = this.selectedInputId == null ? new Inout() : (Inout)session.get(Inout.class, (Serializable)this.selectedInputId);
        dbInput.setType(Inout.Type.INPUT);
        dbInput.setDatatype(Inout.Datatype.DATABASE);
        dbInput.setDatabase(selectedDatabase);
        dbInput.setTableName(this.selectedTable);
        if (dbInput.getUserId() == null && dbInput.getOrganizationId() == null) {
            dbInput.setOrganizationId(this.getUserOrganiztionId());
            dbInput.setUserId(this.getUserId());
        }
        if (this.selectedInputId == null) {
            this.selectedInputId = (Long)session.save((Object)dbInput);
        }
        return this.list();
    }

    public Resolution createTablesList() {
        Inout input;
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        if (this.selectedInputId != null && this.selectedDatabaseId.equals((input = (Inout)session.get(Inout.class, (Serializable)this.selectedInputId)).getDatabase().getId())) {
            this.selectedTable = input.getTableName();
        }
        Database selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        try {
            DataTypeList dataTypeList = DataStoreUtil.getDataTypeList((Map)selectedDatabase.toGeotoolsDataStoreParametersMap());
            if (dataTypeList != null) {
                this.tables = dataTypeList.getGood();
                this.failedTables = dataTypeList.getBad();
                return new ForwardResolution(TABLE_LIST_JSP);
            }
            throw new Exception("Error getting datatypes from DataStore.");
        }
        catch (Exception e) {
            String tablesError = "Fout bij ophalen tabellen. ";
            log.error(new Object[]{tablesError + e.getMessage()});
            return new DefaultErrorResolution(tablesError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getTypeNames() {
        log.debug(new Object[]{"getTypeNames"});
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        DataStore ds = null;
        try {
            Inout input = null;
            if (this.selectedFilePath == null) {
                input = (Inout)session.get(Inout.class, (Serializable)this.selectedInputId);
            } else {
                String fullPath = FileAction.getFileNameFromPPFileName((String)this.selectedFilePath, (ActionBeanContext)this.getContext());
                input = new Inout();
                input.setFile(fullPath);
                ActionsAction.setExternalFileName((String)fullPath);
            }
            String tableName = null;
            if (input.getDatabase() != null) {
                ds = DataStoreLinker.openDataStore((Database)input.getDatabase());
                tableName = input.getTableName();
            } else if (input.getFile() != null) {
                ds = DataStoreLinker.openDataStore((String)input.getFile());
            } else {
                throw new Exception("unsupported input type.");
            }
            SimpleFeature feature = null;
            try {
                feature = this.getExampleFeature(ds, tableName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List srcAttrDesc = new ArrayList();
            srcAttrDesc = feature != null ? feature.getFeatureType().getAttributeDescriptors() : ((SimpleFeatureType)ds.getFeatureSource(tableName).getSchema()).getAttributeDescriptors();
            ArrayList<AttributeDescriptor> attrDescs = new ArrayList<AttributeDescriptor>(srcAttrDesc.size());
            for (AttributeDescriptor ad : srcAttrDesc) {
                attrDescs.add(ad);
            }
            Collections.sort(attrDescs, new /* Unavailable Anonymous Inner Class!! */);
            String[] inputColumns = null;
            int i = 0;
            if (attrDescs != null && attrDescs.size() > 0) {
                inputColumns = new String[attrDescs.size()];
            }
            JSONObject colNames = new JSONObject();
            for (AttributeDescriptor desc : attrDescs) {
                String col = desc.getLocalName();
                String type = desc.getType().getBinding().getSimpleName();
                colNames.put((Object)col, (Object)type);
                inputColumns[i] = "inputmapping." + col;
                ++i;
            }
            if (inputColumns != null) {
                ActionsAction.setInputColumns((String[])inputColumns);
            }
            JSONResolution jSONResolution = new JSONResolution((Object)colNames);
            return jSONResolution;
        }
        catch (Exception e) {
            log.error((Throwable)e, new Object[0]);
            String message = e.getMessage() + "<p>" + new LocalizableMessage("attributeReadErrorAdvice", new Object[0]).getMessage(this.getContext().getLocale()) + "</p>";
            JSONErrorResolution jSONErrorResolution = new JSONErrorResolution(message, new LocalizableMessage("attributeReadError", new Object[0]), this.getContext());
            return jSONErrorResolution;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getExampleRecord() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout input = (Inout)session.get(Inout.class, (Serializable)this.selectedInputId);
        DataStore ds = null;
        try {
            String tableName = null;
            if (input.getDatabase() != null) {
                ds = DataStoreLinker.openDataStore((Database)input.getDatabase());
                tableName = input.getTableName();
            } else if (input.getFile() != null) {
                ds = DataStoreLinker.openDataStore((String)input.getFile());
            } else {
                throw new Exception("unsupported input type.");
            }
            SimpleFeature feature = this.getExampleFeature(ds, tableName);
            this.columnNames = new ArrayList();
            for (AttributeDescriptor desc : feature.getFeatureType().getAttributeDescriptors()) {
                String col = desc.getLocalName();
                String type = desc.getType().getBinding().getSimpleName();
                this.columnNames.add(col + "(" + type + ")");
            }
            this.recordValues = feature.getAttributes();
        }
        catch (Exception e) {
            log.error((Throwable)e, new Object[0]);
            DefaultErrorResolution defaultErrorResolution = new DefaultErrorResolution(e.getMessage());
            return defaultErrorResolution;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return new ForwardResolution(EXAMPLE_RECORD_JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeature getExampleFeature(DataStore ds, String tableName) throws Exception {
        if (tableName == null) {
            if (ds.getTypeNames().length == 0) {
                throw new IllegalArgumentException("no typeNames");
            }
            tableName = ds.getTypeNames()[0];
        }
        Query q = new Query();
        q.setMaxFeatures(1);
        SimpleFeatureCollection fc = ds.getFeatureSource(tableName).getFeatures(q);
        FeatureIterator iterator = fc.features();
        if (iterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
            return simpleFeature;
        }
        throw new Exception("Geen features gevonden.");
    }

    public List<Inout> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<Inout> inputs) {
        this.inputs = inputs;
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<Database> databases) {
        this.databases = databases;
    }

    public Long getSelectedDatabaseId() {
        return this.selectedDatabaseId;
    }

    public void setSelectedDatabaseId(Long selectedDatabaseId) {
        this.selectedDatabaseId = selectedDatabaseId;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public Long getSelectedInputId() {
        return this.selectedInputId;
    }

    public void setSelectedInputId(Long selectedInputId) {
        this.selectedInputId = selectedInputId;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public String getSelectedTable() {
        return this.selectedTable;
    }

    public void setSelectedTable(String selectedTable) {
        this.selectedTable = selectedTable;
    }

    public List<String> getFailedTables() {
        return this.failedTables;
    }

    public void setFailedTables(List<String> failedTables) {
        this.failedTables = failedTables;
    }

    public String getUploadDirectory() {
        return this.getContext().getServletContext().getInitParameter("uploadDirectory");
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public List<Object> getRecordValues() {
        return this.recordValues;
    }

    public void setRecordValues(List<Object> recordValues) {
        this.recordValues = recordValues;
    }
}

