/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.entity.Organization;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.json.JSONResolution;
import org.hibernate.Session;

@Transactional
public class OutputRightsAction
extends DefaultAction {
    private static final Log log = Log.getInstance(OutputRightsAction.class);
    private static final String ADMIN_RIGHTS_JSP = "/WEB-INF/jsp/management/outputRightsAdmin.jsp";
    private static final String LIST_OUTPUTS_JSP = "/WEB-INF/jsp/main/output_rights/list.jsp";
    private static final String CREATE_RIGHTS_JSP = "/WEB-INF/jsp/main/output_rights/create.jsp";
    private List<Inout> outputs;
    private List<Organization> orgs;
    private Integer selectedOutputId;
    private Inout selectedOutput;
    @Validate(required=false, on={"createOutputRightsComplete"})
    private String organizationIds;
    private List<Organization> selectedOrgIds;

    @DefaultHandler
    public Resolution admin() {
        this.list();
        return new ForwardResolution(ADMIN_RIGHTS_JSP);
    }

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        this.outputs = sess.createQuery("from Inout where input_output_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list();
        return new ForwardResolution(LIST_OUTPUTS_JSP);
    }

    public Resolution updateOutputRights() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedOutputId != null) {
            this.selectedOutput = (Inout)sess.get(Inout.class, (Serializable)new Long(this.selectedOutputId.intValue()));
            this.selectedOrgIds = this.selectedOutput.getOrganizations();
        }
        this.orgs = sess.createQuery("from Organization order by name").list();
        return new ForwardResolution(CREATE_RIGHTS_JSP);
    }

    public Resolution fillSelectedOrganizationIds() {
        JSONArray jsonArray = null;
        if (this.selectedOutputId != null) {
            jsonArray = new JSONArray();
            EntityManager em = JpaUtilServlet.getThreadEntityManager();
            Session session = (Session)em.getDelegate();
            Inout output = (Inout)session.get(Inout.class, (Serializable)new Long(this.selectedOutputId.intValue()));
            if (output != null) {
                List lijst = output.getOrganizations();
                for (Organization org : lijst) {
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"id", (Object)org.getId());
                    jsonArray.add((Object)obj);
                }
            }
        }
        return new JSONResolution((Object)jsonArray);
    }

    public Resolution createOutputRights() {
        return new ForwardResolution(CREATE_RIGHTS_JSP);
    }

    public Resolution createOutputRightsComplete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedOutputId != null) {
            this.selectedOutput = (Inout)sess.get(Inout.class, (Serializable)new Long(this.selectedOutputId.intValue()));
        }
        ArrayList<Organization> list = new ArrayList<Organization>();
        if (this.organizationIds != null && !this.organizationIds.equals("") && this.selectedOutput != null) {
            String[] ids;
            for (String id : ids = this.organizationIds.trim().split(",")) {
                if (id == null || id.equals("")) continue;
                Organization org = (Organization)sess.get(Organization.class, (Serializable)new Integer(id));
                list.add(org);
            }
            this.selectedOutput.setOrganizations(list);
            sess.save((Object)this.selectedOutput);
        } else {
            this.selectedOutput.setOrganizations(null);
            sess.save((Object)this.selectedOutput);
        }
        return this.list();
    }

    public List<Inout> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<Inout> outputs) {
        this.outputs = outputs;
    }

    public Inout getSelectedOutput() {
        return this.selectedOutput;
    }

    public void setSelectedOutput(Inout selectedOutput) {
        this.selectedOutput = selectedOutput;
    }

    public Integer getSelectedOutputId() {
        return this.selectedOutputId;
    }

    public void setSelectedOutputId(Integer selectedOutputId) {
        this.selectedOutputId = selectedOutputId;
    }

    public List<Organization> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<Organization> orgs) {
        this.orgs = orgs;
    }

    public String getOrganizationIds() {
        return this.organizationIds;
    }

    public void setOrganizationIds(String organizationIds) {
        this.organizationIds = organizationIds;
    }

    public List<Organization> getSelectedOrgIds() {
        return this.selectedOrgIds;
    }

    public void setSelectedOrgIds(List<Organization> selectedOrgIds) {
        this.selectedOrgIds = selectedOrgIds;
    }
}

