/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidationError;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.publish.GeoserverPublisher;
import nl.b3p.datastorelinker.publish.MapserverPublisher;
import nl.b3p.datastorelinker.util.NameableComparer;
import nl.b3p.geotools.data.linker.util.DataStoreUtil;
import nl.b3p.geotools.data.linker.util.DataTypeList;
import org.hibernate.Session;

@Transactional
public class OutputServicesAction
extends DefaultAction {
    private static final Log log = Log.getInstance(OutputServicesAction.class);
    private static final String MAIN_JSP = "/WEB-INF/jsp/management/outputServicesAdmin.jsp";
    private static final String PUBLISH_JSP = "/WEB-INF/jsp/main/output_services/publish.jsp";
    private static final String LIST_JSP = "/WEB-INF/jsp/main/output_services/list.jsp";
    private List<Database> databases;
    private List<String> tables;
    private String selectedTables;
    private Long selectedDatabaseId;
    @Validate
    private String publisherType;
    private String namePublisher;

    @DefaultHandler
    public Resolution view() {
        this.list();
        return new ForwardResolution(MAIN_JSP);
    }

    public Resolution publish() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Database selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        try {
            DataTypeList dataTypeList = DataStoreUtil.getDataTypeList((Map)selectedDatabase.toGeotoolsDataStoreParametersMap());
            if (dataTypeList == null) {
                throw new Exception("Error getting datatypes from DataStore.");
            }
            this.tables = dataTypeList.getGood();
        }
        catch (Exception e) {
            String tablesError = "Fout bij ophalen tabellen. ";
            log.error(new Object[]{tablesError + e.getMessage()});
        }
        return new ForwardResolution(PUBLISH_JSP);
    }

    public Resolution createComplete() {
        GeoserverPublisher publisher = null;
        if (this.publisherType.equals("GEOSERVER")) {
            publisher = new GeoserverPublisher();
        } else if (this.publisherType.equals("MAPSERVER")) {
            publisher = new MapserverPublisher();
        } else {
            throw new IllegalArgumentException("Publisher type not yet implemented");
        }
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Database database = (Database)em.find(Database.class, (Object)this.selectedDatabaseId);
        if (database.getType() == Database.Type.POSTGIS || database.getType() == Database.Type.ORACLE) {
            ServletContext c = this.getContext().getServletContext();
            if (this.selectedTables != null) {
                String[] tablesToPublish = this.selectedTables.split(",");
                boolean published = false;
                if (this.publisherType.equals("GEOSERVER")) {
                    published = publisher.publishDB(c.getInitParameter("geoserverUrl"), c.getInitParameter("geoserverUser"), c.getInitParameter("geoserverPassword"), database.getType(), database.getHost(), database.getPort().intValue(), database.getUsername(), database.getPassword(), database.getSchema(), database.getDatabaseName(), tablesToPublish, c.getInitParameter("geoserverWorkspace"), "polygon", c);
                }
                if (this.publisherType.equals("MAPSERVER")) {
                    MapserverPublisher pub = (MapserverPublisher)publisher;
                    pub.setServiceName(this.namePublisher);
                    published = pub.publishDB(null, null, null, database.getType(), database.getHost(), database.getPort().intValue(), database.getUsername(), database.getPassword(), database.getSchema(), database.getDatabaseName(), tablesToPublish, null, null, c);
                }
                if (!published) {
                    this.getContext().getValidationErrors().add("Fout", (ValidationError)new SimpleError("Service is niet gepubliceerd.", new Object[0]));
                }
            }
            this.getContext().getMessages().add(new SimpleMessage("Gelukt", new Object[0]));
        } else if (database.getType() == Database.Type.ORACLE) {
            this.getContext().getValidationErrors().add("Databasetype", (ValidationError)new SimpleError("Database mag alleen van type postgis of oracle zijn.", new Object[0]));
        }
        this.list();
        return new ForwardResolution(LIST_JSP);
    }

    public void list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.databases = this.isUserAdmin() ? session.createQuery("from Database where inout_type = :inouttype").setParameter("inouttype", (Object)Inout.TYPE_OUTPUT).list() : session.createQuery("from Database where inout_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_OUTPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.databases, new NameableComparer());
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<Database> databases) {
        this.databases = databases;
    }

    public Long getSelectedDatabaseId() {
        return this.selectedDatabaseId;
    }

    public void setSelectedDatabaseId(Long selectedDatabaseId) {
        this.selectedDatabaseId = selectedDatabaseId;
    }

    public String getPublisherType() {
        return this.publisherType;
    }

    public void setPublisherType(String publisherType) {
        this.publisherType = publisherType;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public String getSelectedTables() {
        return this.selectedTables;
    }

    public void setSelectedTables(String selectedTables) {
        this.selectedTables = selectedTables;
    }

    public String getNamePublisher() {
        return this.namePublisher;
    }

    public void setNamePublisher(String namePublisher) {
        this.namePublisher = namePublisher;
    }
}

