/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * Exception performing whole class analysis ignored.
 */
public class AddressToPoint {
    private static String googleBaseUrl = "http://maps.google.nl/maps/geo?q=";

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJsonFromUrl(String url) throws IOException, JSONException {
        InputStream is = new URL(url).openStream();
        try {
            JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = AddressToPoint.readAll((Reader)rd);
            JSONObject jSONObject = json = new JSONObject(jsonText);
            return jSONObject;
        }
        finally {
            is.close();
        }
    }

    private static Point convertWktToRdsPoint(String wkt) {
        Point p = null;
        try {
            Geometry targetGeometry;
            CoordinateReferenceSystem targetCRS;
            CoordinateReferenceSystem sourceCRS;
            MathTransform transform;
            Geometry sourceGeometry = AddressToPoint.createGeomFromWKTString((String)wkt);
            if (sourceGeometry != null && (transform = CRS.findMathTransform((CoordinateReferenceSystem)(sourceCRS = CRS.decode((String)"EPSG:4326")), (CoordinateReferenceSystem)(targetCRS = CRS.decode((String)"EPSG:28992")), (boolean)true)) != null && (targetGeometry = JTS.transform((Geometry)sourceGeometry, (MathTransform)transform)) != null) {
                targetGeometry.setSRID(4326);
                p = targetGeometry.getCentroid();
            }
        }
        catch (Exception ex) {
            System.out.println("Fout tijdens conversie wkt naar latlon: " + ex);
        }
        return p;
    }

    public static Geometry createGeomFromWKTString(String wktstring) throws Exception {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        try {
            return wktreader.read(wktstring);
        }
        catch (ParseException ex) {
            throw new Exception(ex);
        }
    }
}

