/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.entity.Mail;
import nl.b3p.datastorelinker.entity.Organization;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.entity.ProcessStatus;
import nl.b3p.datastorelinker.entity.Users;
import nl.b3p.datastorelinker.gui.stripes.ActionsAction;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.gui.stripes.FileAction;
import nl.b3p.datastorelinker.gui.stripes.PeriodicalProcessAction;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.json.ProgressMessage;
import nl.b3p.datastorelinker.json.SuccessMessage;
import nl.b3p.datastorelinker.util.DataStoreLinkJob;
import nl.b3p.datastorelinker.util.DefaultErrorResolution;
import nl.b3p.datastorelinker.util.MarshalUtils;
import nl.b3p.datastorelinker.util.NameableComparer;
import nl.b3p.datastorelinker.util.SchedulerUtils;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.Status;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

@Transactional
public class ProcessAction
extends DefaultAction {
    private static final Log log = Log.getInstance(ProcessAction.class);
    private static final String JSP = "/WEB-INF/jsp/main/process/overview.jsp";
    private static final String LIST_JSP = "/WEB-INF/jsp/main/process/list.jsp";
    private static final String CREATE_JSP = "/WEB-INF/jsp/main/process/create.jsp";
    private static final String EXECUTE_JSP = "/WEB-INF/jsp/main/process/execute.jsp";
    private static final String PROCESS_DIAGRAM_JSP = "/WEB-INF/jsp/main/process/diagram.jsp";
    private List<Process> processes;
    private Long selectedProcessId;
    private List<Inout> inputs;
    private Long selectedInputId;
    private List<Inout> inputsFile;
    private List<Inout> inputsDB;
    private List<Inout> outputs;
    private Long selectedOutputId;
    private boolean drop;
    private boolean append;
    private String actionsList;
    private String jobUUID;
    private String emailAddress;
    private String subject;
    private String processName;
    private String processRemark;
    private String selectedFilePath;
    private Long linkedProcess;
    private JSONArray jsonProcesses;
    private Boolean admin;

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.processes = this.isUserAdmin() ? session.createQuery("from Process order by name").list() : session.createQuery("from Process where organization_id = :org_id order by name").setParameter("org_id", (Object)this.getUserOrganiztionId()).list();
        for (Process process : this.processes) {
            Users user = (Users)session.createQuery("from Users where id = :userid").setParameter("userid", (Object)process.getUserId()).uniqueResult();
            if (process.getLinkedProcess() != null) {
                Hibernate.initialize((Object)process.getLinkedProcess());
            }
            if (user == null) continue;
            process.setUserName(user.getName());
        }
        Collections.sort(this.processes, new NameableComparer());
        return new ForwardResolution(LIST_JSP);
    }

    @DefaultHandler
    public Resolution overview() {
        this.list();
        return new ForwardResolution(JSP);
    }

    public Resolution create() {
        this.inputs = this.findInputs();
        this.outputs = this.findOutputs();
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        if (this.selectedProcessId == null) {
            this.selectedProcessId = -1L;
        }
        this.processes = this.isUserAdmin() ? session.createQuery("from Process where id <> :id order by name").setParameter("id", (Object)this.selectedProcessId).list() : session.createQuery("from Process where organization_id = :org_id and id <> :id order by name").setParameter("org_id", (Object)this.getUserOrganiztionId()).setParameter("id", (Object)this.selectedProcessId).list();
        this.processes = this.filterPossibleCyclicDependencies(this.processes, this.selectedProcessId);
        if (this.actionsList == null) {
            this.actionsList = new JSONArray().toString();
        }
        if (this.emailAddress == null) {
            this.emailAddress = this.getContext().getServletContext().getInitParameter("defaultToEmailAddress");
        }
        if (this.subject == null) {
            this.subject = this.getContext().getServletContext().getInitParameter("defaultSubject");
        }
        return new ForwardResolution(CREATE_JSP);
    }

    private List<Process> filterPossibleCyclicDependencies(List<Process> processes, Long selected) {
        ArrayList<Process> filteredList = new ArrayList<Process>();
        for (Process process : processes) {
            boolean backward = this.traverseBackward(process, selected);
            boolean forward = this.traverseForward(process, selected);
            if (backward || forward) continue;
            filteredList.add(process);
        }
        return filteredList;
    }

    private boolean traverseForward(Process current, Long selected) {
        List found = this.getLinkedProcesses(current);
        boolean isLinked = false;
        for (Process process : found) {
            if (!process.getId().equals(selected) || process.getLinkedProcess().getId().equals(this.linkedProcess)) continue;
            isLinked = true;
            break;
        }
        return isLinked;
    }

    private boolean traverseBackward(Process current, Long selected) {
        boolean isFound = false;
        do {
            if (current.getLinkedProcess() == null) continue;
            if (current.getLinkedProcess().getId().equals(selected) && !current.getLinkedProcess().getId().equals(this.linkedProcess)) {
                isFound = true;
                break;
            }
            current = current.getLinkedProcess();
        } while (current.getLinkedProcess() != null);
        return isFound;
    }

    private List<Process> getLinkedProcesses(Process linked) {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        List found = this.isUserAdmin() ? session.createQuery("from Process where linked_process = :linked order by name").setParameter("linked", (Object)linked).list() : session.createQuery("from Process where organization_id = :org_id and linked_process = :linked order by name").setParameter("org_id", (Object)this.getUserOrganiztionId()).setParameter("linked", (Object)linked).list();
        return found;
    }

    public Resolution createDefaultActionBlocks() {
        JSONArray obj = null;
        if (this.actionsList == null) {
            obj = ActionsAction.createDefaultActionList((ActionBeanContext)this.getContext());
        }
        return new JSONResolution((Object)obj);
    }

    public Resolution processDiagram() {
        this.list();
        this.jsonProcesses = new JSONArray();
        for (Process process : this.processes) {
            JSONObject obj = process.toJSONObject();
            this.jsonProcesses.add((Object)obj);
        }
        return new ForwardResolution(PROCESS_DIAGRAM_JSP);
    }

    public Resolution createComplete() {
        Process process;
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout input = null;
        if (this.selectedFilePath == null) {
            input = (Inout)session.get(Inout.class, (Serializable)this.selectedInputId);
        } else {
            String fullPath = FileAction.getFileNameFromPPFileName((String)this.selectedFilePath, (ActionBeanContext)this.getContext());
            input = (Inout)session.createQuery("from Inout where file = :file").setParameter("file", (Object)fullPath).uniqueResult();
            if (input == null) {
                input = new Inout();
                input.setType(Inout.Type.INPUT);
                input.setDatatype(Inout.Datatype.FILE);
                input.setFile(fullPath);
                input.setName(this.selectedFilePath);
                input.setOrganizationId(this.getUserOrganiztionId());
                input.setUserId(this.getUserId());
                session.save((Object)input);
            }
        }
        Inout output = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        if (this.selectedProcessId == null) {
            process = new Process();
        } else {
            process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
            Inout oldInput = process.getInput();
            if (oldInput.getDatatype() == Inout.Datatype.FILE && !oldInput.getFile().equals(input.getFile()) && oldInput.getInputProcessList().size() == 1) {
                log.debug(new Object[]{"delete file input that is no longer used. (file itself is not deleted)"});
                process.getInput().getInputProcessList().clear();
                process.getInput().getOutputProcessList().clear();
                session.delete((Object)process.getInput());
            }
        }
        if (process.getUserId() == null && process.getOrganizationId() == null) {
            process.setOrganizationId(this.getUserOrganiztionId());
            process.setUserId(this.getUserId());
        }
        output.setOrganizationId(this.getUserOrganiztionId());
        output.setUserId(this.getUserId());
        process.setInput(input);
        process.setOutput(output);
        process.setActionsString(this.getActionsListJsonToXmlString());
        process.setDrop(Boolean.valueOf(this.drop));
        process.setAppend(Boolean.valueOf(this.append));
        Mail mail = null;
        mail = process.getMail() == null ? new Mail() : process.getMail();
        mail.setToEmailAddress(this.emailAddress);
        mail.setSubject(this.subject);
        if (process.getMail() == null) {
            session.save((Object)mail);
            process.setMail(mail);
        }
        if (process.getProcessStatus() == null) {
            ProcessStatus processStatus = ProcessStatus.getDefault();
            session.save((Object)processStatus);
            process.setProcessStatus(processStatus);
        }
        process.setName(this.processName);
        process.setRemarks(this.processRemark);
        if (this.linkedProcess != null && this.linkedProcess != -1L) {
            Process link = (Process)em.find(Process.class, (Object)this.linkedProcess);
            process.setLinkedProcess(link);
        } else {
            process.setLinkedProcess(null);
        }
        if (this.selectedProcessId == null) {
            this.selectedProcessId = (Long)session.save((Object)process);
        }
        return this.list();
    }

    private String getActionsListJsonToXmlString() {
        if (this.actionsList == null || this.actionsList.trim().equals("")) {
            this.actionsList = new JSONArray().toString();
        }
        JSONArray actionsListJSONArray = JSONArray.fromObject((Object)this.actionsList);
        ActionsAction.removeViewData((JSONArray)actionsListJSONArray);
        ActionsAction.addExpandableProperty((JSONArray)actionsListJSONArray);
        JSON actionsListJSON = JSONSerializer.toJSON((Object)actionsListJSONArray);
        XMLSerializer xmlSerializer = new XMLSerializer();
        xmlSerializer.setArrayName("actions");
        xmlSerializer.setElementName("action");
        xmlSerializer.setExpandableProperties(new String[]{"parameter"});
        xmlSerializer.setTypeHintsEnabled(false);
        String actionsListXml = xmlSerializer.write(actionsListJSON);
        return actionsListXml;
    }

    public Resolution update() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        this.selectedInputId = process.getInput().getId();
        if (process.getInput().getFile() != null && process.getInput().getFile().trim().length() > 0) {
            this.selectedFilePath = FileAction.getFileNameRelativeToUploadDirPP((String)process.getInput().getFile(), (ActionBeanContext)this.getContext());
        }
        this.selectedOutputId = process.getOutput().getId();
        this.actionsList = this.getActionsListXmlToJsonString(process);
        this.drop = process.getDrop();
        this.append = process.getAppend();
        this.emailAddress = process.getMail().getToEmailAddress();
        this.subject = process.getMail().getSubject();
        this.processName = process.getName();
        this.processRemark = process.getRemarks();
        if (process.getLinkedProcess() != null) {
            this.linkedProcess = process.getLinkedProcess().getId();
        }
        return this.create();
    }

    private String getActionsListXmlToJsonString(Process process) {
        XMLSerializer xmlSerializer = new XMLSerializer();
        String xmlActions = process.getActionsString();
        JSON jsonActions = xmlSerializer.read(xmlActions);
        JSONArray jsonArrayActions = JSONArray.fromObject((Object)jsonActions);
        if (jsonArrayActions.size() == 1) {
            if (jsonArrayActions.get(0).toString().equals("null")) {
                jsonArrayActions.clear();
            } else {
                JSONObject singleActionJSON = jsonArrayActions.getJSONObject(0);
                jsonArrayActions.clear();
                jsonArrayActions.add(singleActionJSON.get("action"));
            }
        }
        log.debug(new Object[]{"beforeInsert: " + jsonArrayActions});
        ActionsAction.addViewData((JSONArray)jsonArrayActions, (ActionBeanContext)this.getContext());
        log.debug(new Object[]{"afterInsert: " + jsonArrayActions});
        return jsonArrayActions.toString();
    }

    public Resolution delete() {
        PeriodicalProcessAction ppaction = new PeriodicalProcessAction();
        ppaction.cancelExecutePeriodicallyImpl(this.selectedProcessId, this.getContext().getServletContext());
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        log.debug(new Object[]{"delete process"});
        Inout input = process.getInput();
        if (input.getFile() != null && !input.getFile().trim().equals("")) {
            input.getInputProcessList().remove(process);
        }
        List linkedProcesses = em.createQuery("FROM Process WHERE linked_process = :id").setParameter("id", (Object)process).getResultList();
        for (Process linked : linkedProcesses) {
            linked.setLinkedProcess(null);
        }
        log.debug(new Object[]{"delete process simple"});
        session.delete((Object)process);
        return this.list();
    }

    public Resolution execute() {
        log.debug(new Object[]{"Executing process with id: " + this.selectedProcessId});
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        try {
            String generatedJobUUID = "job" + UUID.randomUUID().toString();
            JobDetail jobDetail = new JobDetail(generatedJobUUID, DataStoreLinkJob.class);
            jobDetail.getJobDataMap().put((Object)"processId", (Object)process.getId());
            jobDetail.getJobDataMap().put((Object)"locale", (Object)this.getContext().getLocale());
            jobDetail.getJobDataMap().put("defaultSmtpHost", this.getContext().getServletContext().getInitParameter("defaultSmtpHost"));
            jobDetail.getJobDataMap().put("defaultFromEmailAddress", this.getContext().getServletContext().getInitParameter("defaultFromEmailAddress"));
            Trigger trigger = TriggerUtils.makeImmediateTrigger((String)generatedJobUUID, (int)0, (long)0L);
            Scheduler scheduler = SchedulerUtils.getScheduler((ServletContext)this.getContext().getServletContext());
            process.getProcessStatus().setProcessStatusType(ProcessStatus.Type.RUNNING);
            process.getProcessStatus().setExecutingJobUUID(generatedJobUUID);
            scheduler.scheduleJob(jobDetail, trigger);
            return new JSONResolution((Object)new SuccessMessage(true, generatedJobUUID, null));
        }
        catch (Exception e) {
            log.error(new Object[]{e.getMessage()});
            return new JSONResolution((Object)new SuccessMessage(false, e.getMessage(), null));
        }
    }

    public Resolution executionProgress() {
        DataStoreLinkJob dslJob = SchedulerUtils.getProcessJob((ServletContext)this.getContext().getServletContext(), (String)this.jobUUID);
        try {
            if (dslJob == null) {
                log.debug(new Object[]{"dslJob null!"});
                EntityManager em = JpaUtilServlet.getThreadEntityManager();
                Session session = (Session)em.getDelegate();
                ProcessStatus processStatus = (ProcessStatus)session.createQuery("from ProcessStatus where executingJobUUID = :executingJobUUID").setParameter("executingJobUUID", (Object)this.jobUUID).uniqueResult();
                if (processStatus != null) {
                    log.debug(new Object[]{"job has already finished."});
                    return new JSONResolution((Object)new ProgressMessage(100, processStatus.getMessage()));
                }
                log.debug(new Object[]{"job is still starting up."});
                return new JSONResolution((Object)new ProgressMessage(0));
            }
            DataStoreLinker dsl = dslJob.getDataStoreLinker();
            if (dsl == null) {
                log.debug(new Object[]{"dsl null! dslJob niet, dus bezig met starten van job."});
                return new JSONResolution((Object)new ProgressMessage(0));
            }
            if (dsl.isDisposed()) {
                ProgressMessage progressMessage = new ProgressMessage(100);
                progressMessage.setMessage(dsl.getStatus().getNonFatalErrorReport("<br />", 3));
                return new JSONResolution((Object)progressMessage);
            }
            Status dslStatus = dsl.getStatus();
            int visitedFeatures = dslStatus.getVisitedFeatures();
            int totalFeatureSize = dslStatus.getTotalFeatureSize();
            double fraction = 0.0;
            if (totalFeatureSize > 0) {
                fraction = (double)visitedFeatures / (double)totalFeatureSize;
            }
            int percentage = (int)Math.floor(100.0 * fraction);
            ProgressMessage progressMessage = new ProgressMessage(percentage);
            if (percentage >= 100) {
                progressMessage = new ProgressMessage(99);
            }
            return new JSONResolution((Object)progressMessage);
        }
        catch (Throwable t) {
            String message = new LocalizableMessage("fatalError", new Object[0]).getMessage(this.getContext().getLocale()) + ": " + ExceptionUtils.getRootCauseMessage((Throwable)t);
            return new JSONResolution((Object)new ProgressMessage(message));
        }
    }

    public Resolution cancel() {
        DataStoreLinkJob dslJob = SchedulerUtils.getProcessJob((ServletContext)this.getContext().getServletContext(), (String)this.jobUUID);
        try {
            if (dslJob == null) {
                return new JSONResolution((Object)new SuccessMessage(false));
            }
            dslJob.getDataStoreLinker().getStatus().setInterrupted(true);
            return new JSONResolution((Object)new SuccessMessage(true));
        }
        catch (Throwable t) {
            String message = new LocalizableMessage("fatalError", new Object[0]).getMessage(this.getContext().getLocale()) + ": " + t.getMessage();
            return new JSONResolution((Object)new SuccessMessage(false, message, ""));
        }
    }

    public Resolution exportToXml() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        try {
            String xml = MarshalUtils.marshalProcess((Process)process);
            return new StreamingResolution("text/xml", xml).setFilename("dsl_process.xml");
        }
        catch (Exception ex) {
            log.error((Throwable)ex, new Object[0]);
            return new DefaultErrorResolution(ex.getLocalizedMessage());
        }
    }

    public List<Inout> findInputs() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        List list = new ArrayList();
        list = this.isUserAdmin() ? session.createQuery("from Inout where input_output_type = :type and input_output_datatype = :datatype").setParameter("type", (Object)Inout.TYPE_INPUT).setParameter("datatype", (Object)Inout.TYPE_DATABASE).list() : session.createQuery("from Inout where input_output_type = :type and input_output_datatype = :datatype and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_INPUT).setParameter("datatype", (Object)Inout.TYPE_DATABASE).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(list, new NameableComparer());
        return list;
    }

    public List<Inout> findOutputs() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        ArrayList<Inout> list = new ArrayList();
        if (this.isUserAdmin()) {
            list = session.createQuery("from Inout where input_output_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list();
        } else {
            Organization org = (Organization)session.get(Organization.class, (Serializable)this.getUserOrganiztionId());
            list = org.getOutputs();
        }
        Collections.sort(list, new NameableComparer());
        return list;
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    public void setProcesses(List<Process> processes) {
        this.processes = processes;
    }

    public List<Inout> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<Inout> inputs) {
        this.inputs = inputs;
    }

    public List<Inout> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<Inout> outputs) {
        this.outputs = outputs;
    }

    public List<Inout> getInputsFile() {
        return this.inputsFile;
    }

    public void setInputsFile(List<Inout> inputsFile) {
        this.inputsFile = inputsFile;
    }

    public List<Inout> getInputsDB() {
        return this.inputsDB;
    }

    public void setInputsDB(List<Inout> inputsDB) {
        this.inputsDB = inputsDB;
    }

    public Long getSelectedInputId() {
        return this.selectedInputId;
    }

    public void setSelectedInputId(Long selectedInputId) {
        this.selectedInputId = selectedInputId;
    }

    public Long getSelectedOutputId() {
        return this.selectedOutputId;
    }

    public void setSelectedOutputId(Long selectedOutputId) {
        this.selectedOutputId = selectedOutputId;
    }

    public Long getSelectedProcessId() {
        return this.selectedProcessId;
    }

    public void setSelectedProcessId(Long selectedProcessId) {
        this.selectedProcessId = selectedProcessId;
    }

    public String getActionsList() {
        return this.actionsList;
    }

    public void setActionsList(String actionsList) {
        this.actionsList = actionsList;
    }

    public String getJobUUID() {
        return this.jobUUID;
    }

    public void setJobUUID(String jobUUID) {
        this.jobUUID = jobUUID;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Boolean getAdmin() {
        return this.admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessRemark() {
        return this.processRemark;
    }

    public void setProcessRemark(String processRemark) {
        this.processRemark = processRemark;
    }

    public Long getLinkedProcess() {
        return this.linkedProcess;
    }

    public void setLinkedProcess(Long linkedProcess) {
        this.linkedProcess = linkedProcess;
    }

    public JSONArray getJsonProcesses() {
        return this.jsonProcesses;
    }

    public void setJsonProcesses(JSONArray jsonProcesses) {
        this.jsonProcesses = jsonProcesses;
    }
}

