/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.publish;

import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.datastore.GSOracleNGDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.datastore.GSPostGISDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStoreManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.util.Log;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.publish.GeoserverPublisher;
import nl.b3p.datastorelinker.publish.PublishStatus;
import nl.b3p.datastorelinker.publish.Publisher;

public class GeoserverPublisher
implements Publisher {
    private static final Log log = Log.getInstance(GeoserverPublisher.class);

    public PublishStatus publishDb(String url, String username, String password, Database.Type dbType, String host, int port, String dbUser, String dbPass, String schema, String database, String table, String workspace, String style, ServletContext context) {
        String[] tables = new String[]{table};
        return this.publishDB(url, username, password, dbType, host, port, dbUser, dbPass, schema, database, tables, workspace, style, context);
    }

    private boolean publishLayer(String table, String style, String database, String workspace, GeoServerRESTManager manager, GeoServerRESTReader reader, PublishStatus status) {
        GSFeatureTypeEncoder type = new GSFeatureTypeEncoder();
        type.setName(table);
        type.setSRS("EPSG:28992");
        GSLayerEncoder layer = new GSLayerEncoder();
        layer.setDefaultStyle(style);
        boolean published = manager.getPublisher().publishDBLayer(workspace, database, type, layer);
        if (!published && reader.existsLayer(workspace, table, true)) {
            status.getLayersFailedMessages().append("Laag ");
            status.getLayersFailedMessages().append(table);
            status.getLayersFailedMessages().append(" bestaat al in service. <br/>");
        }
        return published;
    }

    private boolean createDatastore(String host, int port, String dbUser, String dbPass, String schema, String database, String workspace, Database.Type dbType, GeoServerRESTManager manager) {
        GeoServerRESTStoreManager storeMan = manager.getStoreManager();
        GSPostGISDatastoreEncoder ds = null;
        if (null != dbType) {
            switch (1.$SwitchMap$nl$b3p$datastorelinker$entity$Database$Type[dbType.ordinal()]) {
                case 1: {
                    ds = new GSPostGISDatastoreEncoder(database);
                    ds.setDatabase(database);
                    ds.setHost(host);
                    ds.setPassword(dbPass);
                    ds.setUser(dbUser);
                    ds.setNamespace(workspace);
                    ds.setSchema(schema);
                    ds.setPort(port);
                    break;
                }
                case 2: {
                    ds = new GSOracleNGDatastoreEncoder(database, database);
                    ((GSOracleNGDatastoreEncoder)ds).setHost(host);
                    ((GSOracleNGDatastoreEncoder)ds).setHost(host);
                    ((GSOracleNGDatastoreEncoder)ds).setPassword(dbPass);
                    ((GSOracleNGDatastoreEncoder)ds).setUser(dbUser);
                    ((GSOracleNGDatastoreEncoder)ds).setNamespace(workspace);
                    ((GSOracleNGDatastoreEncoder)ds).setSchema(schema);
                    ((GSOracleNGDatastoreEncoder)ds).setPort(port);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Database type must be of Postgis or Oracle");
                }
            }
        }
        boolean created = storeMan.create(workspace, ds);
        return created;
    }

    public PublishStatus publishDB(String url, String username, String password, Database.Type dbType, String host, int port, String dbUser, String dbPass, String schema, String database, String[] tables, String workspace, String style, ServletContext context) {
        PublishStatus status = new PublishStatus();
        try {
            GeoServerRESTManager manager = new GeoServerRESTManager(new URL(url), username, password);
            GeoServerRESTReader reader = manager.getReader();
            if (reader.existGeoserver()) {
                boolean b = manager.getPublisher().createWorkspace(workspace, new URI(workspace));
                status.setServiceCreated(b);
                if (!b && reader.existsWorkspace(workspace)) {
                    status.setServiceMessage("Workspace bestaat al.");
                }
                boolean createdStore = this.createDatastore(host, port, dbUser, dbPass, schema, database, workspace, dbType, manager);
                status.setStoreCreated(createdStore);
                if (!createdStore && reader.existsDatastore(workspace, database)) {
                    status.setStoreMessage("Datastore bestaat al.");
                }
                for (String table : tables) {
                    boolean published = this.publishLayer(table, style, database, workspace, manager, reader, status);
                    if (published) {
                        status.getLayersSucceeded().add(table);
                        continue;
                    }
                    status.getLayersFailed().add(table);
                }
            } else {
                status.setFatal(true);
                status.setFatalMessage("Geoserver bestaat niet");
            }
        }
        catch (MalformedURLException ex) {
            log.error(new Object[]{"Failed to initialize restapi: ", ex});
            status.setFatal(true);
        }
        catch (URISyntaxException ex) {
            log.error(new Object[]{"Failed to initialize restapi: ", ex});
            status.setFatal(true);
        }
        return status;
    }
}

