/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.util;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import net.sourceforge.stripes.action.LocalizableMessage;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.entity.ProcessStatus;
import nl.b3p.datastorelinker.util.SchedulerUtils;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.Status;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class DataStoreLinkJob
implements Job {
    private static final Log log = LogFactory.getLog(DataStoreLinkJob.class);
    private DataStoreLinker dsl = null;
    private Process process = null;
    private Long processId = null;
    private Locale locale = Locale.getDefault();
    private Throwable fatalException = null;
    public static final String KEY_DEFAULT_SMTP_HOST = "defaultSmtpHost";
    public static final String KEY_DEFAULT_FROM_ADDRESS = "defaultFromEmailAddress";

    public synchronized void setFatalException(Throwable fatalException) {
        this.fatalException = fatalException;
    }

    public synchronized DataStoreLinker getDataStoreLinker() throws Throwable {
        if (this.fatalException != null) {
            throw this.fatalException;
        }
        DataStoreLinker tempDsl = this.dsl;
        return tempDsl;
    }

    private void setProcessStatus(ProcessStatus processStatus) throws Exception {
        if (this.processId == null) {
            log.error((Object)("processId was null when attempting to write status to it. " + processStatus));
        } else {
            EntityManager em = JpaUtilServlet.getThreadEntityManager();
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                log.debug((Object)"Starting transaction for default persistence unit.");
                tx.begin();
                Session session = (Session)em.getDelegate();
                this.process = (Process)session.get(Process.class, (Serializable)this.processId);
                log.debug((Object)("process status: " + processStatus));
                if (this.process.getProcessStatus() == null) {
                    session.save((Object)processStatus);
                    this.process.setProcessStatus(processStatus);
                } else {
                    this.process.getProcessStatus().setMessage(processStatus.getMessage());
                    this.process.getProcessStatus().setProcessStatusType(processStatus.getProcessStatusType());
                }
                tx.commit();
            }
            catch (Exception e) {
                this.tryRollback(tx);
                throw e;
            }
            finally {
                JpaUtilServlet.closeThreadEntityManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(JobExecutionContext jec) throws JobExecutionException {
        ProcessStatus finishedStatus;
        block43: {
            Status status;
            EntityTransaction tx;
            block42: {
                Object providedFromAddress;
                String providedSmtpHost;
                finishedStatus = null;
                tx = null;
                log.debug((Object)"Quartz started process");
                this.processId = jec.getJobDetail().getJobDataMap().getLong("processId");
                Locale providedLocale = (Locale)jec.getJobDetail().getJobDataMap().get((Object)"locale");
                if (providedLocale != null) {
                    this.locale = providedLocale;
                }
                if ((providedSmtpHost = (String)jec.getJobDetail().getJobDataMap().get((Object)KEY_DEFAULT_SMTP_HOST)) != null && !providedSmtpHost.isEmpty()) {
                    DataStoreLinker.DEFAULT_SMTPHOST = providedSmtpHost;
                }
                if ((providedFromAddress = (String)jec.getJobDetail().getJobDataMap().get((Object)KEY_DEFAULT_FROM_ADDRESS)) != null && !((String)providedFromAddress).isEmpty()) {
                    DataStoreLinker.DEFAULT_FROM = providedFromAddress;
                }
                this.setProcessStatus(new ProcessStatus(ProcessStatus.Type.RUNNING));
                EntityManager em = JpaUtilServlet.getThreadEntityManager();
                tx = em.getTransaction();
                tx.begin();
                Session session = (Session)em.getDelegate();
                this.process = (Process)session.get(Process.class, (Serializable)this.processId);
                tx.commit();
                if (this.process == null) break block42;
                log.debug((Object)"Xml for process unmarshalled.");
                DataStoreLinkJob dataStoreLinkJob = this;
                synchronized (dataStoreLinkJob) {
                    this.dsl = new DataStoreLinker(this.process);
                }
                this.dsl.process();
                log.debug((Object)"Dsl process done!");
            }
            JpaUtilServlet.closeThreadEntityManager();
            if (this.dsl != null) {
                if (finishedStatus == null) {
                    status = this.dsl.getStatus();
                    log.debug((Object)("Error-count: " + status.getErrorCount()));
                    finishedStatus = status.getErrorCount() == 0 ? (status.getProcessedFeatures() == 0 ? new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3)) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK, status.getNonFatalErrorReport("<br />", 3))) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3));
                }
                try {
                    this.dsl.dispose();
                }
                catch (Exception ex) {
                    log.error((Object)"Could not dispose DataStoreLinker.", (Throwable)ex);
                }
            }
            try {
                this.setProcessStatus(finishedStatus);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            break block43;
            catch (InterruptedException intEx) {
                this.tryRollback(tx);
                log.info((Object)"User canceled the process");
                finishedStatus = new ProcessStatus(ProcessStatus.Type.CANCELED_BY_USER);
                JpaUtilServlet.closeThreadEntityManager();
                if (this.dsl != null) {
                    if (finishedStatus == null) {
                        status = this.dsl.getStatus();
                        log.debug((Object)("Error-count: " + status.getErrorCount()));
                        finishedStatus = status.getErrorCount() == 0 ? (status.getProcessedFeatures() == 0 ? new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3)) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK, status.getNonFatalErrorReport("<br />", 3))) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3));
                    }
                    try {
                        this.dsl.dispose();
                    }
                    catch (Exception ex) {
                        log.error((Object)"Could not dispose DataStoreLinker.", (Throwable)ex);
                    }
                }
                try {
                    this.setProcessStatus(finishedStatus);
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
            catch (Exception ex) {
                this.tryRollback(tx);
                this.setFatalException((Throwable)ex);
                log.warn((Object)"Fatal Exception: ", this.fatalException);
                finishedStatus = new ProcessStatus(ProcessStatus.Type.LAST_RUN_FATAL_ERROR, new LocalizableMessage("fatalError", new Object[0]).getMessage(this.locale) + ": " + ExceptionUtils.getRootCauseMessage((Throwable)this.fatalException));
                {
                    catch (Throwable throwable) {
                        JpaUtilServlet.closeThreadEntityManager();
                        if (this.dsl != null) {
                            if (finishedStatus == null) {
                                Status status2 = this.dsl.getStatus();
                                log.debug((Object)("Error-count: " + status2.getErrorCount()));
                                finishedStatus = status2.getErrorCount() == 0 ? (status2.getProcessedFeatures() == 0 ? new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status2.getNonFatalErrorReport("<br />", 3)) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK, status2.getNonFatalErrorReport("<br />", 3))) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status2.getNonFatalErrorReport("<br />", 3));
                            }
                            try {
                                this.dsl.dispose();
                            }
                            catch (Exception ex2) {
                                log.error((Object)"Could not dispose DataStoreLinker.", (Throwable)ex2);
                            }
                        }
                        try {
                            this.setProcessStatus(finishedStatus);
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                        throw throwable;
                    }
                }
                JpaUtilServlet.closeThreadEntityManager();
                if (this.dsl != null) {
                    if (finishedStatus == null) {
                        status = this.dsl.getStatus();
                        log.debug((Object)("Error-count: " + status.getErrorCount()));
                        finishedStatus = status.getErrorCount() == 0 ? (status.getProcessedFeatures() == 0 ? new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3)) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK, status.getNonFatalErrorReport("<br />", 3))) : new ProcessStatus(ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS, status.getNonFatalErrorReport("<br />", 3));
                    }
                    try {
                        this.dsl.dispose();
                    }
                    catch (Exception ex3) {
                        log.error((Object)"Could not dispose DataStoreLinker.", (Throwable)ex3);
                    }
                }
                try {
                    this.setProcessStatus(finishedStatus);
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        List linkedProcesses = em.createQuery("FROM Process WHERE linked_process = :id").setParameter("id", (Object)this.process.getId()).getResultList();
        if (linkedProcesses != null && !linkedProcesses.isEmpty()) {
            if (finishedStatus.getProcessStatusType() == ProcessStatus.Type.LAST_RUN_OK || finishedStatus.getProcessStatusType() == ProcessStatus.Type.LAST_RUN_OK_WITH_ERRORS) {
                try {
                    for (Process linked : linkedProcesses) {
                        log.info((Object)("Schedule linked process: " + linked.getName() + " from parent process: " + this.process.getName()));
                        this.scheduleDslJobImmediately(linked);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Linked process schedule could not be created: ", (Throwable)ex);
                }
            } else {
                log.error((Object)"Linked process not started due to errors in previous process.");
            }
        }
    }

    public void scheduleDslJobImmediately(Process process) throws SchedulerException, Exception {
        String generatedJobUUID = "job" + UUID.randomUUID().toString();
        JobDetail jobDetail = new JobDetail(generatedJobUUID, DataStoreLinkJob.class);
        jobDetail.getJobDataMap().put((Object)"processId", (Object)process.getId());
        jobDetail.getJobDataMap().put((Object)"locale", (Object)this.locale);
        Trigger trigger = TriggerUtils.makeImmediateTrigger((String)generatedJobUUID, (int)0, (long)0L);
        Scheduler scheduler = SchedulerUtils.getScheduler(null);
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        EntityTransaction tx = null;
        tx = em.getTransaction();
        try {
            tx.begin();
            process.getProcessStatus().setExecutingJobUUID(generatedJobUUID);
            tx.commit();
        }
        catch (Exception e) {
            this.tryRollback(tx);
            throw e;
        }
        finally {
            JpaUtilServlet.closeThreadEntityManager();
        }
        scheduler.scheduleJob(jobDetail, trigger);
    }

    private void tryRollback(EntityTransaction tx) {
        if (tx != null && tx.isActive()) {
            log.error((Object)"Exception occurred - rolling back active transaction");
            try {
                tx.rollback();
            }
            catch (Exception e) {
                log.error((Object)"Exception rolling back transaction", (Throwable)e);
            }
        }
    }
}

