/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.publish;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.util.Log;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.publish.PublishStatus;
import nl.b3p.datastorelinker.publish.Publisher;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.mapfile.pojo.ClassStyle;
import nl.b3p.mapfile.pojo.Layer;
import nl.b3p.mapfile.pojo.LayerClass;
import nl.b3p.mapfile.pojo.Mapfile;
import nl.b3p.mapfile.pojo.WebMetadata;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;

public class MapserverPublisher
implements Publisher {
    private static final Log log = Log.getInstance(MapserverPublisher.class);
    private String propertiesFile = "/WEB-INF/velocity.properties";
    private int strSRS = 28992;

    public PublishStatus publishDb(String url, String username, String password, Database.Type dbType, String host, int port, String dbUser, String dbPass, String schema, String database, String table, String serviceName, String style, ServletContext context) {
        PublishStatus status = new PublishStatus();
        String[] tables = new String[]{table};
        return this.createMapfile(dbType, host, port, dbUser, dbPass, schema, database, tables, serviceName, context);
    }

    public PublishStatus publishDB(String url, String username, String password, Database.Type dbType, String host, int port, String dbUser, String dbPass, String schema, String database, String[] table, String serviceName, String style, ServletContext context) {
        PublishStatus status = new PublishStatus();
        return this.createMapfile(dbType, host, port, dbUser, dbPass, schema, database, table, serviceName, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishStatus createMapfile(Database.Type dbType, String host, int port, String dbUser, String dbPass, String schema, String database, String[] tables, String serviceName, ServletContext c) {
        PublishStatus status = new PublishStatus();
        String mapFilePath = c.getInitParameter("publisher.mapfileLocation");
        if (host == null || mapFilePath == null || serviceName == null) {
            throw new IllegalArgumentException("Missende Mapserver parameters.");
        }
        Mapfile map = new Mapfile();
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy HH:mm", new Locale("NL"));
        map.setCreateDate(df.format(now));
        map.setName(serviceName.replaceAll(" ", "_") + "_Service");
        map.setDatabaseType(dbType.toString().toLowerCase());
        WebMetadata webMeta = new WebMetadata();
        String resource = this.createResourceString(host, mapFilePath, serviceName);
        webMeta.setWmsTitle(serviceName + " Service");
        webMeta.setWmsOnlineResource(resource);
        webMeta.setWfsTitle(serviceName + " WFS Service");
        webMeta.setWfsOnlineResource(resource);
        webMeta.setOwsTitle(serviceName + " OWS Service");
        webMeta.setOwsOnlineResource(resource);
        map.getWeb().setMetadata(webMeta);
        DataStore ds = this.openDataStore(schema, port, dbPass, dbType.toString(), host, dbUser, database);
        try {
            for (int i = 0; i < tables.length; ++i) {
                String tableName = tables[i];
                SimpleFeature feature = null;
                if (ds == null || (feature = this.getExampleFeature(ds, tableName)) == null) continue;
                String type = this.getTableGeomType(feature);
                String geomColumn = this.getGeomColumnName(feature);
                String pkColumn = this.getPkColumn(feature);
                Layer l = this.createMapfileLayer(tableName, type);
                this.fillConnectionAndData(l, type, database, host, port, dbUser, dbPass, geomColumn, tableName, pkColumn, dbType);
                map.addLayer(l);
            }
        }
        catch (Exception ex) {
            log.error(new Object[]{"Fout tijdens ophalen tabel types: ", ex});
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setApplicationAttribute((Object)"javax.servlet.ServletContext", (Object)c);
            ve.init(this.loadConfiguration(this.propertiesFile, c));
            Template t = ve.getTemplate("basis.vm");
            VelocityContext vcontext = new VelocityContext();
            vcontext.put("map", (Object)map);
            StringWriter writer = new StringWriter();
            t.merge((Context)vcontext, (Writer)writer);
            log.info(new Object[]{writer.toString()});
        }
        catch (Exception e) {
            log.error(new Object[]{"Fout bij maken mapfile: ", e});
        }
        return status;
    }

    private void fillConnectionAndData(Layer layer, String type, String db, String host, int port, String user, String passw, String geomColumn, String tableName, String pkColumn, Database.Type dbType) {
        if (dbType.equals((Object)Database.Type.ORACLE)) {
            layer.setConnectionType("oraclespatial");
        } else if (dbType.equals((Object)Database.Type.POSTGIS)) {
            layer.setConnectionType("postgis");
        } else {
            layer.setConnectionType("");
        }
        layer.setConnectionDatabase(db);
        layer.setConnectionHost(host);
        layer.setConnectionPort(port);
        layer.setConnectionUser(user);
        layer.setConnectionPassword(passw);
        layer.setDataGeomColumn(geomColumn);
        layer.setDataTableName(tableName);
        layer.setDataPrimaryKeyColumn(pkColumn);
        if (dbType.equals((Object)Database.Type.ORACLE)) {
            layer.setDataSrid(this.strSRS);
        } else {
            layer.setDataSrid(this.strSRS);
        }
    }

    private Layer createMapfileLayer(String tableName, String type) {
        Layer layer = new Layer();
        layer.setName(tableName);
        layer.setType(type);
        layer.getMetadata().setWmsTitle(tableName);
        layer.getMetadata().setWfsTitle(tableName);
        layer.getMetadata().setOwsTitle(tableName);
        LayerClass layerClass = new LayerClass();
        layerClass.setName(tableName);
        ClassStyle style = new ClassStyle();
        if (type.equals("POINT")) {
            style.setSymbol("circle");
            style.setOutlineColorR(0);
            style.setOutlineColorG(0);
            style.setOutlineColorB(0);
            style.setColorR(255);
            style.setColorG(255);
            style.setColorB(255);
        } else if (type.equals("LINE")) {
            style.setOutlineColorR(0);
            style.setOutlineColorG(0);
            style.setOutlineColorB(0);
            style.setColorR(0);
            style.setColorG(255);
            style.setColorB(0);
            style.setWidth(2.0);
        } else {
            style.setOutlineColorR(0);
            style.setOutlineColorG(0);
            style.setOutlineColorB(0);
            style.setColorR(0);
            style.setColorG(0);
            style.setColorB(255);
        }
        layerClass.setStyle(style);
        layer.addLayerClass(layerClass);
        return layer;
    }

    private DataStore openDataStore(String schema, int port, String passw, String dbType, String host, String user, String database) {
        DataStore ds = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("schema", schema);
        params.put("port", port);
        params.put("passwd", passw);
        params.put("dbtype", dbType.toLowerCase());
        params.put("host", host);
        params.put("validate connections", false);
        params.put("user", user);
        params.put("database", database);
        try {
            ds = DataStoreLinker.openDataStore(params);
        }
        catch (Exception ex) {
            log.error(new Object[]{"Fout openen Datastore: ", ex});
        }
        return ds;
    }

    private String getPkColumn(SimpleFeature feature) {
        return ((AttributeDescriptor)feature.getFeatureType().getAttributeDescriptors().get(0)).getLocalName();
    }

    private String getGeomColumnName(SimpleFeature feature) {
        return feature.getDefaultGeometryProperty().getDescriptor().getLocalName();
    }

    private String getTableGeomType(SimpleFeature feature) {
        String type = feature.getDefaultGeometry().toString();
        if (type.toUpperCase().contains("POINT")) {
            return "POINT";
        }
        if (type.toUpperCase().contains("LINE")) {
            return "LINE";
        }
        if (type.toUpperCase().contains("POLYGON")) {
            return "POLYGON";
        }
        return "POLYGON";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeature getExampleFeature(DataStore ds, String tableName) throws Exception {
        if (tableName == null) {
            if (ds.getTypeNames().length == 0) {
                throw new IllegalArgumentException("no typeNames");
            }
            tableName = ds.getTypeNames()[0];
        }
        Query q = new Query();
        q.setMaxFeatures(1);
        SimpleFeatureCollection fc = ds.getFeatureSource(tableName).getFeatures(q);
        try (FeatureIterator iterator = fc.features();){
            if (iterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
                return simpleFeature;
            }
        }
        throw new Exception("Geen features gevonden.");
    }

    private String createResourceString(String mapserverUrl, String mapFilePath, String serviceName) {
        StringBuilder str = new StringBuilder();
        str.append(mapserverUrl);
        if (!mapserverUrl.contains("?")) {
            str.append("?");
        }
        str.append("map=");
        str.append(mapFilePath);
        if (mapFilePath.lastIndexOf("/") != mapFilePath.length() - 1) {
            str.append("/");
        }
        String name = this.createMapFileName(serviceName);
        str.append(name);
        return str.toString();
    }

    private String createMapFileName(String serviceName) {
        String fileName = serviceName.trim().replaceAll(" ", "");
        fileName = fileName + ".map";
        return fileName.toLowerCase();
    }

    private Properties loadConfiguration(String propsFile, ServletContext context) throws IOException, FileNotFoundException {
        InputStream iStream;
        Properties p = new Properties();
        if (propsFile != null && (iStream = context.getResourceAsStream(propsFile)) != null) {
            p.load(iStream);
        }
        return p;
    }

    public void setStrSRS(String strSRS) {
        if (strSRS == null) {
            return;
        }
        try {
            this.strSRS = Integer.parseInt(strSRS);
        }
        catch (NumberFormatException nfe) {
            log.error((Throwable)nfe, new Object[]{nfe.getLocalizedMessage(), "Controleer de SRS waarde in de context.xml"});
        }
    }
}

