/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.File;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Organization;
import nl.b3p.datastorelinker.entity.Users;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.security.UserPrincipal;
import nl.b3p.ogc.utils.KBCrypter;
import org.hibernate.Session;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class AuthorizationAction
extends DefaultAction {
    private static final Log log = Log.getInstance(AuthorizationAction.class);
    private static final String ADMIN_ORG_JSP = "/WEB-INF/jsp/management/authOrgAdmin.jsp";
    private static final String LIST_ORGS_JSP = "/WEB-INF/jsp/main/auth/orgs/list.jsp";
    private static final String CREATE_ORG_JSP = "/WEB-INF/jsp/main/auth/orgs/create.jsp";
    private List<Organization> orgs;
    private Integer selectedOrgId;
    private Organization selectedOrg;
    private String orgName;
    private String orgUploadPath;
    private static final String ADMIN_USERS_JSP = "/WEB-INF/jsp/management/authUsersAdmin.jsp";
    private static final String LIST_USERS_JSP = "/WEB-INF/jsp/main/auth/users/list.jsp";
    private static final String CREATE_USER_JSP = "/WEB-INF/jsp/main/auth/users/create.jsp";
    private List<Users> userList;
    private Integer selectedUserId;
    private Users selectedUser;
    private String userName;
    private String userPassword;
    private String userPasswordAgain;
    private Boolean userIsAdmin = false;
    private Integer userOrgId;

    @DefaultHandler
    public Resolution admin_org() {
        this.list_orgs();
        return new ForwardResolution("/WEB-INF/jsp/management/authOrgAdmin.jsp");
    }

    public Resolution admin_users() {
        this.list_users();
        return new ForwardResolution("/WEB-INF/jsp/management/authUsersAdmin.jsp");
    }

    public Resolution list_orgs() {
        this.orgs = AuthorizationAction.getOrganizations();
        return new ForwardResolution("/WEB-INF/jsp/main/auth/orgs/list.jsp");
    }

    public Resolution list_users() {
        this.userList = AuthorizationAction.getUsers();
        return new ForwardResolution("/WEB-INF/jsp/main/auth/users/list.jsp");
    }

    public static List<Users> getUsers() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        List users = sess.createQuery("from Users order by name").list();
        return users;
    }

    public static List<Organization> getOrganizations() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        List orgs = sess.createQuery("from Organization order by name").list();
        return orgs;
    }

    public Resolution deleteOrganization() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedOrgId != null && this.selectedOrgId == 1) {
            return this.list_orgs();
        }
        if (this.selectedOrgId != null) {
            Organization org = (Organization)sess.get(Organization.class, (Serializable)this.selectedOrgId);
            sess.delete((Object)org);
        }
        return this.list_orgs();
    }

    public Resolution deleteUser() {
        UserPrincipal user;
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedUserId != null && this.selectedUserId == 1) {
            return this.list_orgs();
        }
        Principal principal = this.getContext().getRequest().getUserPrincipal();
        if (principal != null && principal instanceof UserPrincipal && (user = (UserPrincipal)principal).getUserId().equals(this.selectedUserId)) {
            return this.list_orgs();
        }
        if (this.selectedUserId != null) {
            user = (Users)sess.get(Users.class, (Serializable)this.selectedUserId);
            sess.delete((Object)user);
        }
        return this.list_users();
    }

    public Resolution updateOrganization() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedOrgId != null) {
            this.selectedOrg = (Organization)sess.get(Organization.class, (Serializable)this.selectedOrgId);
        }
        return new ForwardResolution("/WEB-INF/jsp/main/auth/orgs/create.jsp");
    }

    public Resolution updateUser() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedUserId != null) {
            this.selectedUser = (Users)sess.get(Users.class, (Serializable)this.selectedUserId);
        }
        this.orgs = AuthorizationAction.getOrganizations();
        return new ForwardResolution("/WEB-INF/jsp/main/auth/users/create.jsp");
    }

    public Resolution createOrganization() {
        return new ForwardResolution("/WEB-INF/jsp/main/auth/orgs/create.jsp");
    }

    public Resolution createOrganizationComplete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedOrgId != null) {
            this.selectedOrg = (Organization)sess.get(Organization.class, (Serializable)this.selectedOrgId);
        }
        Organization org = null;
        org = this.selectedOrg == null ? new Organization() : this.selectedOrg;
        org.setName(this.orgName);
        String uploadFolder = this.orgName.replace(" ", "_").toLowerCase();
        File file = new File(this.getUploadPath() + File.separator + uploadFolder);
        if (!file.exists()) {
            file.mkdir();
        }
        org.setUploadPath(uploadFolder);
        if (this.selectedOrgId == null) {
            this.selectedOrgId = (Integer)sess.save((Object)org);
        } else {
            sess.update((Object)org);
        }
        return this.list_orgs();
    }

    public Resolution createUser() {
        this.orgs = AuthorizationAction.getOrganizations();
        return new ForwardResolution("/WEB-INF/jsp/main/auth/users/create.jsp");
    }

    public Resolution createUserComplete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session sess = (Session)em.getDelegate();
        if (this.selectedUserId != null) {
            this.selectedUser = (Users)sess.get(Users.class, (Serializable)this.selectedUserId);
        }
        Users user = null;
        user = this.selectedUser == null ? new Users() : this.selectedUser;
        Organization org = null;
        if (this.userOrgId != null) {
            org = (Organization)sess.get(Organization.class, (Serializable)this.userOrgId);
        }
        if (org != null) {
            user.setOrganization(org);
        }
        user.setName(this.userName);
        if (this.userPassword != null && this.userPassword.equals(this.userPasswordAgain)) {
            user.setPassword(this.encryptUserPassword(this.userPassword));
        }
        user.setIsAdmin(this.userIsAdmin);
        if (this.selectedUserId == null) {
            this.selectedUserId = (Integer)sess.save((Object)user);
        } else {
            sess.update((Object)user);
        }
        return this.list_users();
    }

    private String encryptUserPassword(String password) {
        String encpw = null;
        try {
            encpw = KBCrypter.encryptText((String)FormUtils.nullIfEmpty((String)password));
        }
        catch (Exception ex) {
            log.debug(new Object[]{"Fout tijdens encrypten van wachtwoord."});
        }
        return encpw;
    }

    public List<Organization> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<Organization> orgs) {
        this.orgs = orgs;
    }

    public Integer getSelectedOrgId() {
        return this.selectedOrgId;
    }

    public void setSelectedOrgId(Integer selectedOrgId) {
        this.selectedOrgId = selectedOrgId;
    }

    public Organization getSelectedOrg() {
        return this.selectedOrg;
    }

    public void setSelectedOrg(Organization selectedOrg) {
        this.selectedOrg = selectedOrg;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgUploadPath() {
        return this.orgUploadPath;
    }

    public void setOrgUploadPath(String orgUploadPath) {
        this.orgUploadPath = orgUploadPath;
    }

    public Users getSelectedUser() {
        return this.selectedUser;
    }

    public void setSelectedUser(Users selectedUser) {
        this.selectedUser = selectedUser;
    }

    public Integer getSelectedUserId() {
        return this.selectedUserId;
    }

    public void setSelectedUserId(Integer selectedUserId) {
        this.selectedUserId = selectedUserId;
    }

    public Boolean getUserIsAdmin() {
        return this.userIsAdmin;
    }

    public void setUserIsAdmin(Boolean userIsAdmin) {
        this.userIsAdmin = userIsAdmin;
    }

    public List<Users> getUserList() {
        return this.userList;
    }

    public void setUserList(List<Users> userList) {
        this.userList = userList;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getUserPasswordAgain() {
        return this.userPasswordAgain;
    }

    public void setUserPasswordAgain(String userPasswordAgain) {
        this.userPasswordAgain = userPasswordAgain;
    }

    public Integer getUserOrgId() {
        return this.userOrgId;
    }

    public void setUserOrgId(Integer userOrgId) {
        this.userOrgId = userOrgId;
    }
}

