/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.gui.stripes.DatabaseOutputAction;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.json.JSONErrorResolution;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.json.SuccessMessage;
import nl.b3p.datastorelinker.util.NameableComparer;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import org.geotools.data.DataStore;
import org.hibernate.Session;

@Transactional
public class DatabaseOutputAction
extends DefaultAction {
    private Log log = Log.getInstance(DatabaseOutputAction.class);
    private Boolean admin;
    private List<Database> databases;
    private Database selectedDatabase;
    protected Long selectedDatabaseId;
    private Database.Type dbType;
    private String host;
    private String databaseName;
    private String username;
    private String password;
    private Integer port;
    private String schema;
    private String alias;
    private String url;
    private String srs;
    private String colX;
    private String colY;
    private String timeout;
    private String buffersize;

    @DefaultHandler
    public Resolution admin() {
        this.setAdmin(Boolean.valueOf(true));
        this.list();
        return new ForwardResolution(this.getAdminJsp());
    }

    protected String getAdminJsp() {
        return "/WEB-INF/jsp/management/databaseOutAdmin.jsp";
    }

    protected String getCreateJsp() {
        return "/WEB-INF/jsp/main/database_out/create.jsp";
    }

    protected String getListJsp() {
        return "/WEB-INF/jsp/main/database_out/list.jsp";
    }

    @DontValidate
    public Resolution create() {
        return new ForwardResolution(this.getCreateJsp());
    }

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.databases = this.isUserAdmin() ? session.createQuery("from Database where inout_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list() : session.createQuery("from Database where inout_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_OUTPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.databases, new NameableComparer());
        return new ForwardResolution(this.getListJsp());
    }

    public Resolution delete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        session.delete(session.get(Database.class, (Serializable)this.selectedDatabaseId));
        return this.list();
    }

    public Resolution update() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        return this.create();
    }

    public Resolution createComplete() {
        Database db = this.saveDatabase(Database.TypeInout.OUTPUT);
        this.selectedDatabaseId = db.getId();
        return this.list();
    }

    protected Database saveDatabase(Database.TypeInout typeInout) {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Database database = this.getDatabase(false);
        database.setTypeInout(typeInout);
        if (database.getUserId() == null && database.getOrganizationId() == null) {
            database.setOrganizationId(this.getUserOrganiztionId());
            database.setUserId(this.getUserId());
        }
        if (this.selectedDatabaseId == null) {
            session.save((Object)database);
        }
        return database;
    }

    protected Database getDatabase(boolean alwaysCreateNewDB) {
        Database database;
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        if (this.selectedDatabaseId == null || alwaysCreateNewDB) {
            database = new Database();
        } else {
            database = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
            database.reset();
        }
        database.setType(this.dbType);
        switch (1.$SwitchMap$nl$b3p$datastorelinker$entity$Database$Type[this.dbType.ordinal()]) {
            case 1: {
                database.setHost(this.host);
                database.setDatabaseName(this.databaseName);
                database.setUsername(this.username);
                database.setPassword(this.password);
                database.setPort(this.port);
                database.setSchema(this.schema);
                database.setAlias(this.alias);
                break;
            }
            case 2: {
                database.setUrl(this.url);
                database.setSrs(this.srs);
                database.setColX(this.colX);
                database.setColY(this.colY);
                break;
            }
            case 3: {
                database.setHost(this.host);
                database.setDatabaseName(this.databaseName);
                database.setUsername(this.username);
                database.setPassword(this.password);
                database.setPort(this.port);
                database.setSchema(this.schema);
                break;
            }
            case 4: {
                database.setUrl(this.url);
                database.setDatabaseName(this.url);
                database.setUsername(this.username);
                database.setPassword(this.password);
                database.setTimeout(this.timeout);
                database.setBuffersize(this.buffersize);
                break;
            }
            default: {
                this.log.error(new Object[]{"Unsupported database type"});
                return null;
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution testConnection() {
        DataStore dataStore = null;
        try {
            dataStore = DataStoreLinker.openDataStore((Database)this.getDatabase(true));
            if (dataStore == null) {
                throw new Exception("Datastore is null");
            }
            String[] stringArray = dataStore.getTypeNames();
        }
        catch (Exception e) {
            this.log.debug(new Object[]{"db connection error", e});
            JSONErrorResolution jSONErrorResolution = new JSONErrorResolution(e.getMessage(), "Databaseconnectie fout");
            return jSONErrorResolution;
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        this.log.debug(new Object[]{"db connection success"});
        return new JSONResolution((Object)new SuccessMessage());
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<Database> databases) {
        this.databases = databases;
    }

    public Database.Type getDbType() {
        return this.dbType;
    }

    public void setDbType(Database.Type dbType) {
        this.dbType = dbType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public String getColX() {
        return this.colX;
    }

    public void setColX(String colX) {
        this.colX = colX;
    }

    public String getColY() {
        return this.colY;
    }

    public void setColY(String colY) {
        this.colY = colY;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getBuffersize() {
        return this.buffersize;
    }

    public void setBuffersize(String buffersize) {
        this.buffersize = buffersize;
    }

    public Long getSelectedDatabaseId() {
        return this.selectedDatabaseId;
    }

    public void setSelectedDatabaseId(Long selectedDatabaseId) {
        this.selectedDatabaseId = selectedDatabaseId;
    }

    public Database getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public void setSelectedDatabase(Database selectedDatabase) {
        this.selectedDatabase = selectedDatabase;
    }

    public Boolean getAdmin() {
        return this.admin;
    }

    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }
}

