/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import net.sf.json.JSONObject;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.gui.stripes.DatabaseAction;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.util.NameableComparer;
import org.hibernate.Session;

@Transactional
public class OutputAction
extends DatabaseAction {
    private Log log = Log.getInstance(OutputAction.class);
    private List<Inout> outputs;
    private Long selectedOutputId;
    private Boolean drop;
    private Boolean append;
    private String checkOutputId;

    protected String getAdminJsp() {
        return "/WEB-INF/jsp/management/outputAdmin.jsp";
    }

    protected String getCreateJsp() {
        return "/WEB-INF/jsp/main/output/create.jsp";
    }

    protected String getListJsp() {
        return "/WEB-INF/jsp/main/output/list.jsp";
    }

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.outputs = this.isUserAdmin() ? session.createQuery("from Inout where input_output_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list() : session.createQuery("from Inout where input_output_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_OUTPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.outputs, new NameableComparer());
        return new ForwardResolution(this.getListJsp());
    }

    public static List<Inout> findOutputs() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        List list = session.getNamedQuery("Inout.find").setParameter("typeName", (Object)Inout.Type.OUTPUT).list();
        Collections.sort(list, new NameableComparer());
        return list;
    }

    public Resolution checkOutputIsUseTableTemplate() {
        EntityManager em;
        Session session;
        Inout output;
        JSONObject obj = null;
        String outputType = null;
        if (this.checkOutputId != null && (output = (Inout)(session = (Session)(em = JpaUtilServlet.getThreadEntityManager()).getDelegate()).get(Inout.class, (Serializable)new Long(this.checkOutputId))) != null) {
            outputType = output.getTemplateOutput();
        }
        obj = new JSONObject();
        obj.put((Object)"type", outputType);
        return new JSONResolution((Object)obj);
    }

    public Resolution delete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout selectedOutput = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        this.selectedDatabaseId = selectedOutput.getDatabase().getId();
        return super.delete();
    }

    public Resolution update() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout output = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        this.selectedDatabaseId = output.getDatabase().getId();
        return super.update();
    }

    public Resolution createComplete() {
        Database database = this.saveDatabase(Database.TypeInout.OUTPUT);
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout output = this.selectedOutputId == null ? new Inout() : (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        output.setType(Inout.Type.OUTPUT);
        output.setDatatype(Inout.Datatype.DATABASE);
        output.setDatabase(database);
        if (output.getUserId() == null && output.getOrganizationId() == null) {
            output.setOrganizationId(this.getUserOrganiztionId());
            output.setUserId(this.getUserId());
        }
        if (this.selectedOutputId == null) {
            this.selectedOutputId = (Long)session.save((Object)output);
        }
        return this.list();
    }

    public List<Inout> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<Inout> outputs) {
        this.outputs = outputs;
    }

    public Long getSelectedOutputId() {
        return this.selectedOutputId;
    }

    public void setSelectedOutputId(Long selectedOutputId) {
        this.selectedOutputId = selectedOutputId;
    }

    public Boolean getDrop() {
        return this.drop;
    }

    public void setDrop(Boolean drop) {
        this.drop = drop;
    }

    public Boolean getAppend() {
        return this.append;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public String getCheckOutputId() {
        return this.checkOutputId;
    }

    public void setCheckOutputId(String checkOutputId) {
        this.checkOutputId = checkOutputId;
    }
}

