/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import net.sf.json.JSONObject;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.gui.stripes.ActionsAction;
import nl.b3p.datastorelinker.gui.stripes.DatabaseOutputAction;
import nl.b3p.datastorelinker.gui.stripes.OutputActionNew;
import nl.b3p.datastorelinker.json.JSONErrorResolution;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.util.DefaultErrorResolution;
import nl.b3p.datastorelinker.util.NameableComparer;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.util.DataStoreUtil;
import nl.b3p.geotools.data.linker.util.DataTypeList;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.hibernate.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@Transactional
public class OutputActionNew
extends DatabaseOutputAction {
    private static final Log log = Log.getInstance(OutputActionNew.class);
    private static final String LIST_JSP = "/WEB-INF/jsp/main/output_new/database/list.jsp";
    private static final String TABLE_LIST_JSP = "/WEB-INF/jsp/main/output_new/table/list.jsp";
    private static final String CREATE_DATABASE_JSP = "/WEB-INF/jsp/main/output_new/database/create.jsp";
    private static final String CREATE_FILE_JSP = "/WEB-INF/jsp/main/output_new/file/create.jsp";
    private static final String EXAMPLE_RECORD_JSP = "/WEB-INF/jsp/main/actions/exampleOutputRecord.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/management/outputAdminNew.jsp";
    private List<Inout> inputs;
    private Long selectedOutputId;
    private List<Database> databases;
    private Long selectedDatabaseId;
    private String selectedFilePath;
    private List<String> tables;
    private List<String> failedTables;
    private String selectedTable;
    private List<String> outputColumnNames;
    private List<Object> outputRecordValues;
    private String selectedTemplateOutput;

    @DefaultHandler
    public Resolution admin() {
        this.list();
        return new ForwardResolution(ADMIN_JSP);
    }

    public Resolution list() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.inputs = this.isUserAdmin() ? session.createQuery("from Inout where input_output_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list() : session.createQuery("from Inout where input_output_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_OUTPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.inputs, new NameableComparer());
        return new ForwardResolution(LIST_JSP);
    }

    public Resolution delete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        session.delete(session.get(Inout.class, (Serializable)this.selectedOutputId));
        return this.list();
    }

    public Resolution update() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout input = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        this.selectedTable = input.getTableName();
        this.selectedTemplateOutput = input.getTemplateOutput();
        switch (2.$SwitchMap$nl$b3p$datastorelinker$entity$Inout$Datatype[input.getDatatype().ordinal()]) {
            case 1: {
                this.selectedDatabaseId = input.getDatabase().getId();
                return this.createDatabaseInput();
            }
        }
        log.error(new Object[]{"Unknown input type."});
        return null;
    }

    public Resolution createDatabaseInput() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        this.databases = this.isUserAdmin() ? session.createQuery("from Database where inout_type = :type").setParameter("type", (Object)Inout.TYPE_OUTPUT).list() : session.createQuery("from Database where inout_type = :type and organization_id = :orgid").setParameter("type", (Object)Inout.TYPE_OUTPUT).setParameter("orgid", (Object)this.getUserOrganiztionId()).list();
        Collections.sort(this.databases, new NameableComparer());
        return new ForwardResolution(CREATE_DATABASE_JSP);
    }

    public Resolution createFileInput() {
        return new ForwardResolution(CREATE_FILE_JSP);
    }

    public Resolution createDatabaseInputComplete() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Database selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        Inout dbInput = null;
        dbInput = this.selectedOutputId == null ? new Inout() : (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        dbInput.setType(Inout.Type.OUTPUT);
        dbInput.setDatatype(Inout.Datatype.DATABASE);
        dbInput.setDatabase(selectedDatabase);
        dbInput.setTableName(this.selectedTable);
        dbInput.setOrganizationId(this.getUserOrganiztionId());
        dbInput.setUserId(this.getUserId());
        if (this.selectedTemplateOutput != null) {
            dbInput.setTemplateOutput(this.selectedTemplateOutput);
        }
        if (this.selectedOutputId == null) {
            this.selectedOutputId = (Long)session.save((Object)dbInput);
        }
        return this.list();
    }

    public Resolution createTablesList() {
        Inout input;
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        if (this.selectedOutputId != null && this.selectedDatabaseId.equals((input = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId)).getDatabase().getId())) {
            this.selectedTemplateOutput = input.getTemplateOutput();
            this.selectedTable = input.getTableName();
        }
        Database selectedDatabase = (Database)session.get(Database.class, (Serializable)this.selectedDatabaseId);
        try {
            DataTypeList dataTypeList = DataStoreUtil.getDataTypeList((Map)selectedDatabase.toGeotoolsDataStoreParametersMap());
            if (dataTypeList != null) {
                this.tables = dataTypeList.getGood();
                this.failedTables = dataTypeList.getBad();
                return new ForwardResolution(TABLE_LIST_JSP);
            }
            throw new Exception("Error getting datatypes from DataStore.");
        }
        catch (Exception e) {
            String tablesError = "Fout bij ophalen tabellen. ";
            log.error(new Object[]{tablesError + e.getMessage()});
            return new DefaultErrorResolution(tablesError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getTypeNames() {
        log.debug(new Object[]{"getTypeNames"});
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        DataStore ds = null;
        try {
            Inout input = null;
            if (this.selectedOutputId != null) {
                input = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
                if (input.getTemplateOutput() != null) {
                    ActionsAction.setTemplateOutputType((String)input.getTemplateOutput());
                }
                if (input.getTemplateOutput() != null && input.getTemplateOutput().equals(Inout.TEMPLATE_OUTPUT_NO_TABLE)) {
                    Resolution resolution = null;
                    return resolution;
                }
                if (input.getTemplateOutput() != null && input.getTemplateOutput().equals(Inout.TEMPLATE_OUTPUT_USE_TABLE)) {
                    ActionsAction.setOutputTablename((String)input.getTableName());
                }
            }
            String tableName = null;
            if (input.getDatabase() != null) {
                ds = DataStoreLinker.openDataStore((Database)input.getDatabase());
                tableName = input.getTableName();
            } else if (input.getFile() != null) {
                ds = DataStoreLinker.openDataStore((String)input.getFile());
            } else {
                throw new Exception("unsupported input type.");
            }
            SimpleFeatureSource source = ds.getFeatureSource(tableName);
            List srcAttrDesc = ((SimpleFeatureType)source.getSchema()).getAttributeDescriptors();
            ArrayList<AttributeDescriptor> attrDescs = new ArrayList<AttributeDescriptor>(srcAttrDesc.size());
            for (AttributeDescriptor ad : srcAttrDesc) {
                attrDescs.add(ad);
            }
            Collections.sort(attrDescs, new /* Unavailable Anonymous Inner Class!! */);
            String[] outputColumns = null;
            int i = 0;
            if (attrDescs != null && attrDescs.size() > 0) {
                outputColumns = new String[attrDescs.size()];
            }
            JSONObject colNames = new JSONObject();
            for (AttributeDescriptor desc : attrDescs) {
                String col = desc.getLocalName();
                String type = desc.getType().getBinding().getSimpleName();
                colNames.put((Object)col, (Object)type);
                outputColumns[i] = "outputmapping." + col;
                ++i;
            }
            if (outputColumns != null) {
                ActionsAction.setOutputColumns((String[])outputColumns);
            }
            JSONResolution jSONResolution = new JSONResolution((Object)colNames);
            return jSONResolution;
        }
        catch (Exception e) {
            log.error((Throwable)e, new Object[0]);
            String message = e.getMessage() + "<p>" + new LocalizableMessage("attributeReadErrorAdvice", new Object[0]).getMessage(this.getContext().getLocale()) + "</p>";
            JSONErrorResolution jSONErrorResolution = new JSONErrorResolution(message, new LocalizableMessage("attributeReadError", new Object[0]), this.getContext());
            return jSONErrorResolution;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution getExampleRecord() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Inout input = (Inout)session.get(Inout.class, (Serializable)this.selectedOutputId);
        DataStore ds = null;
        try {
            String tableName = null;
            if (input.getDatabase() != null) {
                ds = DataStoreLinker.openDataStore((Database)input.getDatabase());
                tableName = input.getTableName();
            } else if (input.getFile() != null) {
                ds = DataStoreLinker.openDataStore((String)input.getFile());
            } else {
                throw new Exception("unsupported input type.");
            }
            SimpleFeatureSource source = ds.getFeatureSource(tableName);
            List kolommen = ((SimpleFeatureType)source.getSchema()).getAttributeDescriptors();
            this.outputColumnNames = new ArrayList();
            for (AttributeDescriptor desc : kolommen) {
                String col = desc.getLocalName();
                String type = desc.getType().getBinding().getSimpleName();
                this.outputColumnNames.add(col + "(" + type + ")");
            }
            this.outputRecordValues = new ArrayList();
        }
        catch (Exception e) {
            log.error((Throwable)e, new Object[0]);
            DefaultErrorResolution defaultErrorResolution = new DefaultErrorResolution(e.getMessage());
            return defaultErrorResolution;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return new ForwardResolution(EXAMPLE_RECORD_JSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeature getExampleFeature(DataStore ds, String tableName) throws Exception {
        if (tableName == null) {
            if (ds.getTypeNames().length == 0) {
                throw new IllegalArgumentException("no typeNames");
            }
            tableName = ds.getTypeNames()[0];
        }
        DefaultFeatureCollection fc = (DefaultFeatureCollection)ds.getFeatureSource(tableName).getFeatures();
        FeatureIterator iterator = (FeatureIterator)fc.iterator();
        try {
            if (iterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
                return simpleFeature;
            }
        }
        finally {
            fc.close(iterator);
        }
        throw new Exception("Geen features gevonden.");
    }

    public List<Inout> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<Inout> inputs) {
        this.inputs = inputs;
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<Database> databases) {
        this.databases = databases;
    }

    public Long getSelectedDatabaseId() {
        return this.selectedDatabaseId;
    }

    public void setSelectedDatabaseId(Long selectedDatabaseId) {
        this.selectedDatabaseId = selectedDatabaseId;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public Long getSelectedOutputId() {
        return this.selectedOutputId;
    }

    public void setSelectedOutputId(Long selectedOutputId) {
        this.selectedOutputId = selectedOutputId;
    }

    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public String getSelectedTable() {
        return this.selectedTable;
    }

    public void setSelectedTable(String selectedTable) {
        this.selectedTable = selectedTable;
    }

    public List<String> getFailedTables() {
        return this.failedTables;
    }

    public void setFailedTables(List<String> failedTables) {
        this.failedTables = failedTables;
    }

    public String getUploadDirectory() {
        return this.getContext().getServletContext().getInitParameter("uploadDirectory");
    }

    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public List<Object> getOutputRecordValues() {
        return this.outputRecordValues;
    }

    public void setOutputRecordValues(List<Object> outputRecordValues) {
        this.outputRecordValues = outputRecordValues;
    }

    public String getSelectedTemplateOutput() {
        return this.selectedTemplateOutput;
    }

    public void setSelectedTemplateOutput(String selectedTemplateOutput) {
        this.selectedTemplateOutput = selectedTemplateOutput;
    }
}

