/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.entity.Schedule;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.gui.stripes.ProcessAction;
import nl.b3p.datastorelinker.util.DataStoreLinkJob;
import nl.b3p.datastorelinker.util.DefaultErrorResolution;
import nl.b3p.datastorelinker.util.SchedulerUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Transactional
public class PeriodicalProcessAction
extends DefaultAction {
    private static final Log log = Log.getInstance(PeriodicalProcessAction.class);
    protected static final String EXECUTE_PERIODICALLY_JSP = "/WEB-INF/jsp/main/cron/executePeriodically.jsp";
    protected static final String LIST_JSP = "/WEB-INF/jsp/main/process/list.jsp";
    protected static final int SECONDS = 0;
    protected static final int MINUTES = 1;
    protected static final int HOURS = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int PARSE_HOURS = 0;
    protected static final int PARSE_MINUTES = 1;
    protected Long selectedProcessId;
    protected Schedule.Type cronType;
    protected Date fromDate;
    protected Integer onMinute;
    protected String onTime;
    protected Integer onDayOfTheWeek;
    protected Integer onDayOfTheMonth;
    protected Integer onMonth;
    protected String cronExpression;

    public Resolution executePeriodically() {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        Schedule schedule = process.getSchedule();
        if (schedule != null) {
            this.cronType = schedule.getScheduleType();
            this.cronExpression = schedule.getCronExpression();
            this.fromDate = schedule.getFromDate();
            if (this.cronType != Schedule.Type.ADVANCED) {
                this.decodeCronExpression(this.cronExpression);
            }
        }
        return new ForwardResolution(EXECUTE_PERIODICALLY_JSP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resolution executePeriodicallyComplete() {
        log.debug(new Object[]{"Periodically executing process with id: " + this.selectedProcessId});
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)this.selectedProcessId);
        if (process.getSchedule() != null) {
            this.cancelExecutePeriodically();
        }
        Schedule schedule = new Schedule();
        schedule.setFromDate(this.fromDate);
        schedule.setScheduleType(this.cronType);
        try {
            String uuid = UUID.randomUUID().toString();
            String jobName = "job" + uuid;
            JobDetail jobDetail = JobBuilder.newJob(DataStoreLinkJob.class).withIdentity(jobName).build();
            jobDetail.getJobDataMap().put("processId", (Object)process.getId());
            jobDetail.getJobDataMap().put("locale", (Object)this.getContext().getLocale());
            jobDetail.getJobDataMap().put("defaultSmtpHost", this.getContext().getServletContext().getInitParameter("defaultSmtpHost"));
            jobDetail.getJobDataMap().put("defaultFromEmailAddress", this.getContext().getServletContext().getInitParameter("defaultFromEmailAddress"));
            String triggerName = "trig" + uuid;
            String cronExpressionString = null;
            if (this.cronType == Schedule.Type.ADVANCED) {
                if (this.cronExpression == null) throw new Exception("Expected advanced cron expression; not found.");
                cronExpressionString = this.cronExpression;
            } else {
                cronExpressionString = this.createCronExpression();
            }
            log.debug(new Object[]{"fromDate:" + this.fromDate});
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName).forJob(jobDetail).startAt(this.fromDate == null ? new Date() : this.fromDate).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpressionString)).build();
            Scheduler scheduler = SchedulerUtils.getScheduler((ServletContext)this.getContext().getServletContext());
            scheduler.scheduleJob(jobDetail, trigger);
            schedule.setCronExpression(cronExpressionString);
            schedule.setJobName(jobName);
            if (process.getSchedule() == null) {
                session.save((Object)schedule);
            }
            process.setSchedule(schedule);
            return new ForwardResolution(ProcessAction.class, "list");
        }
        catch (ParseException pe) {
            return new DefaultErrorResolution("Verkeerde of niet ondersteunde Cron expressie: " + pe.getLocalizedMessage() + "\n\nBekijk de Cron expressie handleiding voor uitleg over Cron expressies.");
        }
        catch (Exception e) {
            log.error((Throwable)e, new Object[0]);
            return new DefaultErrorResolution(e.getLocalizedMessage());
        }
    }

    public Resolution cancelExecutePeriodically() {
        this.cancelExecutePeriodicallyImpl(this.selectedProcessId, this.getContext().getServletContext());
        return new ForwardResolution(ProcessAction.class, "list");
    }

    public void cancelExecutePeriodicallyImpl(Long processId, ServletContext servletContext) {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)processId);
        Schedule schedule = process.getSchedule();
        if (schedule != null) {
            try {
                Scheduler scheduler = SchedulerUtils.getScheduler((ServletContext)servletContext);
                scheduler.deleteJob(new JobKey(schedule.getJobName()));
                session.delete((Object)process.getSchedule());
                process.setSchedule(null);
            }
            catch (SchedulerException ex) {
                log.error((Throwable)ex, new Object[0]);
            }
        }
    }

    protected void decodeCronExpression(String cronExpressionToDecode) {
        String[] cronArray = cronExpressionToDecode.split(" ");
        try {
            if (this.cronType == Schedule.Type.YEAR) {
                this.onMonth = Integer.valueOf(cronArray[4]);
            }
            if (this.cronType == Schedule.Type.YEAR || this.cronType == Schedule.Type.MONTH) {
                try {
                    this.onDayOfTheMonth = Integer.valueOf(cronArray[3]);
                }
                catch (NumberFormatException nfe) {
                    this.onDayOfTheMonth = null;
                }
            }
            if (this.cronType == Schedule.Type.WEEK) {
                this.onDayOfTheWeek = Integer.valueOf(cronArray[5]);
            }
            Integer minutes = Integer.valueOf(cronArray[1]);
            if (this.cronType == Schedule.Type.HOUR) {
                this.onMinute = minutes;
            } else {
                Integer hours = Integer.valueOf(cronArray[2]);
                String minutesStr = minutes < 10 ? "0" + minutes : minutes.toString();
                String hoursStr = hours < 10 ? "0" + hours : hours.toString();
                this.onTime = hoursStr + ":" + minutesStr;
            }
        }
        catch (NumberFormatException nfe) {
            log.error(new Object[]{"Error decoding cron expression from dsl DB.", nfe});
        }
    }

    protected String createCronExpression() {
        int[] parsedTime;
        Object[] cronArgs = new Object[]{"0", "*", "*", "*", "*", "?", "*"};
        if (this.onMinute != null) {
            cronArgs[1] = this.onMinute;
        }
        if ((parsedTime = this.parseTime()) != null) {
            cronArgs[1] = parsedTime[1];
            cronArgs[2] = parsedTime[0];
        }
        if (this.onDayOfTheMonth != null) {
            cronArgs[5] = "?";
            cronArgs[3] = this.onDayOfTheMonth;
        } else if (this.cronType == Schedule.Type.MONTH || this.cronType == Schedule.Type.YEAR) {
            cronArgs[5] = "?";
            cronArgs[3] = "L";
        }
        if (this.onMonth != null) {
            cronArgs[4] = this.onMonth;
        }
        if (this.onDayOfTheWeek != null) {
            cronArgs[5] = this.onDayOfTheWeek;
            cronArgs[3] = "?";
        }
        String cronExpressionString = StringUtils.join((Object[])cronArgs, (String)" ");
        log.debug(new Object[]{"cronExpression: " + cronExpressionString});
        return cronExpressionString;
    }

    protected int[] parseTime() {
        if (this.onTime == null || this.onTime.length() != 5) {
            return null;
        }
        int[] parsedTime = new int[2];
        String[] splitTime = this.onTime.split(":");
        try {
            parsedTime[0] = Integer.parseInt(splitTime[0]);
            parsedTime[1] = Integer.parseInt(splitTime[1]);
        }
        catch (NumberFormatException nfe) {
            log.error(new Object[]{"Ongeldige tijd geprobeerd te parsen. Tijd: " + this.onTime != null ? this.onTime : "null", nfe});
            return null;
        }
        return parsedTime;
    }

    public Resolution executePeriodicallyCompleteAdvanced() {
        return new ForwardResolution(EXECUTE_PERIODICALLY_JSP);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Integer getOnDayOfTheMonth() {
        return this.onDayOfTheMonth;
    }

    public void setOnDayOfTheMonth(Integer onDayOfTheMonth) {
        this.onDayOfTheMonth = onDayOfTheMonth;
    }

    public Integer getOnDayOfTheWeek() {
        return this.onDayOfTheWeek;
    }

    public void setOnDayOfTheWeek(Integer onDayOfTheWeek) {
        this.onDayOfTheWeek = onDayOfTheWeek;
    }

    public Integer getOnMinute() {
        return this.onMinute;
    }

    public void setOnMinute(Integer onMinute) {
        this.onMinute = onMinute;
    }

    public Integer getOnMonth() {
        return this.onMonth;
    }

    public void setOnMonth(Integer onMonth) {
        this.onMonth = onMonth;
    }

    public String getOnTime() {
        return this.onTime;
    }

    public void setOnTime(String onTime) {
        this.onTime = onTime;
    }

    public Long getSelectedProcessId() {
        return this.selectedProcessId;
    }

    public void setSelectedProcessId(Long selectedProcessId) {
        this.selectedProcessId = selectedProcessId;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Schedule.Type getCronType() {
        return this.cronType;
    }

    public void setCronType(Schedule.Type cronType) {
        this.cronType = cronType;
    }
}

