/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipUtil {
    private final Log log = LogFactory.getLog(this.getClass());
    protected static final String ZIP_EXT = ".zip";

    public void extractZip(File tempFile, File zipDir) throws IOException {
        if (!tempFile.exists()) {
            return;
        }
        if (!zipDir.exists()) {
            zipDir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        ZipInputStream zipinputstream = null;
        ZipEntry zipentry = null;
        try {
            zipinputstream = new ZipInputStream(new FileInputStream(tempFile));
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                this.log.debug((Object)("extractZip zipentry name: " + zipentry.getName()));
                File newFile = new File(zipDir, zipentry.getName());
                if (zipentry.isDirectory()) {
                    newFile.mkdirs();
                } else if (this.isZipFile(zipentry.getName())) {
                    int lastIndexOfFileSeparator = zipentry.getName().lastIndexOf("/");
                    String zipName = null;
                    zipName = lastIndexOfFileSeparator < 0 ? zipentry.getName().substring(0) : zipentry.getName().substring(lastIndexOfFileSeparator + 1);
                    File tempZipFile = File.createTempFile(zipName + ".", null);
                    File newZipDir = new File(zipDir, this.getZipName(zipentry.getName()));
                    this.copyZipEntryTo(zipinputstream, tempZipFile, buffer);
                    this.extractZip(tempZipFile, newZipDir);
                } else {
                    this.copyZipEntryTo(zipinputstream, newFile, buffer);
                }
                zipinputstream.closeEntry();
            }
        }
        catch (IOException ioex) {
            if (zipentry == null) {
                throw ioex;
            }
            throw new IOException(ioex.getMessage() + "\nProcessing zip entry: " + zipentry.getName());
        }
        finally {
            if (zipinputstream != null) {
                zipinputstream.close();
            }
            boolean bl = tempFile.delete();
        }
    }

    private boolean isZipFile(String fileName) {
        return fileName.toLowerCase().endsWith(ZIP_EXT);
    }

    private String getZipName(String zipFileName) {
        return zipFileName.substring(0, zipFileName.length() - ZIP_EXT.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyZipEntryTo(ZipInputStream zipinputstream, File newFile, byte[] buffer) throws IOException {
        try (FileOutputStream fileoutputstream = null;){
            int n;
            fileoutputstream = new FileOutputStream(newFile);
            while ((n = zipinputstream.read(buffer)) > -1) {
                fileoutputstream.write(buffer, 0, n);
            }
        }
    }
}

