/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.entity.ProcessStatus;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.postgresql.PGConnection;
import org.postgresql.jdbc.PgDatabaseMetaData;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class ConvertLargeObjectsAction
implements ActionBean {
    private ActionBeanContext context;
    private LargeObjectManager lom;
    private JSONArray statusArray = new JSONArray();
    private static final Log log = Log.getInstance(ConvertLargeObjectsAction.class);

    public void setContext(ActionBeanContext abc) {
        this.context = abc;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public Resolution convertDatabase() throws JSONException {
        try {
            this.convertLOBS();
        }
        catch (SQLException ex) {
            log.error((Throwable)ex, new Object[0]);
        }
        catch (NoSuchFieldException ex) {
            log.error((Throwable)ex, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            log.error((Throwable)ex, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            log.error((Throwable)ex, new Object[0]);
        }
        catch (IOException ex) {
            log.error((Throwable)ex, new Object[0]);
        }
        return new StreamingResolution("application/json", (Reader)new StringReader(this.statusArray.toString(4)));
    }

    public void convertLOBS() throws SQLException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, IOException {
        this.statusArray.put((Object)"Opening connection..");
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Connection conn = session.connection();
        conn.setAutoCommit(false);
        DatabaseMetaData metadata = conn.getMetaData();
        this.statusArray.put((Object)"Digging deep to retrieve implementation");
        Field f = metadata.getClass().getDeclaredField("inner");
        f.setAccessible(true);
        Object pgconnMetadata = f.get(metadata);
        this.statusArray.put((Object)"Retrieving postgres connection..");
        PGConnection connection = (PGConnection)((PgDatabaseMetaData)pgconnMetadata).getConnection();
        this.statusArray.put((Object)"Connection established");
        this.lom = connection.getLargeObjectAPI();
        this.statusArray.put((Object)"Create LargeObjectManager");
        em.getTransaction().begin();
        this.statusArray.put((Object)"Begin converting LOBs");
        this.processProcesses(em);
        this.processProcessesStatusses(em);
        this.statusArray.put((Object)"Converting finished");
        em.getTransaction().commit();
        this.statusArray.put((Object)"Changes saved");
    }

    private void processProcesses(EntityManager em) throws SQLException, IOException {
        this.statusArray.put((Object)"Convert actions");
        List processes = em.createQuery("from Process p").getResultList();
        for (Process process : processes) {
            this.updateProcess(process);
        }
    }

    private void processProcessesStatusses(EntityManager em) throws SQLException, IOException {
        this.statusArray.put((Object)"Convert statusses");
        List processStatussen = em.createQuery("from ProcessStatus s").getResultList();
        for (ProcessStatus status : processStatussen) {
            this.updateStatus(status);
        }
    }

    private void updateProcess(Process process) throws SQLException, IOException {
        try {
            this.statusArray.put((Object)("    Convert process: " + process.getName()));
            String oidString = process.getActionsString();
            Long oid = Long.parseLong(oidString);
            LargeObject lob = this.lom.open(oid.longValue());
            String lobText = this.getTextFromLOB(lob);
            process.setActionsString(lobText);
            this.statusArray.put((Object)"        -> LOB converted");
        }
        catch (NumberFormatException ex) {
            this.statusArray.put((Object)"        -> No LOB to convert");
        }
    }

    private void updateStatus(ProcessStatus status) throws SQLException, IOException {
        try {
            this.statusArray.put((Object)"    Convert status");
            String oidString = status.getMessage();
            Long oid = Long.parseLong(oidString);
            LargeObject lob = this.lom.open(oid.longValue());
            String lobText = this.getTextFromLOB(lob);
            status.setMessage(lobText);
            this.statusArray.put((Object)"        -> LOB converted");
        }
        catch (NumberFormatException ex) {
            this.statusArray.put((Object)"        -> No LOB to convert");
        }
    }

    private String getTextFromLOB(LargeObject lob) throws SQLException, IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)lob.getInputStream(), (Writer)writer, (String)"UTF-8");
        String theString = writer.toString();
        return theString;
    }
}

