/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.gui.stripes;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.EntityManager;
import javax.servlet.ServletRequest;
import net.sf.json.JSONArray;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.LocalizableMessage;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.util.Log;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.commons.stripes.Transactional;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.entity.Organization;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.gui.stripes.DefaultAction;
import nl.b3p.datastorelinker.gui.stripes.FileAction;
import nl.b3p.datastorelinker.json.ArraySuccessMessage;
import nl.b3p.datastorelinker.json.JSONResolution;
import nl.b3p.datastorelinker.json.ProgressMessage;
import nl.b3p.datastorelinker.json.UploaderStatus;
import nl.b3p.datastorelinker.uploadprogress.UploadProgressListener;
import nl.b3p.datastorelinker.util.DefaultErrorResolution;
import nl.b3p.datastorelinker.util.Dir;
import nl.b3p.datastorelinker.util.DirContent;
import nl.b3p.datastorelinker.util.File;
import org.hibernate.Session;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
public class FileAction
extends DefaultAction {
    private static final Log log = Log.getInstance(FileAction.class);
    protected static final String SHAPE_EXT = ".shp";
    protected static final String ZIP_EXT = ".zip";
    protected static final String PRETTY_DIR_SEPARATOR = "/";
    protected static final String[] ALLOWED_CONTENT_TYPES = new String[]{""};
    private static final String CREATE_JSP = "/WEB-INF/jsp/main/file/create.jsp";
    private static final String LIST_JSP = "/WEB-INF/jsp/main/file/list.jsp";
    private static final String WRAPPER_JSP = "/WEB-INF/jsp/main/file/filetreeWrapper.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/management/fileAdmin.jsp";
    private static final String DIRCONTENTS_JSP = "/WEB-INF/jsp/main/file/filetreeConnector.jsp";
    private DirContent dirContent;
    private FileBean filedata;
    private UploaderStatus uploaderStatus;
    private String dir;
    private String expandTo;
    private String selectedFilePath;
    private String selectedFilePaths;
    private boolean adminPage = false;

    public Resolution listDir() {
        log.debug(new Object[]{"Directory requested: " + this.dir});
        log.debug(new Object[]{"expandTo: " + this.expandTo});
        Boolean expandDir = Boolean.valueOf(this.getContext().getServletContext().getInitParameter("expandAllDirsDirectly"));
        java.io.File directory = null;
        if (this.dir != null) {
            if (this.dir.contains("..")) {
                log.error(new Object[]{"Possible hack attempt; Dir requested: " + this.dir});
                return null;
            }
            directory = this.getFileFromPPFileName(this.dir);
        } else {
            directory = this.getOrganizationUploadDir();
        }
        if (expandDir.booleanValue()) {
            this.dirContent = this.getDirContent(directory, null, expandDir);
        } else if (this.expandTo == null) {
            this.dirContent = this.getDirContent(directory, null, expandDir);
        } else {
            this.selectedFilePath = this.expandTo.trim().replace("\n", "").replace("\r", "");
            log.debug(new Object[]{"selectedFilePath/expandTo: " + this.selectedFilePath});
            LinkedList<String> subDirList = new LinkedList<String>();
            java.io.File currentDirFile = this.getFileFromPPFileName(this.selectedFilePath);
            while (!currentDirFile.getAbsolutePath().equals(directory.getAbsolutePath())) {
                subDirList.add(0, currentDirFile.getName());
                currentDirFile = currentDirFile.getParentFile();
            }
            this.dirContent = this.getDirContent(directory, subDirList, expandDir);
        }
        return new ForwardResolution("/WEB-INF/jsp/main/file/filetreeConnector.jsp");
    }

    protected DirContent getDirContent(java.io.File directory, List<String> subDirList, Boolean expandDirs) {
        DirContent dc;
        block6: {
            block7: {
                dc = new DirContent();
                java.io.File[] dirs = directory.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
                java.io.File[] files = directory.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
                ArrayList<Dir> dirsList = new ArrayList<Dir>();
                if (dirs != null) {
                    for (java.io.File dir : dirs) {
                        Dir newDir = new Dir();
                        newDir.setName(dir.getName());
                        newDir.setPath(this.getFileNameRelativeToUploadDirPP(dir));
                        dirsList.add(newDir);
                    }
                }
                ArrayList<File> filesList = new ArrayList<File>();
                if (files != null) {
                    for (java.io.File file : files) {
                        File newFile = new File();
                        newFile.setName(file.getName());
                        newFile.setPath(this.getFileNameRelativeToUploadDirPP(file));
                        filesList.add(newFile);
                    }
                }
                Collections.sort(dirsList, new DirExtensionComparator(this, null));
                Collections.sort(filesList, new FileExtensionComparator(this, null));
                dc.setDirs(dirsList);
                dc.setFiles(filesList);
                this.filterOutFilesToHide(dc);
                if (!expandDirs.booleanValue()) break block7;
                for (Dir subDir : dc.getDirs()) {
                    java.io.File followSubDir = this.getFileFromPPFileName(subDir.getPath());
                    subDir.setContent(this.getDirContent(followSubDir, null, expandDirs));
                }
                break block6;
            }
            if (subDirList == null || subDirList.size() <= 0) break block6;
            String subDirString = subDirList.remove(0);
            for (Dir subDir : dc.getDirs()) {
                if (!subDir.getName().equals(subDirString)) continue;
                java.io.File followSubDir = this.getFileFromPPFileName(subDir.getPath());
                subDir.setContent(this.getDirContent(followSubDir, subDirList, expandDirs));
                break;
            }
        }
        return dc;
    }

    protected void filterOutFilesToHide(DirContent dc) {
        this.filterOutShapeExtraFiles(dc);
    }

    protected void filterOutShapeExtraFiles(DirContent dc) {
        ArrayList<String> shapeNames = new ArrayList<String>();
        for (File file : dc.getFiles()) {
            if (!file.getName().endsWith(".shp")) continue;
            shapeNames.add(file.getName().substring(0, file.getName().length() - ".shp".length()));
        }
        for (String shapeName : shapeNames) {
            ArrayList<File> toBeIgnoredFiles = new ArrayList<File>();
            for (File file : dc.getFiles()) {
                if (!file.getName().startsWith(shapeName) || file.getName().endsWith(".shp")) continue;
                toBeIgnoredFiles.add(file);
            }
            for (File file : toBeIgnoredFiles) {
                dc.getFiles().remove(file);
            }
        }
    }

    public Resolution admin() {
        this.list();
        return new ForwardResolution("/WEB-INF/jsp/management/fileAdmin.jsp");
    }

    public Resolution list() {
        return new ForwardResolution("/WEB-INF/jsp/main/file/list.jsp");
    }

    public Resolution deleteCheck() {
        log.debug(new Object[]{this.selectedFilePaths});
        ArrayList messages = new ArrayList();
        try {
            JSONArray selectedFilePathsJSON = JSONArray.fromObject((Object)this.selectedFilePaths);
            for (Object filePathObj : selectedFilePathsJSON) {
                String pathToDelete = (String)filePathObj;
                String relativePathToDelete = pathToDelete.replace("/", java.io.File.separator);
                java.io.File fileToDelete = new java.io.File(this.getUploadDirectoryIOFile(), relativePathToDelete);
                List deleteMessages = this.deleteCheckImpl(fileToDelete);
                messages.addAll(deleteMessages);
            }
        }
        catch (IOException ioex) {
            log.error((Throwable)ioex, new Object[0]);
        }
        if (messages.isEmpty()) {
            return new JSONResolution((Object)new ArraySuccessMessage(true));
        }
        JSONArray jsonArray = new JSONArray();
        for (LocalizableMessage m : messages) {
            jsonArray.element(m.getMessage(this.getContext().getLocale()));
        }
        return new JSONResolution((Object)new ArraySuccessMessage(false, jsonArray));
    }

    private List<LocalizableMessage> deleteCheckImpl(java.io.File fileToDelete) throws IOException {
        ArrayList<LocalizableMessage> messages;
        block6: {
            block5: {
                messages = new ArrayList<LocalizableMessage>();
                if (!fileToDelete.isDirectory()) break block5;
                for (java.io.File fileInDir : fileToDelete.listFiles()) {
                    messages.addAll(this.deleteCheckImpl(fileInDir));
                }
                break block6;
            }
            String ppFileName = this.getFileNameRelativeToUploadDirPP(fileToDelete);
            List inouts = this.getDependingInouts(fileToDelete);
            if (inouts == null || inouts.isEmpty()) break block6;
            for (Inout inout : inouts) {
                if (inout.getType() == Inout.Type.INPUT) {
                    messages.add(new LocalizableMessage("file.inuseInput", new Object[]{ppFileName, inout.getName()}));
                    if (inout.getInputProcessList() == null) continue;
                    for (Process process : inout.getInputProcessList()) {
                        messages.add(new LocalizableMessage("input.inuse", new Object[]{inout.getName(), process.getName()}));
                    }
                    continue;
                }
                messages.add(new LocalizableMessage("file.inuseOutput", new Object[]{ppFileName, inout.getName()}));
                if (inout.getOutputProcessList() == null) continue;
                for (Process process : inout.getOutputProcessList()) {
                    messages.add(new LocalizableMessage("output.inuse", new Object[]{inout.getName(), process.getName()}));
                }
            }
        }
        return messages;
    }

    private List<Inout> getDependingInouts(java.io.File file) throws IOException {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        List inouts = session.createQuery("from Inout where file = :file").setParameter("file", (Object)file.getAbsolutePath()).list();
        return inouts;
    }

    private java.io.File getFileFromPPFileName(String fileName) {
        return FileAction.getFileFromPPFileName((String)fileName, (ActionBeanContext)this.getContext());
    }

    private String getFileNameFromPPFileName(String fileName) {
        java.io.File file = this.getFileFromPPFileName(fileName);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static java.io.File getFileFromPPFileName(String fileName, ActionBeanContext context) {
        String subPath = fileName.replace("/", java.io.File.separator);
        return new java.io.File(FileAction.getUploadDirectoryIOFile((ActionBeanContext)context), subPath);
    }

    public static String getFileNameFromPPFileName(String fileName, ActionBeanContext context) {
        java.io.File file = FileAction.getFileFromPPFileName((String)fileName, (ActionBeanContext)context);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static String getFileNameRelativeToUploadDirPP(String file, ActionBeanContext context) {
        return FileAction.getFileNameRelativeToUploadDirPP((java.io.File)new java.io.File(file), (ActionBeanContext)context);
    }

    private String getFileNameRelativeToUploadDirPP(java.io.File file) {
        return FileAction.getFileNameRelativeToUploadDirPP((java.io.File)file, (ActionBeanContext)this.getContext());
    }

    private static String getFileNameRelativeToUploadDirPP(java.io.File file, ActionBeanContext context) {
        String name = FileAction.getFileNameRelativeToUploadDir((java.io.File)file, (ActionBeanContext)context);
        if (name == null) {
            return null;
        }
        return name.replace(java.io.File.separator, "/");
    }

    private String getFileNameRelativeToUploadDir(java.io.File file) {
        return FileAction.getFileNameRelativeToUploadDir((java.io.File)file, (ActionBeanContext)this.getContext());
    }

    private static String getFileNameRelativeToUploadDir(java.io.File file, ActionBeanContext context) {
        String absName = file.getAbsolutePath();
        String uploadDir = FileAction.getUploadDirectory((ActionBeanContext)context);
        if (uploadDir == null || !absName.startsWith(uploadDir)) {
            return null;
        }
        return absName.substring(FileAction.getUploadDirectory((ActionBeanContext)context).length());
    }

    public Resolution delete() {
        log.debug(new Object[]{this.selectedFilePaths});
        JSONArray selectedFilePathsJSON = JSONArray.fromObject((Object)this.selectedFilePaths);
        for (Object filePathObj : selectedFilePathsJSON) {
            String filePath = (String)filePathObj;
            this.deleteImpl(this.getFileFromPPFileName(filePath));
        }
        return this.list();
    }

    protected void deleteImpl(java.io.File file) {
        if (file != null) {
            boolean deleteSuccess;
            EntityManager em = JpaUtilServlet.getThreadEntityManager();
            Session session = (Session)em.getDelegate();
            if (!file.isDirectory() && file.exists() && !(deleteSuccess = file.delete())) {
                log.error(new Object[]{"Failed to delete file: " + file.getAbsolutePath()});
            }
            try {
                List inouts = this.getDependingInouts(file);
                for (Inout inout : inouts) {
                    session.delete((Object)inout);
                }
            }
            catch (IOException ioex) {
                log.error((Throwable)ioex, new Object[0]);
            }
            this.deleteExtraShapeFilesInSameDir(file);
            this.deleteDirIfDir(file);
        }
    }

    private void deleteExtraShapeFilesInSameDir(java.io.File file) {
        if (!file.isDirectory() && file.getName().endsWith(".shp")) {
            String fileBaseName = file.getName().substring(0, file.getName().length() - ".shp".length());
            java.io.File currentDir = file.getParentFile();
            log.debug(new Object[]{"currentDir == " + currentDir});
            if (currentDir != null && currentDir.exists()) {
                java.io.File[] extraShapeFilesInDir;
                for (java.io.File extraShapeFile : extraShapeFilesInDir = currentDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                    if (extraShapeFile.isDirectory()) continue;
                    this.deleteImpl(extraShapeFile);
                }
            }
        }
    }

    protected void deleteDirIfDir(java.io.File dir) {
        if (dir != null && dir.isDirectory() && dir.exists()) {
            for (java.io.File fileInDir : dir.listFiles()) {
                this.deleteImpl(fileInDir);
            }
            boolean deleteDirSuccess = dir.delete();
            if (!deleteDirSuccess) {
                log.error(new Object[]{"Failed to delete dir: " + dir.getAbsolutePath() + "; This could happen if the dir was not empty at the time of deletion. This should not happen."});
            }
        }
    }

    @DontValidate
    public Resolution create() {
        return new ForwardResolution("/WEB-INF/jsp/main/file/create.jsp");
    }

    public Resolution createComplete() {
        return new ForwardResolution("/WEB-INF/jsp/main/file/filetreeWrapper.jsp");
    }

    @Before(stages={LifecycleStage.BindingAndValidation})
    private void rehydrate() {
        StripesRequestWrapper req = StripesRequestWrapper.findStripesWrapper((ServletRequest)this.getContext().getRequest());
        try {
            if (req.isMultipart()) {
                this.filedata = req.getFileParameterValue("uploader");
            }
        }
        catch (Exception e) {
            log.error(new Object[]{e.getMessage(), e});
        }
    }

    @DefaultHandler
    public Resolution upload() {
        if (this.filedata != null) {
            log.debug(new Object[]{"Filedata: " + this.filedata.getFileName()});
            try {
                java.io.File dirFile = this.getOrganizationUploadDir();
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                if (this.isZipFile(this.filedata.getFileName())) {
                    java.io.File tempFile = java.io.File.createTempFile(this.filedata.getFileName(), null);
                    tempFile.delete();
                    this.filedata.save(tempFile);
                    java.io.File zipDir = new java.io.File(this.getOrganizationUploadString(), this.getZipName(this.filedata.getFileName()));
                    this.extractZip(tempFile, zipDir);
                } else {
                    java.io.File destinationFile = new java.io.File(dirFile, this.filedata.getFileName());
                    this.filedata.save(destinationFile);
                    log.info(new Object[]{"Saved file " + destinationFile.getAbsolutePath() + ", Successfully!"});
                    this.selectedFilePath = this.getFileNameRelativeToUploadDirPP(destinationFile);
                    log.debug(new Object[]{"selectedFilePath: " + this.selectedFilePath});
                }
            }
            catch (IOException e) {
                String errorMsg = e.getMessage();
                log.error(new Object[]{"Error while writing file: " + this.filedata.getFileName() + " :: " + errorMsg});
                return new DefaultErrorResolution(errorMsg);
            }
            return this.createComplete();
        }
        return new DefaultErrorResolution("An unknown error has occurred!");
    }

    public Resolution uploadProgress() {
        UploadProgressListener listener = (UploadProgressListener)this.getContext().getRequest().getSession().getAttribute(UploadProgressListener.class.toString());
        int progress = listener != null ? (int)(listener.getProgress() * 100.0) : 100;
        return new JSONResolution((Object)new ProgressMessage(progress));
    }

    private void extractZip(java.io.File tempFile, java.io.File zipDir) throws IOException {
        if (!tempFile.exists()) {
            return;
        }
        if (!zipDir.exists()) {
            zipDir.mkdirs();
        }
        byte[] buffer = new byte[1024];
        ZipInputStream zipinputstream = null;
        ZipEntry zipentry = null;
        try {
            zipinputstream = new ZipInputStream(new FileInputStream(tempFile));
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                log.debug(new Object[]{"extractZip zipentry name: " + zipentry.getName()});
                java.io.File newFile = new java.io.File(zipDir, zipentry.getName());
                if (zipentry.isDirectory()) {
                    newFile.mkdirs();
                } else if (this.isZipFile(zipentry.getName())) {
                    int lastIndexOfFileSeparator = zipentry.getName().lastIndexOf("/");
                    String zipName = null;
                    zipName = lastIndexOfFileSeparator < 0 ? zipentry.getName().substring(0) : zipentry.getName().substring(lastIndexOfFileSeparator + 1);
                    java.io.File tempZipFile = java.io.File.createTempFile(zipName + ".", null);
                    java.io.File newZipDir = new java.io.File(zipDir, this.getZipName(zipentry.getName()));
                    this.copyZipEntryTo(zipinputstream, tempZipFile, buffer);
                    this.extractZip(tempZipFile, newZipDir);
                } else {
                    this.copyZipEntryTo(zipinputstream, newFile, buffer);
                }
                zipinputstream.closeEntry();
            }
        }
        catch (IOException ioex) {
            if (zipentry == null) {
                throw ioex;
            }
            throw new IOException(ioex.getMessage() + "\nProcessing zip entry: " + zipentry.getName());
        }
        finally {
            if (zipinputstream != null) {
                zipinputstream.close();
            }
            boolean bl = tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyZipEntryTo(ZipInputStream zipinputstream, java.io.File newFile, byte[] buffer) throws IOException {
        try (FileOutputStream fileoutputstream = null;){
            int n;
            fileoutputstream = new FileOutputStream(newFile);
            while ((n = zipinputstream.read(buffer)) > -1) {
                fileoutputstream.write(buffer, 0, n);
            }
        }
    }

    public Resolution check() {
        if (this.uploaderStatus != null) {
            java.io.File dirFile = this.getOrganizationUploadDir();
            if (!dirFile.exists()) {
                dirFile.mkdir();
            }
            java.io.File tempFile = new java.io.File(dirFile, this.uploaderStatus.getFname());
            log.debug(new Object[]{tempFile.getAbsolutePath()});
            log.debug(new Object[]{tempFile.getPath()});
            log.debug(new Object[]{"check fpath: "});
            if (this.uploaderStatus.getFpath() != null) {
                log.debug(new Object[]{this.uploaderStatus.getFpath()});
            }
            HashMap<String, UploaderStatus> resultMap = new HashMap<String, UploaderStatus>();
            if (tempFile.exists()) {
                this.uploaderStatus.setErrtype("exists");
            }
            if (this.isZipFile(tempFile) && this.zipFileToDirFile(tempFile, new java.io.File(this.getOrganizationUploadString())).exists()) {
                this.uploaderStatus.setErrtype("exists");
            } else {
                this.uploaderStatus.setErrtype("none");
            }
            resultMap.put("0", this.uploaderStatus);
            return new JSONResolution(resultMap);
        }
        return new JSONResolution((Object)false);
    }

    private boolean isZipFile(String fileName) {
        return fileName.toLowerCase().endsWith(".zip");
    }

    private boolean isZipFile(java.io.File file) {
        return this.isZipFile(file.getName());
    }

    private String getZipName(String zipFileName) {
        return zipFileName.substring(0, zipFileName.length() - ".zip".length());
    }

    private String getZipName(java.io.File zipFile) {
        return this.getZipName(zipFile.getName());
    }

    private java.io.File zipFileToDirFile(java.io.File zipFile, java.io.File parent) {
        return new java.io.File(parent, this.getZipName(zipFile));
    }

    private String getUploadDirectory() {
        return FileAction.getUploadDirectory((ActionBeanContext)this.getContext());
    }

    public static String getUploadDirectory(ActionBeanContext context) {
        return FileAction.getUploadDirectoryIOFile((ActionBeanContext)context).getAbsolutePath();
    }

    private java.io.File getUploadDirectoryIOFile() {
        return FileAction.getUploadDirectoryIOFile((ActionBeanContext)this.getContext());
    }

    public static java.io.File getUploadDirectoryIOFile(ActionBeanContext context) {
        return new java.io.File(context.getServletContext().getInitParameter("uploadDirectory"));
    }

    public DirContent getDirContent() {
        return this.dirContent;
    }

    public void setDirContent(DirContent dirContent) {
        this.dirContent = dirContent;
    }

    public String getExpandTo() {
        return this.expandTo;
    }

    public void setExpandTo(String expandTo) {
        this.expandTo = expandTo;
    }

    public String getSelectedFilePaths() {
        return this.selectedFilePaths;
    }

    public void setSelectedFilePaths(String selectedFilePaths) {
        this.selectedFilePaths = selectedFilePaths;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getSelectedFilePath() {
        return this.selectedFilePath;
    }

    public void setSelectedFilePath(String selectedFilePath) {
        this.selectedFilePath = selectedFilePath;
    }

    public boolean getAdminPage() {
        return this.adminPage;
    }

    public void setAdminPage(boolean adminPage) {
        this.adminPage = adminPage;
    }

    public java.io.File getOrganizationUploadDir() {
        if (this.isUserAdmin()) {
            return new java.io.File(this.getContext().getServletContext().getInitParameter("uploadDirectory"));
        }
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Organization org = (Organization)session.createQuery("from Organization where id = :id").setParameter("id", (Object)this.getUserOrganiztionId()).uniqueResult();
        if (org != null) {
            return new java.io.File(this.getContext().getServletContext().getInitParameter("uploadDirectory") + java.io.File.separator + org.getUploadPath());
        }
        return null;
    }

    public String getOrganizationUploadString() {
        String uploadPath = null;
        if (this.isUserAdmin()) {
            return this.getContext().getServletContext().getInitParameter("uploadDirectory");
        }
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Organization org = (Organization)session.createQuery("from Organization where id = :id").setParameter("id", (Object)this.getUserOrganiztionId()).uniqueResult();
        if (org != null) {
            uploadPath = this.getContext().getServletContext().getInitParameter("uploadDirectory") + java.io.File.separator + org.getUploadPath();
        }
        return uploadPath;
    }

    private int compareExtensions(String s1, String s2) {
        int s2Dot;
        int s1Dot = s1.lastIndexOf(46);
        if (s1Dot == -1 == ((s2Dot = s2.lastIndexOf(46)) == -1)) {
            s1 = s1.substring(s1Dot + 1);
            s2 = s2.substring(s2Dot + 1);
            return s1.compareTo(s2);
        }
        if (s1Dot == -1) {
            return -1;
        }
        return 1;
    }

    static /* synthetic */ int access$200(FileAction x0, String x1, String x2) {
        return x0.compareExtensions(x1, x2);
    }
}

