/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.security;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.securityfilter.filter.SecurityRequestWrapper;

public class UserPrincipal
implements Principal {
    private static final Log log = LogFactory.getLog(UserPrincipal.class);
    private Integer userId;
    private String userName;
    private Boolean userIsAdmin;
    private Integer userOrganizationId;

    public UserPrincipal() {
    }

    public UserPrincipal(String userName, Boolean userIsAdmin, Integer userOrganizationId) {
        this.userName = userName;
        this.userIsAdmin = userIsAdmin;
        this.userOrganizationId = userOrganizationId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Boolean getUserIsAdmin() {
        return this.userIsAdmin;
    }

    public void setUserIsAdmin(Boolean userIsAdmin) {
        this.userIsAdmin = userIsAdmin;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getUserOrganizationId() {
        return this.userOrganizationId;
    }

    public void setUserOrganizationId(Integer userOrganizationId) {
        this.userOrganizationId = userOrganizationId;
    }

    @Override
    public String getName() {
        return this.userName;
    }

    public static UserPrincipal getUserPrincipal(HttpServletRequest request) {
        Principal user = request.getUserPrincipal();
        if (!(user instanceof UserPrincipal) || !(request instanceof SecurityRequestWrapper)) {
            return null;
        }
        UserPrincipal up = (UserPrincipal)user;
        if (up != null) {
            SecurityRequestWrapper srw = (SecurityRequestWrapper)request;
            srw.setUserPrincipal((Principal)up);
            log.debug((Object)("Automatic login for user: " + up.getUserName()));
        }
        return up;
    }
}

