/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.services;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.entity.Mail;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.entity.ProcessStatus;
import nl.b3p.datastorelinker.util.DataStoreLinkJob;
import nl.b3p.datastorelinker.util.SchedulerUtils;
import nl.b3p.datastorelinker.util.ZipUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class PublishProcessServlet
extends HttpServlet {
    private static final String PARAM_METHOD_ADD = "add";
    private static final String PARAM_SOURCE_SHAPE = "shape";
    private static final String PARAM_SOURCE_SDE = "sde";
    private static final String PARAM_SOURCE_FGDB = "fgdb";
    private static String outputDatabase;
    private static String uploadFolder;
    private final Log log = LogFactory.getLog(this.getClass());

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String type;
        String method;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && (method = pathInfo.split("/")[1]) != null && method.equals(PARAM_METHOD_ADD) && (type = pathInfo.split("/")[2]) != null && type.equals(PARAM_SOURCE_SHAPE)) {
            String prefix = pathInfo.split("/")[3];
            String naam = pathInfo.split("/")[4];
            String tabelNaam = prefix + "_" + naam;
            this.processShape(request, tabelNaam);
        }
        PrintWriter out = response.getWriter();
        out.println("Webservice proces aangemaakt.");
    }

    private void processShape(HttpServletRequest request, String tabelNaam) {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = null;
            try {
                items = upload.parseRequest(request);
            }
            catch (FileUploadException ex) {
                this.log.error((Object)"Fout tijdens inlezen shape bestand: ", (Throwable)ex);
            }
            if (items != null && items.size() > 0) {
                File folder;
                if (uploadFolder != null && !(folder = new File(uploadFolder)).exists()) {
                    folder.mkdirs();
                }
                for (FileItem item : items) {
                    if (item.isFormField()) continue;
                    String fileName = item.getName();
                    String filePath = uploadFolder + fileName;
                    File uploadedFile = new File(filePath);
                    try {
                        item.write(uploadedFile);
                        ZipUtil util = new ZipUtil();
                        File zipFolder = new File(uploadFolder + tabelNaam);
                        util.extractZip(uploadedFile, zipFolder);
                        this.createNewProcess(fileName, tabelNaam);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Fout tijdens schrijven shape bestand: ", (Throwable)ex);
                    }
                }
            }
        }
    }

    private void createNewProcess(String fileName, String identifier) {
        String shapeName = fileName.replaceAll(".zip", ".shp");
        Inout input = new Inout();
        input.setDatatype(Inout.Datatype.FILE);
        input.setFile(uploadFolder + identifier + File.separator + shapeName);
        input.setName("/webservice/" + identifier + "/" + shapeName);
        input.setType(Inout.Type.INPUT);
        input.setOrganizationId(Integer.valueOf(1));
        input.setUserId(Integer.valueOf(1));
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        em.getTransaction().begin();
        Long inputId = (Long)session.save((Object)input);
        this.log.debug((Object)("Created input with id: " + inputId));
        Inout output = new Inout();
        output.setDatatype(Inout.Datatype.DATABASE);
        output.setTableName(identifier);
        output.setType(Inout.Type.OUTPUT);
        Database db = null;
        db = (Database)session.createQuery("from Database where webservice_db = :web").setParameter("web", (Object)true).uniqueResult();
        if (db != null && db.getId() != null) {
            output.setDatabase(db);
        } else {
            this.log.error((Object)"Fout tijdens verbinden naar webservice uitvoer database.");
        }
        output.setOrganizationId(Integer.valueOf(1));
        output.setUserId(Integer.valueOf(1));
        output.setTemplateOutput(Inout.TEMPLATE_OUTPUT_NO_TABLE);
        Long outputId = (Long)session.save((Object)output);
        this.log.debug((Object)("Created output with id: " + outputId));
        Mail mail = new Mail();
        mail.setSubject("Webservice proces " + identifier);
        mail.setToEmailAddress("support@b3partners.nl");
        session.save((Object)mail);
        Process p = new Process();
        p.setActionsString("");
        p.setDrop(Boolean.TRUE);
        p.setName("Webservice proces " + identifier);
        p.setWriterType("ActionCombo_GeometrySplitter_Writer");
        p.setInput(input);
        p.setMail(mail);
        p.setOutput(output);
        ProcessStatus processStatus = ProcessStatus.getDefault();
        session.save((Object)processStatus);
        p.setProcessStatus(processStatus);
        p.setAppend(Boolean.FALSE);
        p.setModify(Boolean.FALSE.booleanValue());
        p.setOrganizationId(Integer.valueOf(1));
        p.setUserId(Integer.valueOf(1));
        Long processId = (Long)session.save((Object)p);
        this.log.debug((Object)("Created process with id: " + processId));
        em.getTransaction().commit();
        this.execute(processId);
    }

    private void execute(Long processId) {
        EntityManager em = JpaUtilServlet.getThreadEntityManager();
        Session session = (Session)em.getDelegate();
        Process process = (Process)session.get(Process.class, (Serializable)processId);
        try {
            String generatedJobUUID = "job" + UUID.randomUUID().toString();
            JobDetail jobDetail = JobBuilder.newJob(DataStoreLinkJob.class).withIdentity(generatedJobUUID).build();
            jobDetail.getJobDataMap().put("processId", (Object)process.getId());
            Trigger trigger = TriggerBuilder.newTrigger().forJob(jobDetail).startNow().build();
            Scheduler scheduler = SchedulerUtils.getScheduler((ServletContext)this.getServletContext());
            process.getProcessStatus().setProcessStatusType(ProcessStatus.Type.RUNNING);
            process.getProcessStatus().setExecutingJobUUID(generatedJobUUID);
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception e) {
            this.log.error((Object)"Fout tijdens uitvoeren webservice process: ", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("outputDatabase") != null) {
                outputDatabase = config.getInitParameter("outputDatabase");
            }
            if (config.getInitParameter("uploadFolder") != null) {
                uploadFolder = config.getInitParameter("uploadFolder");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static String getOutputDatabase() {
        return outputDatabase;
    }

    public static void setOutputDatabase(String outputDatabase) {
        PublishProcessServlet.outputDatabase = outputDatabase;
    }

    public static String getUploadFolder() {
        return uploadFolder;
    }

    public static void setUploadFolder(String uploadFolder) {
        PublishProcessServlet.uploadFolder = uploadFolder;
    }
}

