/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.uploadprogress;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.multipart.CommonsMultipartWrapper;
import nl.b3p.datastorelinker.uploadprogress.ProgressMultipartWrapper;
import nl.b3p.datastorelinker.uploadprogress.UploadProgressListener;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ProgressMultipartWrapper
extends CommonsMultipartWrapper {
    private static final Pattern WINDOWS_PATH_PREFIX_PATTERN = Pattern.compile("(?i:^[A-Z]:\\\\)");
    private Map<String, FileItem> files = new HashMap();
    private Map<String, String[]> parameters = new HashMap();
    private String charset;

    public void build(HttpServletRequest request, File tempDir, long maxPostSize) throws IOException, FileUploadLimitExceededException {
        try {
            ArrayList<String> values;
            this.charset = request.getCharacterEncoding();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(tempDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            UploadProgressListener pListener = new UploadProgressListener();
            upload.setProgressListener((ProgressListener)pListener);
            request.getSession().setAttribute(UploadProgressListener.class.toString(), (Object)pListener);
            upload.setSizeMax(maxPostSize);
            List items = upload.parseRequest(request);
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    values = (ArrayList<String>)params.get(fileItem.getFieldName());
                    if (values == null) {
                        values = new ArrayList<String>();
                        params.put(fileItem.getFieldName(), values);
                    }
                    values.add(this.charset == null ? fileItem.getString() : fileItem.getString(this.charset));
                    continue;
                }
                this.files.put(fileItem.getFieldName(), fileItem);
            }
            for (Map.Entry entry : params.entrySet()) {
                values = (List)entry.getValue();
                this.parameters.put((String)entry.getKey(), values.toArray(new String[values.size()]));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException slee) {
            throw new FileUploadLimitExceededException(maxPostSize, slee.getActualSize());
        }
        catch (FileUploadException fue) {
            IOException ioe = new IOException("Could not parse and cache file upload data.");
            ioe.initCause(fue);
            throw ioe;
        }
    }

    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Enumeration<String> getFileParameterNames() {
        return new IteratorEnumeration(this.files.keySet().iterator());
    }

    public FileBean getFileParameterValue(String name) {
        FileItem item = (FileItem)this.files.get(name);
        if (item == null || (item.getName() == null || item.getName().length() == 0) && item.getSize() == 0L) {
            return null;
        }
        String filename = item.getName();
        int index = WINDOWS_PATH_PREFIX_PATTERN.matcher(filename).find() ? filename.lastIndexOf(92) : filename.lastIndexOf(47);
        if (index >= 0 && index + 1 < filename.length() - 1) {
            filename = filename.substring(index + 1);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static {
        FileUploadException.class.getName();
    }
}

