/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.sourceforge.stripes.util.Log;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.util.Nameable;
import nl.b3p.datastorelinker.util.Util;
import nl.b3p.geotools.data.msaccess.MsAccessDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="database", propOrder={"type", "host", "databaseName", "username", "password", "schema", "port", "alias", "url", "srs", "colX", "colY"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@Entity
@Table(name="database_inout")
@NamedQueries(value={@NamedQuery(name="Database.find", query="from Database where typeInout = :typeInout order by name")})
public class Database
implements Serializable,
Nameable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getInstance(Database.class);
    @Id
    @Basic(optional=false)
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Basic(optional=true)
    @Column(name="name")
    private String name;
    @Column(name="host_name")
    private String host;
    @Column(name="database_name")
    private String databaseName;
    @Column(name="username")
    private String username;
    @Column(name="password")
    private String password;
    @Column(name="db_schema")
    private String schema;
    @Column(name="port")
    private Integer port;
    @Column(name="db_alias")
    private String alias;
    @Column(name="url")
    private String url;
    @Column(name="srs")
    private String srs;
    @Column(name="col_x")
    private String colX;
    @Column(name="col_y")
    private String colY;
    @XmlTransient
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="database")
    private List<Inout> inoutList;
    @Basic(optional=false)
    @Column(name="database_type")
    @Enumerated(value=EnumType.STRING)
    private Type type;
    @Basic(optional=false)
    @Column(name="inout_type")
    @Enumerated(value=EnumType.STRING)
    private TypeInout typeInout;
    @Basic(optional=true)
    @Column(name="organization_id")
    private Integer organizationId;
    @Basic(optional=true)
    @Column(name="user_id")
    private Integer userId;
    @Basic(optional=false)
    @Column(name="webservice_db")
    private Boolean webserviceDb = false;

    public Database() {
    }

    public Database(Long id) {
        this.id = id;
    }

    public void reset() {
        this.alias = null;
        this.colX = null;
        this.colY = null;
        this.databaseName = null;
        this.host = null;
        this.name = null;
        this.password = null;
        this.port = null;
        this.schema = null;
        this.srs = null;
        this.url = null;
        this.username = null;
    }

    public Map<String, Object> toGeotoolsDataStoreParametersMap() {
        return this.toGeotoolsDataStoreParametersMap("");
    }

    public Map<String, Object> toGeotoolsDataStoreParametersMap(String keyPrefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getInoutList() != null && this.getInoutList().size() > 0 && this.getInoutList().get(0).getType() == Inout.Type.INPUT) {
            map.put(JDBCDataStoreFactory.EXPOSE_PK.key, Boolean.TRUE);
        }
        map.put(JDBCDataStoreFactory.VALIDATECONN.key, Boolean.TRUE);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.DBTYPE.key, this.type.getGeotoolsType(), keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.HOST.key, this.host, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.PORT.key, this.port, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.DATABASE.key, this.databaseName, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.USER.key, this.username, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.PASSWD.key, this.password, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.FETCHSIZE.key, 50, keyPrefix);
        Util.addToMapIfNotNull(map, JDBCDataStoreFactory.SCHEMA.key, this.schema, keyPrefix);
        Util.addToMapIfNotNull(map, MsAccessDataStoreFactory.PARAM_URL.key, this.url, keyPrefix);
        Util.addToMapIfNotNull(map, MsAccessDataStoreFactory.PARAM_SRS.key, this.srs, keyPrefix);
        Util.addToMapIfNotNull(map, MsAccessDataStoreFactory.PARAM_XLABELS.key, this.colX, keyPrefix);
        Util.addToMapIfNotNull(map, MsAccessDataStoreFactory.PARAM_YLABELS.key, this.colY, keyPrefix);
        log.debug(new Object[]{map});
        return map;
    }

    @XmlTransient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @XmlTransient
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.type == Type.ORACLE) {
            return this.host + "/" + this.schema;
        }
        if (this.type == Type.POSTGIS) {
            return this.host + "/" + this.databaseName + "/" + this.schema;
        }
        return this.host + "/" + this.databaseName;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    public String getColX() {
        return this.colX;
    }

    public void setColX(String colX) {
        this.colX = colX;
    }

    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    public String getColY() {
        return this.colY;
    }

    public void setColY(String colY) {
        this.colY = colY;
    }

    @XmlTransient
    public List<Inout> getInoutList() {
        return this.inoutList;
    }

    public void setInoutList(List<Inout> inoutList) {
        this.inoutList = inoutList;
    }

    @XmlElement(required=true, name="dbtype")
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @XmlTransient
    public TypeInout getTypeInout() {
        return this.typeInout;
    }

    public void setTypeInout(TypeInout typeInout) {
        this.typeInout = typeInout;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Database)) {
            return false;
        }
        Database other = (Database)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "nl.b3p.datastorelinker.entity.Database[id=" + this.id + "]";
    }

    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Boolean getWebserviceDb() {
        return this.webserviceDb;
    }

    public void setWebserviceDb(Boolean webserviceDb) {
        this.webserviceDb = webserviceDb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeInout {
        INPUT,
        OUTPUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlType(name="database_type")
    @XmlEnum
    public static enum Type {
        POSTGIS("postgis"),
        ORACLE("oracle"),
        MSACCESS("msaccess");

        private final String geotoolsType;

        private Type(String geotoolsType) {
            this.geotoolsType = geotoolsType;
        }

        public String getGeotoolsType() {
            return this.geotoolsType;
        }

        public static Type fromValue(String geotoolsType) {
            for (Type c : Type.values()) {
                if (!c.geotoolsType.equals(geotoolsType)) continue;
                return c;
            }
            throw new IllegalArgumentException(geotoolsType.toString());
        }
    }
}

