/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Organization;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.util.Nameable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="inout")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Entity
@Table(name="input_output")
@NamedQueries(value={@NamedQuery(name="Inout.find", query="from Inout where type = :typeName order by name"), @NamedQuery(name="Inout.findAllOfDataType", query="from Inout where type = :typeName and datatype = :datatypeName order by name")})
public class Inout
implements Serializable,
Nameable {
    public static String TYPE_INPUT = "INPUT";
    public static String TYPE_OUTPUT = "OUTPUT";
    public static String TYPE_FILE = "FILE";
    public static String TYPE_DATABASE = "DATABASE";
    public static String TEMPLATE_OUTPUT_USE_TABLE = "USE_TABLE";
    public static String TEMPLATE_OUTPUT_AS_TEMPLATE = "AS_TEMPLATE";
    public static String TEMPLATE_OUTPUT_NO_TABLE = "NO_TABLE";
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional=false)
    @Column(name="id")
    @GeneratedValue
    @XmlTransient
    private Long id;
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    @Column(name="input_output_type")
    @XmlTransient
    private Type type;
    @Column(name="table_name")
    private String tableName;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="input")
    @XmlTransient
    private List<Process> inputProcessList;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="output")
    @XmlTransient
    private List<Process> outputProcessList;
    @JoinColumn(name="database_id", referencedColumnName="id")
    @ManyToOne
    private Database database;
    @Basic(optional=true)
    @Column(name="file_name")
    private String file;
    @Basic(optional=true)
    @Column(name="srs")
    private String srs;
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    @Column(name="input_output_datatype")
    @XmlTransient
    private Datatype datatype;
    @Basic(optional=true)
    @Column(name="name")
    @XmlTransient
    private String name;
    @Basic(optional=true)
    @Column(name="organization_id")
    private Integer organizationId;
    @Basic(optional=true)
    @Column(name="user_id")
    private Integer userId;
    @Basic(optional=true)
    @Column(name="template_output")
    private String templateOutput;
    @ManyToMany
    @JoinTable(name="output_organization", joinColumns={@JoinColumn(name="output_id", unique=false)}, inverseJoinColumns={@JoinColumn(name="organization_id")})
    private List<Organization> organizations;

    public Inout() {
    }

    public Inout(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Process> getInputProcessList() {
        return this.inputProcessList;
    }

    public void setInputProcessList(List<Process> inputProcessList) {
        this.inputProcessList = inputProcessList;
    }

    public List<Process> getOutputProcessList() {
        return this.outputProcessList;
    }

    public void setOutputProcessList(List<Process> outputProcessList) {
        this.outputProcessList = outputProcessList;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    @Override
    public String getName() {
        if (this.datatype == Datatype.DATABASE) {
            if (this.name != null) {
                return this.name;
            }
            String inoutName = "";
            if (this.tableName != null && !this.tableName.trim().equals("")) {
                inoutName = this.tableName.trim();
            }
            if (this.database != null) {
                inoutName = inoutName + " (" + this.database.getName() + ")";
            }
            return inoutName;
        }
        if (this.datatype == Datatype.FILE) {
            if (this.name != null) {
                return this.name;
            }
            return this.file;
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Inout)) {
            return false;
        }
        Inout other = (Inout)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "nl.b3p.datastorelinker.entity.Inout[id=" + this.id + "]";
    }

    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getTemplateOutput() {
        return this.templateOutput;
    }

    public void setTemplateOutput(String templateOutput) {
        this.templateOutput = templateOutput;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(List<Organization> organizations) {
        this.organizations = organizations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlTransient
    public static enum Datatype {
        FILE,
        DATABASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlTransient
    public static enum Type {
        INPUT,
        OUTPUT;

    }
}

