/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.entity;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import net.sourceforge.stripes.util.Log;
import nl.b3p.datastorelinker.entity.Inout;
import nl.b3p.datastorelinker.entity.Mail;
import nl.b3p.datastorelinker.entity.ProcessStatus;
import nl.b3p.datastorelinker.entity.Schedule;
import nl.b3p.datastorelinker.util.Nameable;
import org.hibernate.annotations.Type;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Element;

@XmlRootElement
@XmlType(name="processType")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Entity
@Table(name="process")
public class Process
implements Serializable,
Nameable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static final boolean DEFAULT_DROP = true;
    @XmlTransient
    private static final boolean DEFAULT_APPEND = false;
    @XmlTransient
    private static final String DEFAULT_WRITER_TYPE = "ActionCombo_GeometrySplitter_Writer";
    @XmlTransient
    private static final Log log = Log.getInstance(Process.class);
    @Id
    @Basic(optional=false)
    @Column(name="id")
    @GeneratedValue
    @XmlTransient
    private Long id;
    @Basic(optional=true)
    @Column(name="name")
    @XmlTransient
    private String name;
    @Basic(optional=false)
    @Column(name="actions")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @XmlTransient
    private String actions;
    @JoinColumn(name="input_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    @XmlElement(required=true, name="input")
    private Inout input;
    @JoinColumn(name="output_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    @XmlElement(required=true, name="output")
    private Inout output;
    @Basic(optional=true)
    @Column(name="features_start")
    private Integer featuresStart;
    @Basic(optional=true)
    @Column(name="features_end")
    private Integer featuresEnd;
    @Basic(optional=false)
    @Column(name="drop_table")
    private Boolean drop = true;
    @Basic(optional=false)
    @Column(name="append_table")
    private Boolean append = false;
    @Basic(optional=false)
    @Column(name="writer_type")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String writerType = "ActionCombo_GeometrySplitter_Writer";
    @JoinColumn(name="mail_id", referencedColumnName="id")
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    private Mail mail;
    @JoinColumn(name="schedule", referencedColumnName="id")
    @ManyToOne(optional=true, cascade={CascadeType.ALL})
    @XmlTransient
    private Schedule schedule;
    @JoinColumn(name="process_status_id", referencedColumnName="id")
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    @XmlTransient
    private ProcessStatus processStatus;
    @Basic(optional=true)
    @Column(name="organization_id")
    private Integer organizationId;
    @Basic(optional=true)
    @Column(name="user_id")
    private Integer userId;
    @Basic(optional=true)
    @Column(name="user_name")
    private String userName;
    @Basic(optional=true)
    @Column(name="remarks")
    private String remarks;
    @Basic(optional=true)
    @ManyToOne(fetch=FetchType.LAZY)
    private Process linkedProcess;

    public Process() {
    }

    public Process(Long id) {
        this.id = id;
    }

    public Process(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Map toOutputMap() {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        outputMap.put("drop", this.getDrop());
        outputMap.put("append", this.getAppend());
        outputMap.put("params", this.getOutput().getDatabase().toGeotoolsDataStoreParametersMap());
        return outputMap;
    }

    public JSONObject toJSONObject() {
        Process ancestor;
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)this.id);
        obj.put((Object)"name", (Object)this.name);
        Integer numAncestors = 0;
        if (ancestor != null) {
            obj.put((Object)"ancestor", (Object)this.linkedProcess.getId());
            for (ancestor = this.linkedProcess; ancestor != null; ancestor = ancestor.getLinkedProcess()) {
                Integer n = numAncestors;
                Integer n2 = numAncestors = Integer.valueOf(numAncestors + 1);
            }
        } else {
            obj.put((Object)"ancestor", null);
        }
        obj.put((Object)"numAncestors", (Object)numAncestors);
        return obj;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.input.getName() + " -> " + this.output.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getActionsString() {
        return this.actions;
    }

    public void setActionsString(String actions) {
        this.actions = actions;
    }

    @XmlAnyElement(lax=true)
    public Element getActions() {
        try {
            log.debug(new Object[]{"getActions: " + this.actions});
            Document jdoc = new SAXBuilder().build((Reader)new StringReader(this.actions));
            this.assignDslNS(jdoc.getRootElement());
            org.w3c.dom.Document doc = new DOMOutputter().output(jdoc);
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, new Object[0]);
            return null;
        }
    }

    private void assignDslNS(org.jdom.Element elem) {
        elem.setNamespace(Namespace.getNamespace((String)"http://www.b3partners.nl/schemas/dsl"));
        for (Object childElem : elem.getChildren()) {
            this.assignDslNS((org.jdom.Element)childElem);
        }
    }

    public void setActions(Element element) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(element), new StreamResult(writer));
            this.actions = writer.toString();
        }
        catch (Exception ex) {
            log.error((Throwable)ex, new Object[0]);
            this.actions = "";
        }
        log.debug(new Object[]{"setActions: " + this.actions});
    }

    public Inout getInput() {
        return this.input;
    }

    public void setInput(Inout input) {
        this.input = input;
    }

    public Inout getOutput() {
        return this.output;
    }

    public void setOutput(Inout output) {
        this.output = output;
    }

    public Integer getFeaturesStart() {
        return this.featuresStart;
    }

    public void setFeaturesStart(Integer featuresStart) {
        this.featuresStart = featuresStart;
    }

    public Integer getFeaturesEnd() {
        return this.featuresEnd;
    }

    public void setFeaturesEnd(Integer featuresEnd) {
        this.featuresEnd = featuresEnd;
    }

    public Boolean getDrop() {
        return this.drop;
    }

    public void setDrop(Boolean drop) {
        this.drop = drop;
    }

    public Boolean getAppend() {
        return this.append;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public void setWriterType(String writerType) {
        this.writerType = writerType;
    }

    public Mail getMail() {
        return this.mail;
    }

    public void setMail(Mail mail) {
        this.mail = mail;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public ProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(ProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Process)) {
            return false;
        }
        Process other = (Process)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "nl.b3p.datastorelinker.entity.Process[id=" + this.id + "]";
    }

    public Integer getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Integer organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Process getLinkedProcess() {
        return this.linkedProcess;
    }

    public void setLinkedProcess(Process linkedProcess) {
        this.linkedProcess = linkedProcess;
    }
}

