/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.stripes.util.Log;

public class Util {
    private static final Log log = Log.getInstance(Util.class);

    public static void addToMapIfNotNull(Map<String, Object> map, String key, Object value) {
        Util.addToMapIfNotNull(map, key, value, "");
    }

    public static void addToMapIfNotNull(Map<String, Object> map, String key, Object value, String keyPrefix) {
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        if (key != null && value != null) {
            map.put(keyPrefix + key, value);
        }
    }

    public static Map<String, Object> fileToMap(File file) throws IOException {
        return Util.fileToMap(file, "");
    }

    public static Map<String, Object> fileToMap(File file, String keyPrefix) throws IOException {
        if (file.isDirectory()) {
            String message = "Attempt to run dsl with a directory as input: " + file.getAbsolutePath();
            throw new IOException(message);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        URL qname = null;
        if (file.exists()) {
            try {
                qname = file.toURI().toURL();
            }
            catch (Exception e) {
                log.error(new Object[]{"Malformed file url: " + e.getMessage()});
            }
        } else {
            String message = "File does not exist: " + file;
            throw new IOException(message);
        }
        Util.addToMapIfNotNull(map, "url", qname, keyPrefix);
        Util.addToMapIfNotNull(map, "srs", "EPSG:28992", keyPrefix);
        return map;
    }
}

