/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.datastorelinker.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sourceforge.stripes.util.Log;
import nl.b3p.datastorelinker.entity.Process;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.DOMOutputter;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MarshalUtils {
    private static final Log log = Log.getInstance(MarshalUtils.class);
    private static final String JAXB_ELEMENTS_PACKAGE = "nl.b3p.datastorelinker.entity";
    private static final String DSL_XSD_PATH = "nl/b3p/datastorelinker/entity/dsl.xsd";

    public static String marshalProcess(Process process) throws JAXBException {
        return MarshalUtils.marshal(process, null);
    }

    public static String marshalProcess(Process process, Schema schema) throws JAXBException {
        JAXBElement jaxbProcess = new JAXBElement(new QName("http://www.b3partners.nl/schemas/dsl", "process", "dsl"), Process.class, (Object)process);
        return MarshalUtils.marshal(jaxbProcess, schema);
    }

    public static String marshal(Object object) throws JAXBException {
        return MarshalUtils.marshal(object, null);
    }

    public static String marshal(Object object, Schema schema) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_ELEMENTS_PACKAGE);
        log.debug(new Object[]{jaxbContext});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setSchema(schema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static JAXBElement unmarshal(org.w3c.dom.Document xmlDocument, Class clazz) throws JAXBException {
        return MarshalUtils.unmarshal(xmlDocument, clazz, null);
    }

    public static JAXBElement unmarshal(org.w3c.dom.Document xmlDocument, Class clazz, Schema schema) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_ELEMENTS_PACKAGE);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setSchema(schema);
        return unmarshaller.unmarshal((Node)xmlDocument, clazz);
    }

    public static JAXBElement unmarshal(Document xmlDocument, Class clazz) throws JAXBException, JDOMException {
        return MarshalUtils.unmarshal(xmlDocument, clazz, null);
    }

    public static JAXBElement unmarshal(Document xmlDocument, Class clazz, Schema schema) throws JAXBException, JDOMException {
        DOMOutputter domOutputter = new DOMOutputter();
        org.w3c.dom.Document w3cDomDoc = domOutputter.output(xmlDocument);
        return MarshalUtils.unmarshal(w3cDomDoc, clazz, schema);
    }

    public static Process unmarshalProcess(InputStream xmlDocument) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        return MarshalUtils.unmarshalProcess(xmlDocument, null);
    }

    public static Process unmarshalProcess(InputStream xmlDocument, Schema schema) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        org.w3c.dom.Document w3cXmlDocument = documentBuilder.parse(new InputSource(xmlDocument));
        JAXBElement jaxbProcess = MarshalUtils.unmarshal(w3cXmlDocument, Process.class, schema);
        return (Process)jaxbProcess.getValue();
    }

    public static Process unmarshalProcess(Document xmlDocument) throws JAXBException, JDOMException {
        return MarshalUtils.unmarshalProcess(xmlDocument, null);
    }

    public static Process unmarshalProcess(Document xmlDocument, Schema schema) throws JAXBException, JDOMException {
        JAXBElement jaxbProcess = MarshalUtils.unmarshal(xmlDocument, Process.class, schema);
        return (Process)jaxbProcess.getValue();
    }

    public static Process unmarshalProcess(String xmlDocument) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        return MarshalUtils.unmarshalProcess(xmlDocument, null);
    }

    public static Process unmarshalProcess(String xmlDocument, Schema schema) throws JAXBException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        org.w3c.dom.Document w3cXmlDocument = documentBuilder.parse(new InputSource(new StringReader(xmlDocument)));
        JAXBElement jaxbProcess = MarshalUtils.unmarshal(w3cXmlDocument, Process.class, schema);
        return (Process)jaxbProcess.getValue();
    }

    public static Schema getDslSchema() throws SAXException {
        InputStream schemaStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DSL_XSD_PATH);
        log.debug(new Object[]{"schemaStream: " + schemaStream});
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(new StreamSource(schemaStream));
    }
}

