/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.digitree.viewer;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.digitree.db.Boom;
import nl.b3p.digitree.viewer.LabelsUtil;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.hibernate.classic.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class EditBoomAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(EditBoomAction.class);
    protected static final String SEND_EDITBOOM = "sendEditBoom";
    protected static final String REMOVE_BOOM = "removeBoom";
    private static final String[] EDIT_FIELDS = new String[]{"id", "the_geom", "boomid", "projectid", "project", "status", "upload_rdx", "upload_rdy", "mutatiedatum", "mutatietijd", "inspecteur", "aktie", "boomsrt", "plantjaar", "boomhoogte", "eindbeeld", "scheefstand", "scheuren", "holten", "stamvoetschade", "stamschade", "kroonschade", "inrot", "houtboorder", "zwam", "zwam_stamvoet", "zwam_stam", "zwam_kroon", "dood_hout", "plakoksel", "stamschot", "wortelopslag", "takken", "opdruk", "vta1", "vta2", "vta3", "vta4", "vta5", "vta6", "aantastingen", "status_zp", "classificatie", "maatregelen_kort", "nader_onderzoek", "maatregelen_lang", "risicoklasse", "uitvoerdatum", "bereikbaarheid", "wegtype", "opmerkingen", "extra1", "extra2", "extra3", "extra4", "extra5", "extra6", "extra7", "extra8", "extra9", "extra10"};
    private static final String[] NEW_FIELDS = new String[]{"the_geom", "boomid", "projectid", "project", "status", "upload_rdx", "upload_rdy", "mutatiedatum", "mutatietijd", "inspecteur", "aktie", "boomsrt", "plantjaar", "boomhoogte", "eindbeeld", "scheefstand", "scheuren", "holten", "stamvoetschade", "stamschade", "kroonschade", "inrot", "houtboorder", "zwam", "zwam_stamvoet", "zwam_stam", "zwam_kroon", "dood_hout", "plakoksel", "stamschot", "wortelopslag", "takken", "opdruk", "vta1", "vta2", "vta3", "vta4", "vta5", "vta6", "aantastingen", "status_zp", "classificatie", "maatregelen_kort", "nader_onderzoek", "maatregelen_lang", "risicoklasse", "uitvoerdatum", "bereikbaarheid", "wegtype", "opmerkingen", "extra1", "extra2", "extra3", "extra4", "extra5", "extra6", "extra7", "extra8", "extra9", "extra10"};
    private static final String[] BOOMHOOGTE = new String[]{"0-6 m", "6-9 m", "9-12 m", "12-15 m", "15-18 m", "18-24 m", ">24 m"};
    private static final String[] EINDBEELD = new String[]{"vrij uitgroeiend", "niet vrij uitgroeiend", "opkronen 0-4 m", "opkronen 0-6 m", "opkronen 0-8 m", "opkronen 4-4 m", "opkronen 4-6 m", "opkronen 4-8 m", "opkronen 6-6 m", "opkronen 6-8 m", "opkronen 8-8 m", "knotboom", "leiboom", "gekandelaberde boom", "haagboom", "vormboom", "overig"};
    private static final String[] AANTASTINGEN = new String[]{"massaria", "essterfte", "iepziekte", "eikenprocessierups", "bloedingsziekte", "Bastwoekerziekte", "Berkendoder", "Berkenweerschijnzwam", "Dikrandtonderzwam", "Echte honingzwam", "Echte tonderzwam", "Eikenweerschijnzwam", "Gesteelde lakzwam", "Gewone oesterzwam", "Goudvliesbundelzwam", "Harslakzwam", "Kastanjemineermot", "Kogelhoutskoolzwam", "Korsthoutskoolzwam", "Platte tonderzwam", "Prachtkever", "Reuzenzwam", "Roodporiezwam", "Sombere honingzwam", "Verwelkingziekte (Verticilium)", "Waslakzwam", "Watermerkziekte", "Wilgenhoutrups", "Zadelzwam", "Zwavelzwam"};
    private static final String[] AANTASTINGEN_DIGIDIS = new String[]{"massaria", "essterfte", "iepziekte", "eikenprocessierups", "bloedingsziekte"};
    private static final String[] MAATREGELEN_KORT = new String[]{"BGS beeld", "BGS achterstallig", "BGS verwaarloosd", "OHS beeld", "OHS achterstallig", "Rooien"};
    private static final String[] MAATREGELEN_LANG = new String[]{"BGS fase", "OHS 1x/1 jr", "OHS 1x/2 jr", "OHS 1x/3 jr", "OHS 1x/6 jr", "OHS 1x/9 jr", "OHS 1x/12 jr"};
    private static final String[] RISICOKLASSE = new String[]{"geen verhoogd risico", "mogelijk verhoogd risico", "tijdelijk verhoogd risico", "attentieboom", "risicoboom"};
    private static final String[] WEGTYPE = new String[]{"A", "B1", "B2", "C1", "C2", "D", "E", "F1", "F2", "KR", "RO", "FP", "VP"};

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(REMOVE_BOOM);
        hibProp.setDefaultForwardName("success");
        hibProp.setDefaultMessageKey("message.deleteboom.success");
        hibProp.setAlternateForwardName("failure");
        map.put(REMOVE_BOOM, hibProp);
        hibProp = new ExtendedMethodProperties(SEND_EDITBOOM);
        hibProp.setDefaultForwardName("success");
        hibProp.setDefaultMessageKey("message.sendeditboom.success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("error.sendeditboom.failed");
        map.put(SEND_EDITBOOM, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.makeLists(dynaForm, request);
        return mapping.findForward("success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward sendEditBoom(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String massage = "";
        Boom boom = new Boom();
        boolean valideBoom = this.populateBoomObject(dynaForm, request, boom);
        Integer ggbId = (Integer)dynaForm.get("gegevensbron");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Gegevensbron ggb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)ggbId);
        String uniek = this.checkPK(boom, ggb.getAdmin_tabel());
        if (!valideBoom) {
            massage = "error.boom.niet.valide";
        } else if (uniek.equals("") || !uniek.equals("") && boom.getId() != null && boom.getId() != -1) {
            ggb.getBron().getUrl();
            String adminPk = ggb.getAdmin_pk();
            DataStore ds = ggb.getBron().toDatastore();
            try {
                String typename = ggb.getAdmin_tabel();
                SimpleFeatureType ft = ds.getSchema(typename);
                SimpleFeature f = boom.getFeature(ft);
                Integer id = FormUtils.getInteger((DynaValidatorForm)dynaForm, (String)"id");
                String status = dynaForm.getString("status");
                if (id != null && id > 0 && status.equals("nieuw")) {
                    this.doUpdate(adminPk, ds, f, id);
                }
                this.doInsert(ds, f);
            }
            finally {
                ds.dispose();
            }
        } else {
            massage = "error.boom.niet.uniek";
            String wkt = this.getWKT(ggb.getAdmin_tabel(), uniek);
            request.setAttribute("boomWkt", (Object)wkt);
        }
        this.makeLists(dynaForm, request);
        if (valideBoom && massage.length() == 0) {
            this.addDefaultMessage(mapping, request, "acknowledgeMessages");
            return mapping.findForward("success");
        }
        this.addAlternateMessage(mapping, request, massage);
        return this.getAlternateForward(mapping, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward removeBoom(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer ggbId = (Integer)dynaForm.get("gegevensbron");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Gegevensbron ggb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)ggbId);
        ggb.getBron().getUrl();
        DataStore ds = ggb.getBron().toDatastore();
        String adminPK = ggb.getAdmin_pk();
        try {
            String typename = ggb.getAdmin_tabel();
            Integer id = FormUtils.getInteger((DynaValidatorForm)dynaForm, (String)"id");
            String boomid = dynaForm.getString("boomid");
            String status = dynaForm.getString("status");
            List bomen = this.getBomen(boomid);
            int aantal = bomen.size();
            if (id != null && id > 0 && status.equals("nieuw")) {
                this.doDelete(adminPK, ds, typename, id);
            } else if (id != null && id > 0 && status.equals("actueel")) {
                Boom boom = new Boom();
                this.populateBoomObject(dynaForm, request, boom);
                boom.setStatus("weg");
                SimpleFeatureType ft = ds.getSchema(typename);
                SimpleFeature f = boom.getFeature(ft);
                this.doUpdate(adminPK, ds, f, id);
            }
        }
        finally {
            ds.dispose();
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        this.cleanForm(dynaForm);
        this.makeLists(dynaForm, request);
        return this.getDefaultForward(mapping, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(String adminPk, DataStore ds, String typename, Integer id) throws IOException, CQLException {
        Filter f = CQL.toFilter((String)(adminPk + " = '" + id + "'"));
        try (FeatureWriter writer = ds.getFeatureWriter(typename, f, Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                writer.remove();
            }
        }
    }

    private void makeLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Map instellingen = this.getInstellingenMap(request);
        Integer gbId = (Integer)instellingen.get("boomGegevensbron");
        if (gbId == null || gbId == 0) {
            throw new Exception("Geen gegevensbron voor bomen gevonden!");
        }
        dynaForm.set("gegevensbron", (Object)gbId);
        request.setAttribute("BOOMHOOGTE", (Object)BOOMHOOGTE);
        request.setAttribute("EINDBEELD", (Object)EINDBEELD);
        request.setAttribute("AANTASTINGEN", (Object)AANTASTINGEN);
        request.setAttribute("AANTASTINGEN_DIGIDIS", (Object)AANTASTINGEN_DIGIDIS);
        request.setAttribute("MAATREGELEN_KORT", (Object)MAATREGELEN_KORT);
        request.setAttribute("MAATREGELEN_LANG", (Object)MAATREGELEN_LANG);
        request.setAttribute("RISICOKLASSE", (Object)RISICOKLASSE);
        request.setAttribute("WEGTYPE", (Object)WEGTYPE);
        GisPrincipal userInlog = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        if (userInlog != null) {
            String usernaam = userInlog.getName();
            String naam = this.getUserFullname(usernaam);
            dynaForm.set("inspecteur", (Object)naam);
        }
        LabelsUtil.getExtraLabels(request);
    }

    private boolean populateBoomObject(DynaValidatorForm dynaForm, HttpServletRequest request, Boom boom) {
        GisPrincipal user;
        Integer id = FormUtils.getInteger((DynaValidatorForm)dynaForm, (String)"id");
        String boomid = FormUtils.nullIfEmpty((String)dynaForm.getString("boomid"));
        String projectid = FormUtils.nullIfEmpty((String)dynaForm.getString("projectid"));
        String project = FormUtils.nullIfEmpty((String)dynaForm.getString("project"));
        Integer plantjaar = FormUtils.getInteger((DynaValidatorForm)dynaForm, (String)"plantjaar");
        String inspecteur = FormUtils.nullIfEmpty((String)dynaForm.getString("inspecteur"));
        String aktie = FormUtils.nullIfEmpty((String)dynaForm.getString("aktie"));
        String boomlabel = FormUtils.nullIfEmpty((String)dynaForm.getString("boomsoort"));
        String boomsoort = this.getBoomSoort(boomlabel);
        String boomhoogte = FormUtils.nullIfEmpty((String)dynaForm.getString("boomhoogte"));
        String boomhoogtevrij = FormUtils.nullIfEmpty((String)dynaForm.getString("boomhoogtevrij"));
        String eindbeeldvrij = FormUtils.nullIfEmpty((String)dynaForm.getString("eindbeeldvrij"));
        String eindbeeld = FormUtils.nullIfEmpty((String)dynaForm.getString("eindbeeld"));
        String aantastingenvrij = FormUtils.nullIfEmpty((String)dynaForm.getString("aantastingenvrij"));
        String aantastingen = FormUtils.nullIfEmpty((String)dynaForm.getString("aantastingen"));
        String status_zp = FormUtils.nullIfEmpty((String)dynaForm.getString("status_zp"));
        String classificatie = FormUtils.nullIfEmpty((String)dynaForm.getString("classificatie"));
        String maatregelen_kortvrij = FormUtils.nullIfEmpty((String)dynaForm.getString("maatregelen_kortvrij"));
        String maatregelen_kort = FormUtils.nullIfEmpty((String)dynaForm.getString("maatregelen_kort"));
        String maatregelen_langvrij = FormUtils.nullIfEmpty((String)dynaForm.getString("maatregelen_langvrij"));
        String maatregelen_lang = FormUtils.nullIfEmpty((String)dynaForm.getString("maatregelen_lang"));
        String risicoklasse = FormUtils.nullIfEmpty((String)dynaForm.getString("risicoklasse"));
        String uitvoerdatum = FormUtils.nullIfEmpty((String)dynaForm.getString("uitvoerdatum"));
        String wegtypevrij = FormUtils.nullIfEmpty((String)dynaForm.getString("wegtypevrij"));
        String wegtype = FormUtils.nullIfEmpty((String)dynaForm.getString("wegtype"));
        String opmerking = FormUtils.nullIfEmpty((String)dynaForm.getString("opmerking"));
        String extra1 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra1"));
        String extra2 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra2"));
        String extra3 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra3"));
        String extra4 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra4"));
        String extra5 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra5"));
        String extra6 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra6"));
        String extra7 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra7"));
        String extra8 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra8"));
        String extra9 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra9"));
        String extra10 = FormUtils.nullIfEmpty((String)dynaForm.getString("extra10"));
        boolean scheefstand = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"scheefstand");
        boolean scheuren = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"scheuren");
        boolean holten = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"holten");
        boolean stamvoetschade = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"stamvoetschade");
        boolean stamschade = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"stamschade");
        boolean kroonschade = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"kroonschade");
        boolean inrot = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"inrot");
        boolean houtboorder = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"houtboorder");
        boolean zwam = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"zwam");
        boolean zwam_stamvoet = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"zwam_stamvoet");
        boolean zwam_stam = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"zwam_stam");
        boolean zwam_kroon = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"zwam_kroon");
        boolean dood_hout = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"dood_hout");
        boolean plakoksel = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"plakoksel");
        boolean stamschot = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"stamschot");
        boolean wortelopslag = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"wortelopslag");
        boolean takken = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"takken");
        boolean opdruk = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"opdruk");
        boolean vta1 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta1");
        boolean vta2 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta2");
        boolean vta3 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta3");
        boolean vta4 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta4");
        boolean vta5 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta5");
        boolean vta6 = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"vta6");
        boolean nader_onderzoek = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"nader_onderzoek");
        boolean bereikbaarheid = FormUtils.getBoolean((DynaValidatorForm)dynaForm, (String)"bereikbaarheid");
        if (id.equals(0)) {
            id = null;
        }
        boom.setId(id);
        boom.setBoomid(boomid);
        String wkt = dynaForm.getString("wkt");
        try {
            Geometry geom = DataStoreUtil.createGeomFromWKTString((String)wkt);
            String xy = geom.getCoordinate().toString().substring(1);
            String[] coordinaten = xy.split(",");
            String x = coordinaten[0].trim();
            String y = coordinaten[1].trim();
            int puntX = x.indexOf(".");
            int puntY = y.indexOf(".");
            boom.setUpload_rdx(x.substring(0, puntX + 2));
            boom.setUpload_rdy(y.substring(0, puntY + 2));
            boom.setThe_geom(geom);
        }
        catch (Exception ex) {
            logger.error((Object)"Fout tijdens omzetten wkt voor editing: ", (Throwable)ex);
            return false;
        }
        if ((projectid == null || projectid.equals("")) && (user = GisPrincipal.getGisPrincipal((HttpServletRequest)request)) != null && user.getSp() != null) {
            projectid = user.getSp().getOrganizationCode();
        }
        if (project == null || project.equals("")) {
            project = this.getWijk(boom.getThe_geom(), projectid);
            dynaForm.set("project", (Object)project);
        }
        boom.setProjectid(projectid);
        boom.setProject(project);
        boom.setStatus("nieuw");
        boom.setPlantjaar(plantjaar);
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss", new Locale("NL"));
        String mutatiedatum = dateFormat.format(now);
        String mutatietijd = timeFormat.format(now);
        boom.setMutatiedatum(mutatiedatum);
        boom.setMutatietijd(mutatietijd);
        dynaForm.set("mutatiedatum", (Object)mutatiedatum);
        dynaForm.set("mutatietijd", (Object)mutatietijd);
        boom.setInspecteur(inspecteur);
        boom.setAktie(aktie);
        boom.setBoomsrt(boomsoort);
        if (boomhoogtevrij != null) {
            boom.setBoomhoogte(boomhoogtevrij);
        } else if (boomhoogte != null && !boomhoogte.equals("")) {
            boom.setBoomhoogte(boomhoogte);
        }
        if (eindbeeldvrij != null) {
            boom.setEindbeeld(eindbeeldvrij);
        } else if (eindbeeld != null && !eindbeeld.equals("")) {
            boom.setEindbeeld(eindbeeld);
        }
        if (aantastingenvrij != null) {
            boom.setAantastingen(aantastingenvrij);
        } else if (aantastingen != null && !aantastingen.equals("")) {
            boom.setAantastingen(aantastingen);
        }
        boom.setStatus_zp(status_zp);
        boom.setClassificatie(classificatie);
        if (maatregelen_kortvrij != null) {
            boom.setMaatregelen_kort(maatregelen_kortvrij);
        } else if (maatregelen_kort != null && !maatregelen_kort.equals("")) {
            boom.setMaatregelen_kort(maatregelen_kort);
        }
        if (maatregelen_langvrij != null) {
            boom.setMaatregelen_lang(maatregelen_langvrij);
        } else if (maatregelen_lang != null && !maatregelen_lang.equals("")) {
            boom.setMaatregelen_lang(maatregelen_lang);
        }
        boom.setRisicoklasse(risicoklasse);
        boom.setUitvoerdatum(uitvoerdatum);
        if (wegtypevrij != null) {
            boom.setWegtype(wegtypevrij);
        } else if (wegtype != null && !wegtype.equals("")) {
            boom.setWegtype(wegtype);
        }
        String opmerkingen = "";
        if (opmerking != null && opmerking.length() > 0) {
            opmerkingen = opmerking.replaceAll("[#|\"*]", " ");
        }
        boom.setOpmerkingen(opmerkingen);
        boom.setExtra1(extra1);
        boom.setExtra2(extra2);
        boom.setExtra3(extra3);
        boom.setExtra4(extra4);
        boom.setExtra5(extra5);
        boom.setExtra6(extra6);
        boom.setExtra7(extra7);
        boom.setExtra8(extra8);
        boom.setExtra9(extra9);
        boom.setExtra10(extra10);
        if (scheefstand) {
            boom.setScheefstand("1");
        } else {
            boom.setScheefstand("0");
        }
        if (scheuren) {
            boom.setScheuren("1");
        } else {
            boom.setScheuren("0");
        }
        if (holten) {
            boom.setHolten("1");
        } else {
            boom.setHolten("0");
        }
        if (stamvoetschade) {
            boom.setStamvoetschade("1");
        } else {
            boom.setStamvoetschade("0");
        }
        if (stamschade) {
            boom.setStamschade("1");
        } else {
            boom.setStamschade("0");
        }
        if (kroonschade) {
            boom.setKroonschade("1");
        } else {
            boom.setKroonschade("0");
        }
        if (inrot) {
            boom.setInrot("1");
        } else {
            boom.setInrot("0");
        }
        if (houtboorder) {
            boom.setHoutboorder("1");
        } else {
            boom.setHoutboorder("0");
        }
        if (zwam) {
            boom.setZwam("1");
        } else {
            boom.setZwam("0");
        }
        if (zwam_stamvoet) {
            boom.setZwam_stamvoet("1");
        } else {
            boom.setZwam_stamvoet("0");
        }
        if (zwam_stam) {
            boom.setZwam_stam("1");
        } else {
            boom.setZwam_stam("0");
        }
        if (zwam_kroon) {
            boom.setZwam_kroon("1");
        } else {
            boom.setZwam_kroon("0");
        }
        if (dood_hout) {
            boom.setDood_hout("1");
        } else {
            boom.setDood_hout("0");
        }
        if (plakoksel) {
            boom.setPlakoksel("1");
        } else {
            boom.setPlakoksel("0");
        }
        if (stamschot) {
            boom.setStamschot("1");
        } else {
            boom.setStamschot("0");
        }
        if (wortelopslag) {
            boom.setWortelopslag("1");
        } else {
            boom.setWortelopslag("0");
        }
        if (takken) {
            boom.setTakken("1");
        } else {
            boom.setTakken("0");
        }
        if (opdruk) {
            boom.setOpdruk("1");
        } else {
            boom.setOpdruk("0");
        }
        if (vta1) {
            boom.setVta1("1");
        } else {
            boom.setVta1("0");
        }
        if (vta2) {
            boom.setVta2("1");
        } else {
            boom.setVta2("0");
        }
        if (vta3) {
            boom.setVta3("1");
        } else {
            boom.setVta3("0");
        }
        if (vta4) {
            boom.setVta4("1");
        } else {
            boom.setVta4("0");
        }
        if (vta5) {
            boom.setVta5("1");
        } else {
            boom.setVta5("0");
        }
        if (vta6) {
            boom.setVta6("1");
        } else {
            boom.setVta6("0");
        }
        if (nader_onderzoek) {
            boom.setNader_onderzoek("1");
        } else {
            boom.setNader_onderzoek("0");
        }
        if (bereikbaarheid) {
            boom.setBereikbaarheid("1");
        } else {
            boom.setBereikbaarheid("0");
        }
        return boom.getBoomsrt() != null && !boom.getBoomsrt().equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWijk(Geometry geom, String projectid) {
        String wijk = "";
        String query = "select project from projectindeling where st_contains(the_geom, st_geometryfromtext('" + geom + "',28992))";
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    wijk = rs.getString(1);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        if (wijk != null && !wijk.equals("")) {
            return wijk;
        }
        return projectid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBoomSoort(String boomlabel) {
        String[] labels = boomlabel.split("'");
        String output = "";
        String query = "select boomsoort from digitree_boomsoorten where ";
        if (labels.length == 1) {
            query = query + "omschrijving = '" + labels[0] + "' ";
        } else {
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] == "") continue;
                query = i == 0 ? query + "omschrijving like '%" + labels[i] + "%' " : query + "and omschrijving like '%" + labels[i] + "%' ";
            }
        }
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    output = rs.getString(1);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getBomen(String boomid) {
        ArrayList bomen = new ArrayList();
        String query = "select id, status from digitree_bomen where boomid = '" + boomid + "'";
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    HashMap<String, String> boom = new HashMap<String, String>();
                    boom.put("id", rs.getString(1));
                    boom.put("status", rs.getString(2));
                    bomen.add(boom);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return bomen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserFullname(String usernaam) {
        String fullname = "";
        String query = "select first_name, surname from users where username ='" + usernaam + "'";
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/kaartenbalie");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    fullname = rs.getString(1) + " " + rs.getString(2);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return fullname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkPK(Boom boom, String table) {
        String uniek = "";
        StringBuilder query = new StringBuilder();
        query.append("SELECT id, projectid, project, boomid FROM ");
        query.append(table);
        query.append(" WHERE projectid = '");
        query.append(boom.getProjectid());
        query.append("' AND boomid = '");
        query.append(boom.getBoomid());
        query.append("'");
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    uniek = rs.getString("id");
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return uniek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWKT(String table, String id) {
        String wkt = "";
        StringBuilder query = new StringBuilder();
        query.append("SELECT upload_rdx, upload_rdy FROM ");
        query.append(table);
        query.append(" WHERE id = ");
        query.append(id);
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    String x = rs.getString("upload_rdx");
                    String y = rs.getString("upload_rdy");
                    wkt = "POINT(" + x + " " + y + ")";
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return wkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(DataStore dataStore2Write, SimpleFeature feature) throws IOException {
        String typename = feature.getFeatureType().getTypeName();
        try (FeatureWriter writer = dataStore2Write.getFeatureWriterAppend(typename, Transaction.AUTO_COMMIT);){
            SimpleFeature newFeature = (SimpleFeature)writer.next();
            for (int i = 0; i < NEW_FIELDS.length; ++i) {
                newFeature.setAttribute(NEW_FIELDS[i], feature.getAttribute(NEW_FIELDS[i]));
            }
            writer.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(String adminPk, DataStore ds, SimpleFeature feature, Integer id) throws IOException, CQLException {
        String typename = feature.getFeatureType().getTypeName();
        Filter f = CQL.toFilter((String)(adminPk + " = '" + id + "'"));
        try (FeatureWriter writer = ds.getFeatureWriter(typename, f, Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                for (int i = 0; i < EDIT_FIELDS.length; ++i) {
                    newFeature.setAttribute(EDIT_FIELDS[i], feature.getAttribute(EDIT_FIELDS[i]));
                }
                writer.write();
            }
        }
    }

    private Map getInstellingenMap(HttpServletRequest request) throws Exception {
        ConfigKeeper configKeeper = new ConfigKeeper();
        String echteRol = request.getParameter("appCode");
        Map map = configKeeper.getConfigMap(echteRol, false);
        if (map == null || map.isEmpty()) {
            map = configKeeper.getConfigMap(null, true);
        }
        return map;
    }

    private void cleanForm(DynaValidatorForm dynaForm) {
        dynaForm.set("id", null);
        dynaForm.set("boomid", (Object)"");
        dynaForm.set("projectid", (Object)"");
        dynaForm.set("project", (Object)"");
        dynaForm.set("plantjaar", null);
        dynaForm.set("mutatiedatum", (Object)"");
        dynaForm.set("mutatietijd", (Object)"");
        dynaForm.set("inspecteur", (Object)"");
        dynaForm.set("aktie", (Object)"");
        dynaForm.set("boomsoort", (Object)"");
        dynaForm.set("boomhoogte", (Object)"");
        dynaForm.set("boomhoogtevrij", (Object)"");
        dynaForm.set("eindbeeldvrij", (Object)"");
        dynaForm.set("eindbeeld", (Object)"");
        dynaForm.set("aantastingenvrij", (Object)"");
        dynaForm.set("aantastingen", (Object)"");
        dynaForm.set("status_zp", (Object)"");
        dynaForm.set("classificatie", (Object)"");
        dynaForm.set("maatregelen_kortvrij", (Object)"");
        dynaForm.set("maatregelen_kort", (Object)"");
        dynaForm.set("maatregelen_langvrij", (Object)"");
        dynaForm.set("maatregelen_lang", (Object)"");
        dynaForm.set("risicoklasse", (Object)"");
        dynaForm.set("uitvoerdatum", (Object)"");
        dynaForm.set("wegtypevrij", (Object)"");
        dynaForm.set("wegtype", (Object)"");
        dynaForm.set("opmerking", (Object)"");
        dynaForm.set("extra1", (Object)"");
        dynaForm.set("extra2", (Object)"");
        dynaForm.set("extra3", (Object)"");
        dynaForm.set("extra4", (Object)"");
        dynaForm.set("extra5", (Object)"");
        dynaForm.set("extra6", (Object)"");
        dynaForm.set("extra7", (Object)"");
        dynaForm.set("extra8", (Object)"");
        dynaForm.set("extra9", (Object)"");
        dynaForm.set("extra10", (Object)"");
        dynaForm.set("scheefstand", (Object)false);
        dynaForm.set("scheuren", (Object)false);
        dynaForm.set("holten", (Object)false);
        dynaForm.set("stamvoetschade", (Object)false);
        dynaForm.set("stamschade", (Object)false);
        dynaForm.set("kroonschade", (Object)false);
        dynaForm.set("inrot", (Object)false);
        dynaForm.set("houtboorder", (Object)false);
        dynaForm.set("zwam", (Object)false);
        dynaForm.set("zwam_stamvoet", (Object)false);
        dynaForm.set("zwam_stam", (Object)false);
        dynaForm.set("zwam_kroon", (Object)false);
        dynaForm.set("dood_hout", (Object)false);
        dynaForm.set("plakoksel", (Object)false);
        dynaForm.set("stamschot", (Object)false);
        dynaForm.set("wortelopslag", (Object)false);
        dynaForm.set("takken", (Object)false);
        dynaForm.set("opdruk", (Object)false);
        dynaForm.set("vta1", (Object)false);
        dynaForm.set("vta2", (Object)false);
        dynaForm.set("vta3", (Object)false);
        dynaForm.set("vta4", (Object)false);
        dynaForm.set("vta5", (Object)false);
        dynaForm.set("vta6", (Object)false);
        dynaForm.set("nader_onderzoek", (Object)false);
        dynaForm.set("bereikbaarheid", (Object)false);
    }
}

