/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.digitree.utils;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.EditUtil;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.geotools.data.DataStore;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.filter.And;
import org.opengis.filter.Filter;

public class EditBoomUtil
extends EditUtil {
    private static final Log log = LogFactory.getLog(EditBoomUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAutoSuggestBoomSoorten(String search) throws JSONException {
        String output = "";
        if (search == null || search.equals("") || search.isEmpty()) {
            return output;
        }
        search.replaceAll("'", "'");
        String query = "select boomsoort, omschrijving from digitree_boomsoorten where UPPER(omschrijving) like UPPER('%" + search + "%') order by omschrijving asc";
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            if (ds == null) {
                String string = output;
                return string;
            }
            conn = ds.getConnection();
            JSONObject json = new JSONObject();
            try (PreparedStatement statement = conn.prepareStatement(query.toString());){
                JSONArray soorten = new JSONArray();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    String boomsoort = rs.getString(1);
                    String omschrijving = rs.getString(2);
                    JSONObject soort = new JSONObject().put("label", (Object)omschrijving).put("value", (Object)boomsoort);
                    soorten.put((Object)soort);
                }
                output = soorten.toString();
            }
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        return output;
    }

    private String[] ListToArray(List<String> values) {
        int size = values.size();
        String[] stringvalues = new String[size];
        int i = 0;
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            String value;
            stringvalues[i] = value = it.next();
            ++i;
        }
        return stringvalues;
    }

    public String getIdAndWktForBoomObject(String wkt, Integer boomGegevensbronId, String schaal, String tol, String appCode) throws Exception {
        ArrayList<Feature> features;
        if (boomGegevensbronId == null || boomGegevensbronId < 0) {
            return "-1";
        }
        String jsonObject = null;
        Geometry geom = DataStoreUtil.createGeomFromWKTString((String)wkt);
        double distance = this.getDistance(schaal, tol);
        if (distance > 0.0) {
            geom = geom.buffer(distance);
        }
        if ((features = this.doQueryRedliningObject(geom, boomGegevensbronId, appCode)) != null && features.size() > 0) {
            Feature f = features.get(0);
            if (features.size() > 1) {
                Property p = f.getProperty("status");
                String status = p.getValue().toString();
                if (status.contains("actueel")) {
                    f = features.get(1);
                }
                log.debug((Object)("Meerdere redline objecten gevonden. Feature met status 'nieuw' gebruikt. Wkt string = " + wkt));
            }
            jsonObject = this.boomfeatureToJson(f).toString();
        }
        if (features == null || features.size() < 1 || jsonObject == null) {
            return "-1";
        }
        return jsonObject;
    }

    private JSONObject boomfeatureToJson(Feature f) throws JSONException {
        String wkt = "";
        if ((f != null || f.getDefaultGeometryProperty() != null) && (wkt = DataStoreUtil.selecteerKaartObjectWkt((Feature)f)).startsWith("ST_MULTI")) {
            int begin = wkt.lastIndexOf("(");
            int end = wkt.indexOf(")");
            wkt = "ST_POINT(" + wkt.substring(begin + 1, end) + ")";
        }
        Date vandaag = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf.applyPattern("dd-MM-yyyy");
        SimpleDateFormat sdf2 = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        sdf2.applyPattern("HH:mm:ss");
        String id = this.getFeatureString(f, "id");
        String project = this.getFeatureString(f, "project");
        String projectid = this.getFeatureString(f, "projectid");
        String boomid = this.getFeatureString(f, "boomid");
        String status = this.getFeatureString(f, "status");
        String mutatiedatum = sdf.format(vandaag);
        String mutatietijd = sdf2.format(vandaag);
        String aktie = this.getFeatureString(f, "aktie");
        String boomsoort = this.getBoomSoortlabel(this.getFeatureString(f, "boomsrt"));
        Integer plantjaar = (Integer)f.getProperty("plantjaar").getValue();
        String boomhoogte = this.getFeatureString(f, "boomhoogte");
        String eindbeeld = this.getFeatureString(f, "eindbeeld");
        String scheefstand = this.getFeatureCheckbox(f, "scheefstand");
        String scheuren = this.getFeatureCheckbox(f, "scheuren");
        String holten = this.getFeatureCheckbox(f, "holten");
        String stamvoetschade = this.getFeatureCheckbox(f, "stamvoetschade");
        String stamschade = this.getFeatureCheckbox(f, "stamschade");
        String kroonschade = this.getFeatureCheckbox(f, "kroonschade");
        String inrot = this.getFeatureCheckbox(f, "inrot");
        String houtboorder = this.getFeatureCheckbox(f, "houtboorder");
        String zwam = this.getFeatureCheckbox(f, "zwam");
        String zwam_stamvoet = this.getFeatureCheckbox(f, "zwam_stamvoet");
        String zwam_stam = this.getFeatureCheckbox(f, "zwam_stam");
        String zwam_kroon = this.getFeatureCheckbox(f, "zwam_kroon");
        String dood_hout = this.getFeatureCheckbox(f, "dood_hout");
        String plakoksel = this.getFeatureCheckbox(f, "plakoksel");
        String stamschot = this.getFeatureCheckbox(f, "stamschot");
        String wortelopslag = this.getFeatureCheckbox(f, "wortelopslag");
        String takken = this.getFeatureCheckbox(f, "takken");
        String opdruk = this.getFeatureCheckbox(f, "opdruk");
        String vta1 = this.getFeatureCheckbox(f, "vta1");
        String vta2 = this.getFeatureCheckbox(f, "vta2");
        String vta3 = this.getFeatureCheckbox(f, "vta3");
        String vta4 = this.getFeatureCheckbox(f, "vta4");
        String vta5 = this.getFeatureCheckbox(f, "vta5");
        String vta6 = this.getFeatureCheckbox(f, "vta6");
        String aantastingen = this.getFeatureString(f, "aantastingen");
        String maatregelen_kort = this.getFeatureString(f, "maatregelen_kort");
        String maatregelen_lang = this.getFeatureString(f, "maatregelen_lang");
        String wegtype = this.getFeatureString(f, "wegtype");
        String bereikbaarheid = this.getFeatureCheckbox(f, "bereikbaarheid");
        String nader_onderzoek = this.getFeatureCheckbox(f, "nader_onderzoek");
        String status_zp = this.getFeatureString(f, "status_zp");
        String classificatie = this.getFeatureString(f, "classificatie");
        String risicoklasse = this.getFeatureString(f, "risicoklasse");
        String uitvoerdatum = this.getFeatureString(f, "uitvoerdatum");
        String opmerkingen = this.getFeatureString(f, "opmerkingen");
        String extra1 = this.getFeatureString(f, "extra1");
        String extra2 = this.getFeatureString(f, "extra2");
        String extra3 = this.getFeatureString(f, "extra3");
        String extra4 = this.getFeatureString(f, "extra4");
        String extra5 = this.getFeatureString(f, "extra5");
        String extra6 = this.getFeatureString(f, "extra6");
        String extra7 = this.getFeatureString(f, "extra7");
        String extra8 = this.getFeatureString(f, "extra8");
        String extra9 = this.getFeatureString(f, "extra9");
        String extra10 = this.getFeatureString(f, "extra10");
        JSONObject json = new JSONObject().put("id", (Object)id).put("project", (Object)project).put("wkt", (Object)wkt).put("projectid", (Object)projectid).put("boomid", (Object)boomid).put("status", (Object)status).put("mutatiedatum", (Object)mutatiedatum).put("mutatietijd", (Object)mutatietijd).put("aktie", (Object)aktie).put("boomsoort", (Object)boomsoort).put("plantjaar", (Object)plantjaar).put("boomhoogte", (Object)boomhoogte).put("eindbeeld", (Object)eindbeeld).put("scheefstand", (Object)scheefstand).put("scheuren", (Object)scheuren).put("holten", (Object)holten).put("stamvoetschade", (Object)stamvoetschade).put("stamschade", (Object)stamschade).put("kroonschade", (Object)kroonschade).put("inrot", (Object)inrot).put("houtboorder", (Object)houtboorder).put("zwam", (Object)zwam).put("zwam_stamvoet", (Object)zwam_stamvoet).put("zwam_stam", (Object)zwam_stam).put("zwam_kroon", (Object)zwam_kroon).put("dood_hout", (Object)dood_hout).put("plakoksel", (Object)plakoksel).put("stamschot", (Object)stamschot).put("wortelopslag", (Object)wortelopslag).put("takken", (Object)takken).put("opdruk", (Object)opdruk).put("vta1", (Object)vta1).put("vta2", (Object)vta2).put("vta3", (Object)vta3).put("vta4", (Object)vta4).put("vta5", (Object)vta5).put("vta6", (Object)vta6).put("aantastingen", (Object)aantastingen).put("maatregelen_kort", (Object)maatregelen_kort).put("maatregelen_lang", (Object)maatregelen_lang).put("wegtype", (Object)wegtype).put("bereikbaarheid", (Object)bereikbaarheid).put("nader_onderzoek", (Object)nader_onderzoek).put("status_zp", (Object)status_zp).put("classificatie", (Object)classificatie).put("risicoklasse", (Object)risicoklasse).put("uitvoerdatum", (Object)uitvoerdatum).put("opmerkingen", (Object)opmerkingen).put("extra1", (Object)extra1).put("extra2", (Object)extra2).put("extra3", (Object)extra3).put("extra4", (Object)extra4).put("extra5", (Object)extra5).put("extra6", (Object)extra6).put("extra7", (Object)extra7).put("extra8", (Object)extra8).put("extra9", (Object)extra9).put("extra10", (Object)extra10);
        return json;
    }

    private String getFeatureString(Feature f, String kolom) {
        String value = "";
        Object newValue = f.getProperty(kolom).getValue();
        if (newValue != null) {
            value = newValue.toString().trim();
        }
        return value;
    }

    private String getFeatureCheckbox(Feature f, String kolom) {
        String value = "";
        String newValue = null;
        if (f.getProperty(kolom).getValue() != null) {
            newValue = f.getProperty(kolom).getValue().toString();
        }
        if (newValue != null && newValue.equals("1")) {
            value = "true";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBoomSoortlabel(String boomsoort) {
        String output = "";
        String query = "select omschrijving from digitree_boomsoorten where boomsoort = '" + boomsoort + "'";
        Connection conn = null;
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup("java:/comp/env/jdbc/gisdata");
            if (ds == null) {
                String string = output;
                return string;
            }
            conn = ds.getConnection();
            try (PreparedStatement statement = conn.prepareStatement(query);){
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    output = rs.getString(1);
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        catch (NamingException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<Feature> doQueryRedliningObject(Geometry geom, Integer gbId, String appCode) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = null;
        DataStore ds = null;
        ArrayList features = null;
        try {
            tx = sess.beginTransaction();
            Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)gbId);
            if (gb == null) {
                ArrayList<Feature> arrayList = new ArrayList<Feature>();
                return arrayList;
            }
            WebContext ctx = WebContextFactory.get();
            HttpServletRequest request = ctx.getHttpServletRequest();
            Bron b = gb.getBron(request);
            if (b == null || b.getType().equals("wfs")) {
                ArrayList<Feature> arrayList = new ArrayList<Feature>();
                return arrayList;
            }
            ds = b.toDatastore();
            List thema_items = SpatialUtil.getThemaData((Gegevensbron)gb, (boolean)false);
            List propnames = DataStoreUtil.themaData2PropertyNames((List)thema_items);
            Principal user = request.getUserPrincipal();
            GisPrincipal gp = (GisPrincipal)user;
            String projectid = gp.getSp().getOrganizationCode();
            Filter project = FilterBuilder.createEqualsFilter((String)"projectid", (String)projectid);
            String[] statusNamen = new String[]{"nieuw", "actueel"};
            Filter status = FilterBuilder.createOrEqualsFilter((String)"status", (String[])statusNamen);
            And f = FilterBuilder.getFactory().and(status, project);
            Integer maximum = ConfigKeeper.getMaxNumberOfFeatures((String)appCode);
            features = DataStoreUtil.getFeatures((Bron)b, (Gegevensbron)gb, (Geometry)geom, (Filter)f, (List)propnames, (Integer)maximum, (boolean)true);
            tx.commit();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens ophalen redlining: ", (Throwable)ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
        return features;
    }

    private double getDistance(String schaal, String tol) {
        String s = schaal;
        double scale = 0.0;
        try {
            if (s != null) {
                scale = Double.parseDouble(s);
                scale = Math.round(scale * 1000000.0);
                scale /= 1000000.0;
            }
        }
        catch (NumberFormatException nfe) {
            scale = 0.0;
            log.debug((Object)"Scale is geen double dus wordt genegeerd");
        }
        String tolerance = tol;
        double clickTolerance = 5.0;
        try {
            if (tolerance != null) {
                clickTolerance = Double.parseDouble(tolerance);
            }
        }
        catch (NumberFormatException nfe) {
            clickTolerance = 5.0;
            log.debug((Object)"Tolerance is geen double dus de default wordt gebruikt: 5.0 pixels");
        }
        double distance = clickTolerance;
        if (scale > 0.0) {
            distance = scale * clickTolerance;
        }
        return distance;
    }

    public static String getProjectId(HttpServletRequest request) {
        Principal user = request.getUserPrincipal();
        GisPrincipal gp = (GisPrincipal)user;
        if (gp == null || gp.getSp() == null) {
            return "";
        }
        return gp.getSp().getOrganizationCode();
    }
}

