package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.TreeRepository;
import nl.b3p.formendpoint.resource.Roadsection;
import nl.b3p.formendpoint.resource.Tree;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class FormTreeController implements FormController<Tree> {

    @Autowired
    TreeRepository repo;

    @Override
    public Class getMaintainingClass() {
        return Tree.class;
    }

    @GetMapping("/boom/{objectGuid}")
    public Tree get(@PathVariable String objectGuid) {
        return repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    @Override
    public Page<Tree> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<Tree> getAll() {
        return repo.findAll();
    }

    @Override
    public Tree save(@RequestBody Tree feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public Tree update(@PathVariable String objectGuid, @RequestBody Tree feature) {
        Tree orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        Tree nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value = "/boom/{x}/{y}/{scale}")
    public List<Tree> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

}
