package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.locationtech.jts.geom.LineString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_vrijvLeiding")
@Schema(
        name = "VrijvLeiding",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FreeFallDuct implements Feature, Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    private LineString geometrie;

    @OneToOne
    @JoinColumn(referencedColumnName = "objectGuid", name = "beginput_id")
    private Well beginput;

    @OneToOne
    @JoinColumn(referencedColumnName = "objectGuid", name = "eindput_id")
    private Well eindput;

    @Schema(name = "object_guid")
    private String objectGuid;

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "vrijv_leiding_id")
    private List<FreeFallDuctPlanning> planningen = new ArrayList<>();

    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String rayon;
    private String status;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private Double afwijkendedieptelegging;
    private String detailverwijzing;
    private String eisvoorzorgsmaatregel;
    private String type_leiding;
    private Double geonauwkeurigheidxy;
    private String materiaal_leiding;
    private String product_leiding;
    private String toelichting;
    private Character verhoogd_risico;
    private Double aantal_buizen;
    private Double diameter;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String categorie;
    private String subcategorie;
    private String strengtype;
    private String std_strengtype;
    private Double aanlegjaar;
    private String functie_vrijv_leiding;
    private String bemalingsgebied;
    private Double bob_begin_actueel;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date datum_bob_begin;
    private Double bob_eind_actueel;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date datum_bob_eind;
    private Double onderhoudjaar;
    private Double knoopnummer_beginput;
    private Double knoopnummer_eindput;
    private String video_inspectie_bestand;
    private String buisvorm;
    private Double lengte;
    private Double breedte;
    private Double hoogte;
    private Double ontv_toelaatbaar_peilst;
    private Double ontv_waterpeil;
    private Character riool_drainage;
    private String grondsoort;
    private String std_grondsoort;
    private String grondwaterstand;
    private String bovenliggende_verharding;
    private Double bob_begin_ontwerp;
    private Double bob_eind_ontwerp;
    private Double sleuf_breedte;
    private Double sleuf_inhoud;
    private String buisverbinding;
    private String std_buisverbinding;
    private String ontgravingsmethode;
    private String stroomgebied;
    private String bestek;
    private String tekening;
    private Double berging;
    private Double verloren_berging;
    private Double spiegelverhang_dwa;
    private Double spiegelverhang_rwa;
    private Double afvoer_dwa;
    private Double afvoer_rwa;
    private Double oppervlak_groen;
    private Double oppervlak_open_wegen;
    private Double oppervlak_gesloten_wegen;
    private Double oppervlak_plat_dak;
    private Double oppervlak_schuin_dak;
    private Double ontw_oppervlak;
    private Double ontw_doorl_grond;
    private Double ontw_hgt_grondwaterstand;
    private String infiltratieriooltype;
    private String std_infiltratieriooltype;
    private Double capaciteit_spoelvoorz;
    private String materiaal_rioolleiding;
    private String std_materiaal_rioolleiding;
    private String funderingstype;
    private String std_funderingstype;
    private String stelseltype;
    private String std_stelseltype;
    private String buistype;
    private String std_buistype;
    private Double buislengte;
    private Character geotextiel_inf_deel;
    private String materiaal_inf_deel;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private Double baa_deformatie;
    private Double bab_scheur;
    private Double bac_breuk_instorting;
    private Double bad_defect_metselwerk;
    private Double bae_ontbrekend_metslspecie;
    private Double baf_oppervlakteschade;
    private Double bag_instekende_inlaat;
    private Double bah_defect_aansluiting;
    private Double bai_indring_afdichtingsmat;
    private Double bai_indring_afdichtingsring;
    private Double bai_indring_ander_afdichting;
    private Double baj_verpl_verbinding;
    private Double baj_axiaal;
    private Double baj_radiaal;
    private Double baj_hoekverdraaiing;
    private Double bak_defect_lining;
    private Double bal_defect_reparatie;
    private Double bam_lasfouten;
    private Double ban_poreuze_buis;
    private Double bba_wortels;
    private Double bbb_aangeh_afzettingen;
    private Double bbc_bezonken_afzettingen;
    private Double bbd_binnendringen_grond;
    private Double bbe_andere_obstakels;
    private Double bbf_infiltratie;
    private Double bdd_waterpeil;
    private String inspectietechniek;
    private String drainagetype;
    private String std_drainagetype;
    private String strengcode;
    private String inspectienaam;
    private String inspectiecode;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String gemeente;
    private String vrijverval_leidingtype;
    private String vrijverval_leidingsubtype;
    private String revisietekening;
    private String verharding_wegdek;
    private Double aantal_aansl_woningen;
    private Double aant_ie_bedrijven;
    private Double aant_ie_recreatie;
    private String strategisch;
    private String grondeigendom;
    private String soort_locatie;
    private Double wandruwheid;
    private Double wandruwheid_bb;
    private Double wandruwheid_bo;
    private String leverancier_fabrikant;
    private String materiaal_gwsw;
    private String vorm;
    private String status_functioneren;
    private Character toegankelijk;
    private String verbindingstype;
    private Double vervuilingsgraad;
    private Double wanddikte;
    private String wion_thema;
    private String sw_gebied_id;
    private String stelsel_id;
    private String kast_id;
    private String x62_cluster_aard;
    private String x62_std_rayon;
    private String x62_std_hoofdcategorie;
    private String x62_std_categorie;
    private String x62_std_subcategorie;
    private String x62_video_inspectie_bestanden;
    private Double x62_waterpeil;
    private Double x62_uniek_nummer;
    private Double x62_stroomsnelheid_dwa;
    private Double x62_stroomsnelheid_rwa;
    private String x62_ledigingspomp_id;
    private String x62_pomptype;
    private String x62_std_pomptype;
    private Double x62_bouwjaar_pomp;
    private Character x62_telemetrie;
    private String x62_spoeltype;
    private String x62_std_spoeltype;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date kl_datum_bob_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date kl_datum_bob_eind;
    private Double x62_aant_aansl_inwoner;
    private Double x62_dikte_lining;
    private String x62_funderingstype_gwsw;
    private String x62_soort_lining;
    private String x62_materiaal_lining;
    private Double reiniging_jaar;
    private Double inspectie_jaar;
    private String kl_rioolkaart_selectie;
    private String kl_extern_bestand;
    private Double reiniging_jaar_2;
    private Double inspectie_jaar_2;
    private String inspectie_bestand;
    private String video_bestand_map;
    private String video_bestand;
    private String kl_herstel_object_guid;
    private String kl_herstel_status;
    private Double bao_grond_zichtbaar;
    private Double bap_ruimte_zichtbaar;
    private String historie_guid;

    @Override
    public List<Feature> getChildren() {
        List<Feature> childs = new ArrayList<>();
        if (beginput != null) {
            childs.add(beginput);
        }

        if (eindput != null) {
            childs.add(eindput);
        }

        if (planningen != null) {
            planningen.forEach(freeFallDuctPlanning -> childs.add(freeFallDuctPlanning));
        }
        return childs;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public LineString getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(LineString geometrie) {
        this.geometrie = geometrie;
    }

    public Well getBeginput() {
        return beginput;
    }

    public void setBeginput(Well beginput) {
        this.beginput = beginput;
    }

    public Well getEindput() {
        return eindput;
    }

    public void setEindput(Well eindput) {
        this.eindput = eindput;
    }

    @Override
    public String getObjectGuid() {
        return objectGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public String getBbv() {
        return bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getRayon() {
        return rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getObject_begin_tijd() {
        return object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public Double getAfwijkendedieptelegging() {
        return afwijkendedieptelegging;
    }

    public void setAfwijkendedieptelegging(Double afwijkendedieptelegging) {
        this.afwijkendedieptelegging = afwijkendedieptelegging;
    }

    public String getDetailverwijzing() {
        return detailverwijzing;
    }

    public void setDetailverwijzing(String detailverwijzing) {
        this.detailverwijzing = detailverwijzing;
    }

    public String getEisvoorzorgsmaatregel() {
        return eisvoorzorgsmaatregel;
    }

    public void setEisvoorzorgsmaatregel(String eisvoorzorgsmaatregel) {
        this.eisvoorzorgsmaatregel = eisvoorzorgsmaatregel;
    }

    public String getType_leiding() {
        return type_leiding;
    }

    public void setType_leiding(String type_leiding) {
        this.type_leiding = type_leiding;
    }

    public Double getGeonauwkeurigheidxy() {
        return geonauwkeurigheidxy;
    }

    public void setGeonauwkeurigheidxy(Double geonauwkeurigheidxy) {
        this.geonauwkeurigheidxy = geonauwkeurigheidxy;
    }

    public String getMateriaal_leiding() {
        return materiaal_leiding;
    }

    public void setMateriaal_leiding(String materiaal_leiding) {
        this.materiaal_leiding = materiaal_leiding;
    }

    public String getProduct_leiding() {
        return product_leiding;
    }

    public void setProduct_leiding(String product_leiding) {
        this.product_leiding = product_leiding;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public Character getVerhoogd_risico() {
        return verhoogd_risico;
    }

    public void setVerhoogd_risico(Character verhoogd_risico) {
        this.verhoogd_risico = verhoogd_risico;
    }

    public Double getAantal_buizen() {
        return aantal_buizen;
    }

    public void setAantal_buizen(Double aantal_buizen) {
        this.aantal_buizen = aantal_buizen;
    }

    public Double getDiameter() {
        return diameter;
    }

    public void setDiameter(Double diameter) {
        this.diameter = diameter;
    }

    public Date getBegin_tijd() {
        return begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getStrengtype() {
        return strengtype;
    }

    public void setStrengtype(String strengtype) {
        this.strengtype = strengtype;
    }

    public String getStd_strengtype() {
        return std_strengtype;
    }

    public void setStd_strengtype(String std_strengtype) {
        this.std_strengtype = std_strengtype;
    }

    public Double getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Double aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public String getFunctie_vrijv_leiding() {
        return functie_vrijv_leiding;
    }

    public void setFunctie_vrijv_leiding(String functie_vrijv_leiding) {
        this.functie_vrijv_leiding = functie_vrijv_leiding;
    }

    public String getBemalingsgebied() {
        return bemalingsgebied;
    }

    public void setBemalingsgebied(String bemalingsgebied) {
        this.bemalingsgebied = bemalingsgebied;
    }

    public Double getBob_begin_actueel() {
        return bob_begin_actueel;
    }

    public void setBob_begin_actueel(Double bob_begin_actueel) {
        this.bob_begin_actueel = bob_begin_actueel;
    }

    public Date getDatum_bob_begin() {
        return datum_bob_begin;
    }

    public void setDatum_bob_begin(Date datum_bob_begin) {
        this.datum_bob_begin = datum_bob_begin;
    }

    public Double getBob_eind_actueel() {
        return bob_eind_actueel;
    }

    public void setBob_eind_actueel(Double bob_eind_actueel) {
        this.bob_eind_actueel = bob_eind_actueel;
    }

    public Date getDatum_bob_eind() {
        return datum_bob_eind;
    }

    public void setDatum_bob_eind(Date datum_bob_eind) {
        this.datum_bob_eind = datum_bob_eind;
    }

    public Double getOnderhoudjaar() {
        return onderhoudjaar;
    }

    public void setOnderhoudjaar(Double onderhoudjaar) {
        this.onderhoudjaar = onderhoudjaar;
    }

    public Double getKnoopnummer_beginput() {
        return knoopnummer_beginput;
    }

    public void setKnoopnummer_beginput(Double knoopnummer_beginput) {
        this.knoopnummer_beginput = knoopnummer_beginput;
    }

    public Double getKnoopnummer_eindput() {
        return knoopnummer_eindput;
    }

    public void setKnoopnummer_eindput(Double knoopnummer_eindput) {
        this.knoopnummer_eindput = knoopnummer_eindput;
    }

    public String getVideo_inspectie_bestand() {
        return video_inspectie_bestand;
    }

    public void setVideo_inspectie_bestand(String video_inspectie_bestand) {
        this.video_inspectie_bestand = video_inspectie_bestand;
    }

    public String getBuisvorm() {
        return buisvorm;
    }

    public void setBuisvorm(String buisvorm) {
        this.buisvorm = buisvorm;
    }

    public Double getLengte() {
        return lengte;
    }

    public void setLengte(Double lengte) {
        this.lengte = lengte;
    }

    public Double getBreedte() {
        return breedte;
    }

    public void setBreedte(Double breedte) {
        this.breedte = breedte;
    }

    public Double getHoogte() {
        return hoogte;
    }

    public void setHoogte(Double hoogte) {
        this.hoogte = hoogte;
    }

    public Double getOntv_toelaatbaar_peilst() {
        return ontv_toelaatbaar_peilst;
    }

    public void setOntv_toelaatbaar_peilst(Double ontv_toelaatbaar_peilst) {
        this.ontv_toelaatbaar_peilst = ontv_toelaatbaar_peilst;
    }

    public Double getOntv_waterpeil() {
        return ontv_waterpeil;
    }

    public void setOntv_waterpeil(Double ontv_waterpeil) {
        this.ontv_waterpeil = ontv_waterpeil;
    }

    public Character getRiool_drainage() {
        return riool_drainage;
    }

    public void setRiool_drainage(Character riool_drainage) {
        this.riool_drainage = riool_drainage;
    }

    public String getGrondsoort() {
        return grondsoort;
    }

    public void setGrondsoort(String grondsoort) {
        this.grondsoort = grondsoort;
    }

    public String getStd_grondsoort() {
        return std_grondsoort;
    }

    public void setStd_grondsoort(String std_grondsoort) {
        this.std_grondsoort = std_grondsoort;
    }

    public String getGrondwaterstand() {
        return grondwaterstand;
    }

    public void setGrondwaterstand(String grondwaterstand) {
        this.grondwaterstand = grondwaterstand;
    }

    public String getBovenliggende_verharding() {
        return bovenliggende_verharding;
    }

    public void setBovenliggende_verharding(String bovenliggende_verharding) {
        this.bovenliggende_verharding = bovenliggende_verharding;
    }

    public Double getBob_begin_ontwerp() {
        return bob_begin_ontwerp;
    }

    public void setBob_begin_ontwerp(Double bob_begin_ontwerp) {
        this.bob_begin_ontwerp = bob_begin_ontwerp;
    }

    public Double getBob_eind_ontwerp() {
        return bob_eind_ontwerp;
    }

    public void setBob_eind_ontwerp(Double bob_eind_ontwerp) {
        this.bob_eind_ontwerp = bob_eind_ontwerp;
    }

    public Double getSleuf_breedte() {
        return sleuf_breedte;
    }

    public void setSleuf_breedte(Double sleuf_breedte) {
        this.sleuf_breedte = sleuf_breedte;
    }

    public Double getSleuf_inhoud() {
        return sleuf_inhoud;
    }

    public void setSleuf_inhoud(Double sleuf_inhoud) {
        this.sleuf_inhoud = sleuf_inhoud;
    }

    public String getBuisverbinding() {
        return buisverbinding;
    }

    public void setBuisverbinding(String buisverbinding) {
        this.buisverbinding = buisverbinding;
    }

    public String getStd_buisverbinding() {
        return std_buisverbinding;
    }

    public void setStd_buisverbinding(String std_buisverbinding) {
        this.std_buisverbinding = std_buisverbinding;
    }

    public String getOntgravingsmethode() {
        return ontgravingsmethode;
    }

    public void setOntgravingsmethode(String ontgravingsmethode) {
        this.ontgravingsmethode = ontgravingsmethode;
    }

    public String getStroomgebied() {
        return stroomgebied;
    }

    public void setStroomgebied(String stroomgebied) {
        this.stroomgebied = stroomgebied;
    }

    public String getBestek() {
        return bestek;
    }

    public void setBestek(String bestek) {
        this.bestek = bestek;
    }

    public String getTekening() {
        return tekening;
    }

    public void setTekening(String tekening) {
        this.tekening = tekening;
    }

    public Double getBerging() {
        return berging;
    }

    public void setBerging(Double berging) {
        this.berging = berging;
    }

    public Double getVerloren_berging() {
        return verloren_berging;
    }

    public void setVerloren_berging(Double verloren_berging) {
        this.verloren_berging = verloren_berging;
    }

    public Double getSpiegelverhang_dwa() {
        return spiegelverhang_dwa;
    }

    public void setSpiegelverhang_dwa(Double spiegelverhang_dwa) {
        this.spiegelverhang_dwa = spiegelverhang_dwa;
    }

    public Double getSpiegelverhang_rwa() {
        return spiegelverhang_rwa;
    }

    public void setSpiegelverhang_rwa(Double spiegelverhang_rwa) {
        this.spiegelverhang_rwa = spiegelverhang_rwa;
    }

    public Double getAfvoer_dwa() {
        return afvoer_dwa;
    }

    public void setAfvoer_dwa(Double afvoer_dwa) {
        this.afvoer_dwa = afvoer_dwa;
    }

    public Double getAfvoer_rwa() {
        return afvoer_rwa;
    }

    public void setAfvoer_rwa(Double afvoer_rwa) {
        this.afvoer_rwa = afvoer_rwa;
    }

    public Double getOppervlak_groen() {
        return oppervlak_groen;
    }

    public void setOppervlak_groen(Double oppervlak_groen) {
        this.oppervlak_groen = oppervlak_groen;
    }

    public Double getOppervlak_open_wegen() {
        return oppervlak_open_wegen;
    }

    public void setOppervlak_open_wegen(Double oppervlak_open_wegen) {
        this.oppervlak_open_wegen = oppervlak_open_wegen;
    }

    public Double getOppervlak_gesloten_wegen() {
        return oppervlak_gesloten_wegen;
    }

    public void setOppervlak_gesloten_wegen(Double oppervlak_gesloten_wegen) {
        this.oppervlak_gesloten_wegen = oppervlak_gesloten_wegen;
    }

    public Double getOppervlak_plat_dak() {
        return oppervlak_plat_dak;
    }

    public void setOppervlak_plat_dak(Double oppervlak_plat_dak) {
        this.oppervlak_plat_dak = oppervlak_plat_dak;
    }

    public Double getOppervlak_schuin_dak() {
        return oppervlak_schuin_dak;
    }

    public void setOppervlak_schuin_dak(Double oppervlak_schuin_dak) {
        this.oppervlak_schuin_dak = oppervlak_schuin_dak;
    }

    public Double getOntw_oppervlak() {
        return ontw_oppervlak;
    }

    public void setOntw_oppervlak(Double ontw_oppervlak) {
        this.ontw_oppervlak = ontw_oppervlak;
    }

    public Double getOntw_doorl_grond() {
        return ontw_doorl_grond;
    }

    public void setOntw_doorl_grond(Double ontw_doorl_grond) {
        this.ontw_doorl_grond = ontw_doorl_grond;
    }

    public Double getOntw_hgt_grondwaterstand() {
        return ontw_hgt_grondwaterstand;
    }

    public void setOntw_hgt_grondwaterstand(Double ontw_hgt_grondwaterstand) {
        this.ontw_hgt_grondwaterstand = ontw_hgt_grondwaterstand;
    }

    public String getInfiltratieriooltype() {
        return infiltratieriooltype;
    }

    public void setInfiltratieriooltype(String infiltratieriooltype) {
        this.infiltratieriooltype = infiltratieriooltype;
    }

    public String getStd_infiltratieriooltype() {
        return std_infiltratieriooltype;
    }

    public void setStd_infiltratieriooltype(String std_infiltratieriooltype) {
        this.std_infiltratieriooltype = std_infiltratieriooltype;
    }

    public Double getCapaciteit_spoelvoorz() {
        return capaciteit_spoelvoorz;
    }

    public void setCapaciteit_spoelvoorz(Double capaciteit_spoelvoorz) {
        this.capaciteit_spoelvoorz = capaciteit_spoelvoorz;
    }

    public String getMateriaal_rioolleiding() {
        return materiaal_rioolleiding;
    }

    public void setMateriaal_rioolleiding(String materiaal_rioolleiding) {
        this.materiaal_rioolleiding = materiaal_rioolleiding;
    }

    public String getStd_materiaal_rioolleiding() {
        return std_materiaal_rioolleiding;
    }

    public void setStd_materiaal_rioolleiding(String std_materiaal_rioolleiding) {
        this.std_materiaal_rioolleiding = std_materiaal_rioolleiding;
    }

    public String getFunderingstype() {
        return funderingstype;
    }

    public void setFunderingstype(String funderingstype) {
        this.funderingstype = funderingstype;
    }

    public String getStd_funderingstype() {
        return std_funderingstype;
    }

    public void setStd_funderingstype(String std_funderingstype) {
        this.std_funderingstype = std_funderingstype;
    }

    public String getStelseltype() {
        return stelseltype;
    }

    public void setStelseltype(String stelseltype) {
        this.stelseltype = stelseltype;
    }

    public String getStd_stelseltype() {
        return std_stelseltype;
    }

    public void setStd_stelseltype(String std_stelseltype) {
        this.std_stelseltype = std_stelseltype;
    }

    public String getBuistype() {
        return buistype;
    }

    public void setBuistype(String buistype) {
        this.buistype = buistype;
    }

    public String getStd_buistype() {
        return std_buistype;
    }

    public void setStd_buistype(String std_buistype) {
        this.std_buistype = std_buistype;
    }

    public Double getBuislengte() {
        return buislengte;
    }

    public void setBuislengte(Double buislengte) {
        this.buislengte = buislengte;
    }

    public Character getGeotextiel_inf_deel() {
        return geotextiel_inf_deel;
    }

    public void setGeotextiel_inf_deel(Character geotextiel_inf_deel) {
        this.geotextiel_inf_deel = geotextiel_inf_deel;
    }

    public String getMateriaal_inf_deel() {
        return materiaal_inf_deel;
    }

    public void setMateriaal_inf_deel(String materiaal_inf_deel) {
        this.materiaal_inf_deel = materiaal_inf_deel;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public Double getBaa_deformatie() {
        return baa_deformatie;
    }

    public void setBaa_deformatie(Double baa_deformatie) {
        this.baa_deformatie = baa_deformatie;
    }

    public Double getBab_scheur() {
        return bab_scheur;
    }

    public void setBab_scheur(Double bab_scheur) {
        this.bab_scheur = bab_scheur;
    }

    public Double getBac_breuk_instorting() {
        return bac_breuk_instorting;
    }

    public void setBac_breuk_instorting(Double bac_breuk_instorting) {
        this.bac_breuk_instorting = bac_breuk_instorting;
    }

    public Double getBad_defect_metselwerk() {
        return bad_defect_metselwerk;
    }

    public void setBad_defect_metselwerk(Double bad_defect_metselwerk) {
        this.bad_defect_metselwerk = bad_defect_metselwerk;
    }

    public Double getBae_ontbrekend_metslspecie() {
        return bae_ontbrekend_metslspecie;
    }

    public void setBae_ontbrekend_metslspecie(Double bae_ontbrekend_metslspecie) {
        this.bae_ontbrekend_metslspecie = bae_ontbrekend_metslspecie;
    }

    public Double getBaf_oppervlakteschade() {
        return baf_oppervlakteschade;
    }

    public void setBaf_oppervlakteschade(Double baf_oppervlakteschade) {
        this.baf_oppervlakteschade = baf_oppervlakteschade;
    }

    public Double getBag_instekende_inlaat() {
        return bag_instekende_inlaat;
    }

    public void setBag_instekende_inlaat(Double bag_instekende_inlaat) {
        this.bag_instekende_inlaat = bag_instekende_inlaat;
    }

    public Double getBah_defect_aansluiting() {
        return bah_defect_aansluiting;
    }

    public void setBah_defect_aansluiting(Double bah_defect_aansluiting) {
        this.bah_defect_aansluiting = bah_defect_aansluiting;
    }

    public Double getBai_indring_afdichtingsmat() {
        return bai_indring_afdichtingsmat;
    }

    public void setBai_indring_afdichtingsmat(Double bai_indring_afdichtingsmat) {
        this.bai_indring_afdichtingsmat = bai_indring_afdichtingsmat;
    }

    public Double getBai_indring_afdichtingsring() {
        return bai_indring_afdichtingsring;
    }

    public void setBai_indring_afdichtingsring(Double bai_indring_afdichtingsring) {
        this.bai_indring_afdichtingsring = bai_indring_afdichtingsring;
    }

    public Double getBai_indring_ander_afdichting() {
        return bai_indring_ander_afdichting;
    }

    public void setBai_indring_ander_afdichting(Double bai_indring_ander_afdichting) {
        this.bai_indring_ander_afdichting = bai_indring_ander_afdichting;
    }

    public Double getBaj_verpl_verbinding() {
        return baj_verpl_verbinding;
    }

    public void setBaj_verpl_verbinding(Double baj_verpl_verbinding) {
        this.baj_verpl_verbinding = baj_verpl_verbinding;
    }

    public Double getBaj_axiaal() {
        return baj_axiaal;
    }

    public void setBaj_axiaal(Double baj_axiaal) {
        this.baj_axiaal = baj_axiaal;
    }

    public Double getBaj_radiaal() {
        return baj_radiaal;
    }

    public void setBaj_radiaal(Double baj_radiaal) {
        this.baj_radiaal = baj_radiaal;
    }

    public Double getBaj_hoekverdraaiing() {
        return baj_hoekverdraaiing;
    }

    public void setBaj_hoekverdraaiing(Double baj_hoekverdraaiing) {
        this.baj_hoekverdraaiing = baj_hoekverdraaiing;
    }

    public Double getBak_defect_lining() {
        return bak_defect_lining;
    }

    public void setBak_defect_lining(Double bak_defect_lining) {
        this.bak_defect_lining = bak_defect_lining;
    }

    public Double getBal_defect_reparatie() {
        return bal_defect_reparatie;
    }

    public void setBal_defect_reparatie(Double bal_defect_reparatie) {
        this.bal_defect_reparatie = bal_defect_reparatie;
    }

    public Double getBam_lasfouten() {
        return bam_lasfouten;
    }

    public void setBam_lasfouten(Double bam_lasfouten) {
        this.bam_lasfouten = bam_lasfouten;
    }

    public Double getBan_poreuze_buis() {
        return ban_poreuze_buis;
    }

    public void setBan_poreuze_buis(Double ban_poreuze_buis) {
        this.ban_poreuze_buis = ban_poreuze_buis;
    }

    public Double getBba_wortels() {
        return bba_wortels;
    }

    public void setBba_wortels(Double bba_wortels) {
        this.bba_wortels = bba_wortels;
    }

    public Double getBbb_aangeh_afzettingen() {
        return bbb_aangeh_afzettingen;
    }

    public void setBbb_aangeh_afzettingen(Double bbb_aangeh_afzettingen) {
        this.bbb_aangeh_afzettingen = bbb_aangeh_afzettingen;
    }

    public Double getBbc_bezonken_afzettingen() {
        return bbc_bezonken_afzettingen;
    }

    public void setBbc_bezonken_afzettingen(Double bbc_bezonken_afzettingen) {
        this.bbc_bezonken_afzettingen = bbc_bezonken_afzettingen;
    }

    public Double getBbd_binnendringen_grond() {
        return bbd_binnendringen_grond;
    }

    public void setBbd_binnendringen_grond(Double bbd_binnendringen_grond) {
        this.bbd_binnendringen_grond = bbd_binnendringen_grond;
    }

    public Double getBbe_andere_obstakels() {
        return bbe_andere_obstakels;
    }

    public void setBbe_andere_obstakels(Double bbe_andere_obstakels) {
        this.bbe_andere_obstakels = bbe_andere_obstakels;
    }

    public Double getBbf_infiltratie() {
        return bbf_infiltratie;
    }

    public void setBbf_infiltratie(Double bbf_infiltratie) {
        this.bbf_infiltratie = bbf_infiltratie;
    }

    public Double getBdd_waterpeil() {
        return bdd_waterpeil;
    }

    public void setBdd_waterpeil(Double bdd_waterpeil) {
        this.bdd_waterpeil = bdd_waterpeil;
    }

    public String getInspectietechniek() {
        return inspectietechniek;
    }

    public void setInspectietechniek(String inspectietechniek) {
        this.inspectietechniek = inspectietechniek;
    }

    public String getDrainagetype() {
        return drainagetype;
    }

    public void setDrainagetype(String drainagetype) {
        this.drainagetype = drainagetype;
    }

    public String getStd_drainagetype() {
        return std_drainagetype;
    }

    public void setStd_drainagetype(String std_drainagetype) {
        this.std_drainagetype = std_drainagetype;
    }

    public String getStrengcode() {
        return strengcode;
    }

    public void setStrengcode(String strengcode) {
        this.strengcode = strengcode;
    }

    public String getInspectienaam() {
        return inspectienaam;
    }

    public void setInspectienaam(String inspectienaam) {
        this.inspectienaam = inspectienaam;
    }

    public String getInspectiecode() {
        return inspectiecode;
    }

    public void setInspectiecode(String inspectiecode) {
        this.inspectiecode = inspectiecode;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getVrijverval_leidingtype() {
        return vrijverval_leidingtype;
    }

    public void setVrijverval_leidingtype(String vrijverval_leidingtype) {
        this.vrijverval_leidingtype = vrijverval_leidingtype;
    }

    public String getVrijverval_leidingsubtype() {
        return vrijverval_leidingsubtype;
    }

    public void setVrijverval_leidingsubtype(String vrijverval_leidingsubtype) {
        this.vrijverval_leidingsubtype = vrijverval_leidingsubtype;
    }

    public String getRevisietekening() {
        return revisietekening;
    }

    public void setRevisietekening(String revisietekening) {
        this.revisietekening = revisietekening;
    }

    public String getVerharding_wegdek() {
        return verharding_wegdek;
    }

    public void setVerharding_wegdek(String verharding_wegdek) {
        this.verharding_wegdek = verharding_wegdek;
    }

    public Double getAantal_aansl_woningen() {
        return aantal_aansl_woningen;
    }

    public void setAantal_aansl_woningen(Double aantal_aansl_woningen) {
        this.aantal_aansl_woningen = aantal_aansl_woningen;
    }

    public Double getAant_ie_bedrijven() {
        return aant_ie_bedrijven;
    }

    public void setAant_ie_bedrijven(Double aant_ie_bedrijven) {
        this.aant_ie_bedrijven = aant_ie_bedrijven;
    }

    public Double getAant_ie_recreatie() {
        return aant_ie_recreatie;
    }

    public void setAant_ie_recreatie(Double aant_ie_recreatie) {
        this.aant_ie_recreatie = aant_ie_recreatie;
    }

    public String getStrategisch() {
        return strategisch;
    }

    public void setStrategisch(String strategisch) {
        this.strategisch = strategisch;
    }

    public String getGrondeigendom() {
        return grondeigendom;
    }

    public void setGrondeigendom(String grondeigendom) {
        this.grondeigendom = grondeigendom;
    }

    public String getSoort_locatie() {
        return soort_locatie;
    }

    public void setSoort_locatie(String soort_locatie) {
        this.soort_locatie = soort_locatie;
    }

    public Double getWandruwheid() {
        return wandruwheid;
    }

    public void setWandruwheid(Double wandruwheid) {
        this.wandruwheid = wandruwheid;
    }

    public Double getWandruwheid_bb() {
        return wandruwheid_bb;
    }

    public void setWandruwheid_bb(Double wandruwheid_bb) {
        this.wandruwheid_bb = wandruwheid_bb;
    }

    public Double getWandruwheid_bo() {
        return wandruwheid_bo;
    }

    public void setWandruwheid_bo(Double wandruwheid_bo) {
        this.wandruwheid_bo = wandruwheid_bo;
    }

    public String getLeverancier_fabrikant() {
        return leverancier_fabrikant;
    }

    public void setLeverancier_fabrikant(String leverancier_fabrikant) {
        this.leverancier_fabrikant = leverancier_fabrikant;
    }

    public String getMateriaal_gwsw() {
        return materiaal_gwsw;
    }

    public void setMateriaal_gwsw(String materiaal_gwsw) {
        this.materiaal_gwsw = materiaal_gwsw;
    }

    public String getVorm() {
        return vorm;
    }

    public void setVorm(String vorm) {
        this.vorm = vorm;
    }

    public String getStatus_functioneren() {
        return status_functioneren;
    }

    public void setStatus_functioneren(String status_functioneren) {
        this.status_functioneren = status_functioneren;
    }

    public Character getToegankelijk() {
        return toegankelijk;
    }

    public void setToegankelijk(Character toegankelijk) {
        this.toegankelijk = toegankelijk;
    }

    public String getVerbindingstype() {
        return verbindingstype;
    }

    public void setVerbindingstype(String verbindingstype) {
        this.verbindingstype = verbindingstype;
    }

    public Double getVervuilingsgraad() {
        return vervuilingsgraad;
    }

    public void setVervuilingsgraad(Double vervuilingsgraad) {
        this.vervuilingsgraad = vervuilingsgraad;
    }

    public Double getWanddikte() {
        return wanddikte;
    }

    public void setWanddikte(Double wanddikte) {
        this.wanddikte = wanddikte;
    }

    public String getWion_thema() {
        return wion_thema;
    }

    public void setWion_thema(String wion_thema) {
        this.wion_thema = wion_thema;
    }

    public String getSw_gebied_id() {
        return sw_gebied_id;
    }

    public void setSw_gebied_id(String sw_gebied_id) {
        this.sw_gebied_id = sw_gebied_id;
    }

    public String getStelsel_id() {
        return stelsel_id;
    }

    public void setStelsel_id(String stelsel_id) {
        this.stelsel_id = stelsel_id;
    }

    public String getKast_id() {
        return kast_id;
    }

    public void setKast_id(String kast_id) {
        this.kast_id = kast_id;
    }

    public String getX62_cluster_aard() {
        return x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getX62_std_rayon() {
        return x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public String getX62_std_hoofdcategorie() {
        return x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getX62_std_categorie() {
        return x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getX62_std_subcategorie() {
        return x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getX62_video_inspectie_bestanden() {
        return x62_video_inspectie_bestanden;
    }

    public void setX62_video_inspectie_bestanden(String x62_video_inspectie_bestanden) {
        this.x62_video_inspectie_bestanden = x62_video_inspectie_bestanden;
    }

    public Double getX62_waterpeil() {
        return x62_waterpeil;
    }

    public void setX62_waterpeil(Double x62_waterpeil) {
        this.x62_waterpeil = x62_waterpeil;
    }

    public Double getX62_uniek_nummer() {
        return x62_uniek_nummer;
    }

    public void setX62_uniek_nummer(Double x62_uniek_nummer) {
        this.x62_uniek_nummer = x62_uniek_nummer;
    }

    public Double getX62_stroomsnelheid_dwa() {
        return x62_stroomsnelheid_dwa;
    }

    public void setX62_stroomsnelheid_dwa(Double x62_stroomsnelheid_dwa) {
        this.x62_stroomsnelheid_dwa = x62_stroomsnelheid_dwa;
    }

    public Double getX62_stroomsnelheid_rwa() {
        return x62_stroomsnelheid_rwa;
    }

    public void setX62_stroomsnelheid_rwa(Double x62_stroomsnelheid_rwa) {
        this.x62_stroomsnelheid_rwa = x62_stroomsnelheid_rwa;
    }

    public String getX62_ledigingspomp_id() {
        return x62_ledigingspomp_id;
    }

    public void setX62_ledigingspomp_id(String x62_ledigingspomp_id) {
        this.x62_ledigingspomp_id = x62_ledigingspomp_id;
    }

    public String getX62_pomptype() {
        return x62_pomptype;
    }

    public void setX62_pomptype(String x62_pomptype) {
        this.x62_pomptype = x62_pomptype;
    }

    public String getX62_std_pomptype() {
        return x62_std_pomptype;
    }

    public void setX62_std_pomptype(String x62_std_pomptype) {
        this.x62_std_pomptype = x62_std_pomptype;
    }

    public Double getX62_bouwjaar_pomp() {
        return x62_bouwjaar_pomp;
    }

    public void setX62_bouwjaar_pomp(Double x62_bouwjaar_pomp) {
        this.x62_bouwjaar_pomp = x62_bouwjaar_pomp;
    }

    public Character getX62_telemetrie() {
        return x62_telemetrie;
    }

    public void setX62_telemetrie(Character x62_telemetrie) {
        this.x62_telemetrie = x62_telemetrie;
    }

    public String getX62_spoeltype() {
        return x62_spoeltype;
    }

    public void setX62_spoeltype(String x62_spoeltype) {
        this.x62_spoeltype = x62_spoeltype;
    }

    public String getX62_std_spoeltype() {
        return x62_std_spoeltype;
    }

    public void setX62_std_spoeltype(String x62_std_spoeltype) {
        this.x62_std_spoeltype = x62_std_spoeltype;
    }

    public Date getKl_datum_bob_begin() {
        return kl_datum_bob_begin;
    }

    public void setKl_datum_bob_begin(Date kl_datum_bob_begin) {
        this.kl_datum_bob_begin = kl_datum_bob_begin;
    }

    public Date getKl_datum_bob_eind() {
        return kl_datum_bob_eind;
    }

    public void setKl_datum_bob_eind(Date kl_datum_bob_eind) {
        this.kl_datum_bob_eind = kl_datum_bob_eind;
    }

    public Double getX62_aant_aansl_inwoner() {
        return x62_aant_aansl_inwoner;
    }

    public void setX62_aant_aansl_inwoner(Double x62_aant_aansl_inwoner) {
        this.x62_aant_aansl_inwoner = x62_aant_aansl_inwoner;
    }

    public Double getX62_dikte_lining() {
        return x62_dikte_lining;
    }

    public void setX62_dikte_lining(Double x62_dikte_lining) {
        this.x62_dikte_lining = x62_dikte_lining;
    }

    public String getX62_funderingstype_gwsw() {
        return x62_funderingstype_gwsw;
    }

    public void setX62_funderingstype_gwsw(String x62_funderingstype_gwsw) {
        this.x62_funderingstype_gwsw = x62_funderingstype_gwsw;
    }

    public String getX62_soort_lining() {
        return x62_soort_lining;
    }

    public void setX62_soort_lining(String x62_soort_lining) {
        this.x62_soort_lining = x62_soort_lining;
    }

    public String getX62_materiaal_lining() {
        return x62_materiaal_lining;
    }

    public void setX62_materiaal_lining(String x62_materiaal_lining) {
        this.x62_materiaal_lining = x62_materiaal_lining;
    }

    public Double getReiniging_jaar() {
        return reiniging_jaar;
    }

    public void setReiniging_jaar(Double reiniging_jaar) {
        this.reiniging_jaar = reiniging_jaar;
    }

    public Double getInspectie_jaar() {
        return inspectie_jaar;
    }

    public void setInspectie_jaar(Double inspectie_jaar) {
        this.inspectie_jaar = inspectie_jaar;
    }

    public String getKl_rioolkaart_selectie() {
        return kl_rioolkaart_selectie;
    }

    public void setKl_rioolkaart_selectie(String kl_rioolkaart_selectie) {
        this.kl_rioolkaart_selectie = kl_rioolkaart_selectie;
    }

    public String getKl_extern_bestand() {
        return kl_extern_bestand;
    }

    public void setKl_extern_bestand(String kl_extern_bestand) {
        this.kl_extern_bestand = kl_extern_bestand;
    }

    public Double getReiniging_jaar_2() {
        return reiniging_jaar_2;
    }

    public void setReiniging_jaar_2(Double reiniging_jaar_2) {
        this.reiniging_jaar_2 = reiniging_jaar_2;
    }

    public Double getInspectie_jaar_2() {
        return inspectie_jaar_2;
    }

    public void setInspectie_jaar_2(Double inspectie_jaar_2) {
        this.inspectie_jaar_2 = inspectie_jaar_2;
    }

    public String getInspectie_bestand() {
        return inspectie_bestand;
    }

    public void setInspectie_bestand(String inspectie_bestand) {
        this.inspectie_bestand = inspectie_bestand;
    }

    public String getVideo_bestand_map() {
        return video_bestand_map;
    }

    public void setVideo_bestand_map(String video_bestand_map) {
        this.video_bestand_map = video_bestand_map;
    }

    public String getVideo_bestand() {
        return video_bestand;
    }

    public void setVideo_bestand(String video_bestand) {
        this.video_bestand = video_bestand;
    }

    public String getKl_herstel_object_guid() {
        return kl_herstel_object_guid;
    }

    public void setKl_herstel_object_guid(String kl_herstel_object_guid) {
        this.kl_herstel_object_guid = kl_herstel_object_guid;
    }

    public String getKl_herstel_status() {
        return kl_herstel_status;
    }

    public void setKl_herstel_status(String kl_herstel_status) {
        this.kl_herstel_status = kl_herstel_status;
    }

    public Double getBao_grond_zichtbaar() {
        return bao_grond_zichtbaar;
    }

    public void setBao_grond_zichtbaar(Double bao_grond_zichtbaar) {
        this.bao_grond_zichtbaar = bao_grond_zichtbaar;
    }

    public Double getBap_ruimte_zichtbaar() {
        return bap_ruimte_zichtbaar;
    }

    public void setBap_ruimte_zichtbaar(Double bap_ruimte_zichtbaar) {
        this.bap_ruimte_zichtbaar = bap_ruimte_zichtbaar;
    }

    public String getHistorie_guid() {
        return historie_guid;
    }

    public void setHistorie_guid(String historie_guid) {
        this.historie_guid = historie_guid;
    }
}
