/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.GrassRepository;
import nl.b3p.formendpoint.resource.Grass;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormGrassController
implements FormController<Grass> {
    @Autowired
    GrassRepository repo;

    public Class getMaintainingClass() {
        return Grass.class;
    }

    @GetMapping(value={"/gras/{objectGuid}"})
    public Grass get(@PathVariable String objectGuid) {
        return (Grass)this.repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    public Page<Grass> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<Grass> getAll() {
        return this.repo.findAll();
    }

    public Grass save(@RequestBody Grass feature, String parentId) {
        return (Grass)this.repo.save((Object)feature);
    }

    public Grass update(@PathVariable String objectGuid, @RequestBody Grass feature) {
        Grass orig = (Grass)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig);
        Grass nieuw = (Grass)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value={"/gras/{x}/{y}/{scale}"})
    public List<Grass> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

