package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.RoadinspectionRepository;
import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.repository.TreeInspectionRepository;
import nl.b3p.formendpoint.repository.TreeRepository;
import nl.b3p.formendpoint.resource.Tree;
import nl.b3p.formendpoint.resource.TreeInspection;
import nl.b3p.formendpoint.resource.Roadsection;
import nl.b3p.formendpoint.resource.TreeInspection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("boominspectie")
public class FormTreeInspectionController implements FormController<TreeInspection>{

    @Autowired
    TreeInspectionRepository repo;

    @Autowired
    TreeRepository treeRepo;

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping("/{objectGuid}")
    public TreeInspection get(@PathVariable String objectGuid) {
        return repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
    }

    @Override
    public List<TreeInspection> onPoint(double x, double y, double scale) {
        return new ArrayList<>();
    }

    @Override
    @GetMapping
    public Page<TreeInspection> getAllPaged(Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping("/unpaged")
    public List<TreeInspection> getAll() {
        return repo.findAll();
    }

    @PostMapping
    public TreeInspection save(@RequestBody TreeInspection wv, String parentId){
        Tree parent = treeRepo.findByObjectGuid(parentId).orElseThrow( () -> new IllegalArgumentException("Parent niet gevonden"));;
        wv.setBoom_id(parent.getObjectGuid());
        return repo.save(wv);
    }

    @PutMapping("/{objectGuid}")
    public TreeInspection update(@PathVariable  String objectGuid, @RequestBody TreeInspection wv){
        TreeInspection orig=  repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig);
        TreeInspection nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByDataGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return TreeInspection.class;
    }
}
