package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.Gbi_kw_planning_nen_totRepository;
import nl.b3p.formendpoint.resource.Gbikwplanningnentot;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
@RestController
public class Gbi_kw_planning_nen_totController implements FormController<Gbikwplanningnentot> {

    @Autowired
    Gbi_kw_planning_nen_totRepository repo;

    @Override
    public Class getMaintainingClass() {
        return Gbikwplanningnentot.class;
    }

    @GetMapping("/gbi_kw_planning_nen_tot/{objectGuid}")
    public Gbikwplanningnentot get(@PathVariable String objectGuid) {
        return repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    @Override
    public Page<Gbikwplanningnentot> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<Gbikwplanningnentot> getAll() {
        return repo.findAll();
    }

    @Override
    public Gbikwplanningnentot save(@RequestBody Gbikwplanningnentot feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public Gbikwplanningnentot update(@PathVariable String id, @RequestBody Gbikwplanningnentot feature) {
        Gbikwplanningnentot orig=  repo.findById(Long.parseLong(id)).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        Gbikwplanningnentot nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String id) {
        repo.deleteById(Long.parseLong(id));
    }

    @GetMapping(value = "/gbi_kw_planning_nen_tot/{x}/{y}/{scale}")
    public List<Gbikwplanningnentot> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }


}
