package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Roadsection;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface RoadsectionRepository extends JpaRepository<Roadsection, Long> {

    Optional<Roadsection> findByObjectGuid(String object_guid);

    Optional<Roadsection> findById(Long id);

    void deleteByObjectGuid(String object_guid);

    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Roadsection> findWithinPoint(Geometry area);

}
