package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "objecttype")
@JsonSubTypes({
        @JsonSubTypes.Type(value = ArtificialWork.class, name = "Kunstwerk"),
        @JsonSubTypes.Type(value = ArtificialWorkPart.class, name = "Kunstwerkdeel"),
        @JsonSubTypes.Type(value = ArtificialWorkPartPlanning.class, name = "KunstwerkdeelPlanning"),
        @JsonSubTypes.Type(value = ArtificialWorkPlanning.class, name = "KunstwerkPlanning"),
        @JsonSubTypes.Type(value = CultPlanting.class, name = "CultBeplanting"),
        @JsonSubTypes.Type(value = CultPlantingPlanning.class, name = "CultBeplantingPlanning"),
        @JsonSubTypes.Type(value = FreeFallDuct.class, name = "Vrijvleiding"),
        @JsonSubTypes.Type(value = FreeFallDuctPlanning.class, name = "VrijvLeidingPlanning"),
        @JsonSubTypes.Type(value = Grass.class, name = "Gras"),
        @JsonSubTypes.Type(value = GrassPlanning.class, name = "GrasPlanning"),
        @JsonSubTypes.Type(value = Gbikwplanningnentot.class, name = "ikwplanningnentot"),
        @JsonSubTypes.Type(value = Hedge.class, name = "Haag"),
        @JsonSubTypes.Type(value = HedgePlanning.class, name = "HaagPlanning"),
        @JsonSubTypes.Type(value = IMBORTree.class, name = "IMBORBoom"),
        @JsonSubTypes.Type(value = IMBORGreenObject.class, name = "IMBORGroenobject"),
        @JsonSubTypes.Type(value = IMBORHardeningObject.class, name = "IMBORVerhardingsobject"),
        @JsonSubTypes.Type(value = MechanicalDuct.class, name = "Mechleiding"),
        @JsonSubTypes.Type(value = MechanicalDuctPlanning.class, name = "MechLeidingPlanning"),
        @JsonSubTypes.Type(value = NatPlanting.class, name = "NatBeplanting"),
        @JsonSubTypes.Type(value = NatPlantingPlanning.class, name = "NatBeplantingPlanning"),
        @JsonSubTypes.Type(value = Planter.class, name = "Plantenbak"),
        @JsonSubTypes.Type(value = PlanterPlanning.class, name = "PlantenbakPlanning"),
        @JsonSubTypes.Type(value = Roadsection.class, name = "Wegvakonderdeel"),
        @JsonSubTypes.Type(value = RoadsectionPlanning.class, name = "Wegvakonderdeelplanning"),
        @JsonSubTypes.Type(value = RoadInspection.class, name = "Weginspectie"),
        @JsonSubTypes.Type(value = Tree.class, name = "Boom"),
        @JsonSubTypes.Type(value = TreePlanning.class, name = "Boomplanning"),
        @JsonSubTypes.Type(value = TreeInspection.class, name = "Boominspectie"),
        @JsonSubTypes.Type(value = TreeSupport.class, name = "Boomonderhoud"),
        @JsonSubTypes.Type(value = WellPlanning.class, name = "RioolputPlanning"),
        @JsonSubTypes.Type(value = WellInspection.class, name = "RioolputInspectie"),
        @JsonSubTypes.Type(value = Well.class, name = "Rioolput"),
})
public interface Feature {
    
    String clazz = null;

    @JsonIgnore
    @JsonProperty("children")
    List<Feature> children = new ArrayList<>();

    default String getClazz(){
        return this.getClass().getAnnotation(Schema.class).name().toLowerCase();
    }

    String getObjectGuid();

    void setObjectGuid(String objectGuid);


    default List<Feature> getChildren(){
        return children;
    }
}
