package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.ColumnTransformer;
import org.locationtech.jts.geom.Geometry;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Entity(name = "gbi_kw_planning_nen_tot")
@Schema(
        name = "ikwplanningnentot",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Gbikwplanningnentot implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    private Integer kw_id;
    private String kw_guid;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    @ColumnTransformer(
            read = "st_curvetoline(geometrie)"
    )
    private Geometry geometrie;
    private String kunstwerknaam;
    private String uniek_nummer;
    private String complex_kunstwerk;
    private String kunstwerktype;
    private String std_kunstwerktype;
    private Integer oppervlakte_kunstwerk;
    private Integer breedte_kunstwerk;
    private Integer lengte_kunstwerk;
    private Integer lengte_gesloten;
    private Integer doorvaarbreedte;
    private Integer doorvaarhoogte;
    private Integer doorrijbreedte;
    private Integer doorrijhoogte;
    private Integer aantal_overspanningen;
    private String alg_onderhoudsstaat;
    private String beheerder;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String hoofdcategorie;
    private String std_hoofdcategorie;
    private String categorie;
    private String std_categorie;
    private String subcategorie;
    private String std_subcategorie;
    private String prioriteit;
    private String belastingklasse;
    private String afbeelding;
    private String conditie;
    private String verzorging;
    private String beheerobjecttype;
    private String inspectierapport;

    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private String toelichting;
    private String gebruiksfunctie_kunstw;
    private String wet_monumentaal_status;
    private Integer aanlegjaar;
    private Integer kerende_hoogte_bovenwater;
    private Integer kerende_hoogte_onderwater;
    private Integer doorstroomoppervlak;
    private Integer maximale_overspanningen;
    private Integer elem_id;
    private String elem_guid;
    private String elem_afbeelding;
    private String elem_conditie;
    private String elem_verzorging;
    private String element_type;
    private Integer elem_hoeveelheid;
    private String elem_materiaal;
    private String elem_toelichting;
    private Integer bd_id;
    private String bd_guid;
    private String bd_afbeelding;
    private String bd_bouwdeeltype;
    private String bd_conditie;
    private String bd_verzorging;
    private String bd_eenheid;
    private Integer bd_hoeveelheid;
    private String bd_materiaal;
    private String bd_toelichting;
    private Integer maatregel_id;
    private String maatregel_guid;
    private String gebrek_of_planning;
    private String maatregel;
    private String maatregeltype;
    private Integer jaarvanuitvoering;
    private Integer hoev_planning;
    private Integer kosten;
    private String planstatus;
    private String gebrek;
    private String belang_gebrek;
    private String intensiteit_gebrek;
    private String omvang_gebrek;
    private String conditie_gebrek;
    private String verzorging_gebrek;
    private String reliability_gebrek;
    private String availability_gebrek;
    private String maintainability_gebrek;
    private String safety_gebrek;
    private String memo_gebrek;
    private String afbeelding_gebrek;
    private String afbeelding_detail_gebrek;
    private Integer cyclus;
    private String kl_correctiefactor;
    private String health_gebrek;
    private String environment_gebrek;
    private String economics_gebrek;
    private String politics_gebrek;
    private Boolean verversen;
    private String kl_inspectierapport;

    @Schema(name = "object_guid")
    private String objectGuid;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getKw_id() {
        return kw_id;
    }

    public void setKw_id(Integer kw_id) {
        this.kw_id = kw_id;
    }

    public String getKw_guid() {
        return kw_guid;
    }

    public void setKw_guid(String kw_guid) {
        this.kw_guid = kw_guid;
    }

    public Geometry getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Geometry geometrie) {
        this.geometrie = geometrie;
    }

    public String getKunstwerknaam() {
        return kunstwerknaam;
    }

    public void setKunstwerknaam(String kunstwerknaam) {
        this.kunstwerknaam = kunstwerknaam;
    }

    public String getUniek_nummer() {
        return uniek_nummer;
    }

    public void setUniek_nummer(String uniek_nummer) {
        this.uniek_nummer = uniek_nummer;
    }

    public String getComplex_kunstwerk() {
        return complex_kunstwerk;
    }

    public void setComplex_kunstwerk(String complex_kunstwerk) {
        this.complex_kunstwerk = complex_kunstwerk;
    }

    public String getKunstwerktype() {
        return kunstwerktype;
    }

    public void setKunstwerktype(String kunstwerktype) {
        this.kunstwerktype = kunstwerktype;
    }

    public String getStd_kunstwerktype() {
        return std_kunstwerktype;
    }

    public void setStd_kunstwerktype(String std_kunstwerktype) {
        this.std_kunstwerktype = std_kunstwerktype;
    }

    public Integer getOppervlakte_kunstwerk() {
        return oppervlakte_kunstwerk;
    }

    public void setOppervlakte_kunstwerk(Integer oppervlakte_kunstwerk) {
        this.oppervlakte_kunstwerk = oppervlakte_kunstwerk;
    }

    public Integer getBreedte_kunstwerk() {
        return breedte_kunstwerk;
    }

    public void setBreedte_kunstwerk(Integer breedte_kunstwerk) {
        this.breedte_kunstwerk = breedte_kunstwerk;
    }

    public Integer getLengte_kunstwerk() {
        return lengte_kunstwerk;
    }

    public void setLengte_kunstwerk(Integer lengte_kunstwerk) {
        this.lengte_kunstwerk = lengte_kunstwerk;
    }

    public Integer getLengte_gesloten() {
        return lengte_gesloten;
    }

    public void setLengte_gesloten(Integer lengte_gesloten) {
        this.lengte_gesloten = lengte_gesloten;
    }

    public Integer getDoorvaarbreedte() {
        return doorvaarbreedte;
    }

    public void setDoorvaarbreedte(Integer doorvaarbreedte) {
        this.doorvaarbreedte = doorvaarbreedte;
    }

    public Integer getDoorvaarhoogte() {
        return doorvaarhoogte;
    }

    public void setDoorvaarhoogte(Integer doorvaarhoogte) {
        this.doorvaarhoogte = doorvaarhoogte;
    }

    public Integer getDoorrijbreedte() {
        return doorrijbreedte;
    }

    public void setDoorrijbreedte(Integer doorrijbreedte) {
        this.doorrijbreedte = doorrijbreedte;
    }

    public Integer getDoorrijhoogte() {
        return doorrijhoogte;
    }

    public void setDoorrijhoogte(Integer doorrijhoogte) {
        this.doorrijhoogte = doorrijhoogte;
    }

    public Integer getAantal_overspanningen() {
        return aantal_overspanningen;
    }

    public void setAantal_overspanningen(Integer aantal_overspanningen) {
        this.aantal_overspanningen = aantal_overspanningen;
    }

    public String getAlg_onderhoudsstaat() {
        return alg_onderhoudsstaat;
    }

    public void setAlg_onderhoudsstaat(String alg_onderhoudsstaat) {
        this.alg_onderhoudsstaat = alg_onderhoudsstaat;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getStd_hoofdcategorie() {
        return std_hoofdcategorie;
    }

    public void setStd_hoofdcategorie(String std_hoofdcategorie) {
        this.std_hoofdcategorie = std_hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getStd_categorie() {
        return std_categorie;
    }

    public void setStd_categorie(String std_categorie) {
        this.std_categorie = std_categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getStd_subcategorie() {
        return std_subcategorie;
    }

    public void setStd_subcategorie(String std_subcategorie) {
        this.std_subcategorie = std_subcategorie;
    }

    public String getPrioriteit() {
        return prioriteit;
    }

    public void setPrioriteit(String prioriteit) {
        this.prioriteit = prioriteit;
    }

    public String getBelastingklasse() {
        return belastingklasse;
    }

    public void setBelastingklasse(String belastingklasse) {
        this.belastingklasse = belastingklasse;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getConditie() {
        return conditie;
    }

    public void setConditie(String conditie) {
        this.conditie = conditie;
    }

    public String getVerzorging() {
        return verzorging;
    }

    public void setVerzorging(String verzorging) {
        this.verzorging = verzorging;
    }

    public String getBeheerobjecttype() {
        return beheerobjecttype;
    }

    public void setBeheerobjecttype(String beheerobjecttype) {
        this.beheerobjecttype = beheerobjecttype;
    }

    public String getInspectierapport() {
        return inspectierapport;
    }

    public void setInspectierapport(String inspectierapport) {
        this.inspectierapport = inspectierapport;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getGebruiksfunctie_kunstw() {
        return gebruiksfunctie_kunstw;
    }

    public void setGebruiksfunctie_kunstw(String gebruiksfunctie_kunstw) {
        this.gebruiksfunctie_kunstw = gebruiksfunctie_kunstw;
    }

    public String getWet_monumentaal_status() {
        return wet_monumentaal_status;
    }

    public void setWet_monumentaal_status(String wet_monumentaal_status) {
        this.wet_monumentaal_status = wet_monumentaal_status;
    }

    public Integer getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Integer aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public Integer getKerende_hoogte_bovenwater() {
        return kerende_hoogte_bovenwater;
    }

    public void setKerende_hoogte_bovenwater(Integer kerende_hoogte_bovenwater) {
        this.kerende_hoogte_bovenwater = kerende_hoogte_bovenwater;
    }

    public Integer getKerende_hoogte_onderwater() {
        return kerende_hoogte_onderwater;
    }

    public void setKerende_hoogte_onderwater(Integer kerende_hoogte_onderwater) {
        this.kerende_hoogte_onderwater = kerende_hoogte_onderwater;
    }

    public Integer getDoorstroomoppervlak() {
        return doorstroomoppervlak;
    }

    public void setDoorstroomoppervlak(Integer doorstroomoppervlak) {
        this.doorstroomoppervlak = doorstroomoppervlak;
    }

    public Integer getMaximale_overspanningen() {
        return maximale_overspanningen;
    }

    public void setMaximale_overspanningen(Integer maximale_overspanningen) {
        this.maximale_overspanningen = maximale_overspanningen;
    }

    public Integer getElem_id() {
        return elem_id;
    }

    public void setElem_id(Integer elem_id) {
        this.elem_id = elem_id;
    }

    public String getElem_guid() {
        return elem_guid;
    }

    public void setElem_guid(String elem_guid) {
        this.elem_guid = elem_guid;
    }

    public String getElem_afbeelding() {
        return elem_afbeelding;
    }

    public void setElem_afbeelding(String elem_afbeelding) {
        this.elem_afbeelding = elem_afbeelding;
    }

    public String getElem_conditie() {
        return elem_conditie;
    }

    public void setElem_conditie(String elem_conditie) {
        this.elem_conditie = elem_conditie;
    }

    public String getElem_verzorging() {
        return elem_verzorging;
    }

    public void setElem_verzorging(String elem_verzorging) {
        this.elem_verzorging = elem_verzorging;
    }

    public String getElement_type() {
        return element_type;
    }

    public void setElement_type(String element_type) {
        this.element_type = element_type;
    }

    public Integer getElem_hoeveelheid() {
        return elem_hoeveelheid;
    }

    public void setElem_hoeveelheid(Integer elem_hoeveelheid) {
        this.elem_hoeveelheid = elem_hoeveelheid;
    }

    public String getElem_materiaal() {
        return elem_materiaal;
    }

    public void setElem_materiaal(String elem_materiaal) {
        this.elem_materiaal = elem_materiaal;
    }

    public String getElem_toelichting() {
        return elem_toelichting;
    }

    public void setElem_toelichting(String elem_toelichting) {
        this.elem_toelichting = elem_toelichting;
    }

    public Integer getBd_id() {
        return bd_id;
    }

    public void setBd_id(Integer bd_id) {
        this.bd_id = bd_id;
    }

    public String getBd_guid() {
        return bd_guid;
    }

    public void setBd_guid(String bd_guid) {
        this.bd_guid = bd_guid;
    }

    public String getBd_afbeelding() {
        return bd_afbeelding;
    }

    public void setBd_afbeelding(String bd_afbeelding) {
        this.bd_afbeelding = bd_afbeelding;
    }

    public String getBd_bouwdeeltype() {
        return bd_bouwdeeltype;
    }

    public void setBd_bouwdeeltype(String bd_bouwdeeltype) {
        this.bd_bouwdeeltype = bd_bouwdeeltype;
    }

    public String getBd_conditie() {
        return bd_conditie;
    }

    public void setBd_conditie(String bd_conditie) {
        this.bd_conditie = bd_conditie;
    }

    public String getBd_verzorging() {
        return bd_verzorging;
    }

    public void setBd_verzorging(String bd_verzorging) {
        this.bd_verzorging = bd_verzorging;
    }

    public String getBd_eenheid() {
        return bd_eenheid;
    }

    public void setBd_eenheid(String bd_eenheid) {
        this.bd_eenheid = bd_eenheid;
    }

    public Integer getBd_hoeveelheid() {
        return bd_hoeveelheid;
    }

    public void setBd_hoeveelheid(Integer bd_hoeveelheid) {
        this.bd_hoeveelheid = bd_hoeveelheid;
    }

    public String getBd_materiaal() {
        return bd_materiaal;
    }

    public void setBd_materiaal(String bd_materiaal) {
        this.bd_materiaal = bd_materiaal;
    }

    public String getBd_toelichting() {
        return bd_toelichting;
    }

    public void setBd_toelichting(String bd_toelichting) {
        this.bd_toelichting = bd_toelichting;
    }

    public Integer getMaatregel_id() {
        return maatregel_id;
    }

    public void setMaatregel_id(Integer maatregel_id) {
        this.maatregel_id = maatregel_id;
    }

    public String getMaatregel_guid() {
        return maatregel_guid;
    }

    public void setMaatregel_guid(String maatregel_guid) {
        this.maatregel_guid = maatregel_guid;
    }

    public String getGebrek_of_planning() {
        return gebrek_of_planning;
    }

    public void setGebrek_of_planning(String gebrek_of_planning) {
        this.gebrek_of_planning = gebrek_of_planning;
    }

    public String getMaatregel() {
        return maatregel;
    }

    public void setMaatregel(String maatregel) {
        this.maatregel = maatregel;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Integer getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Integer jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Integer getHoev_planning() {
        return hoev_planning;
    }

    public void setHoev_planning(Integer hoev_planning) {
        this.hoev_planning = hoev_planning;
    }

    public Integer getKosten() {
        return kosten;
    }

    public void setKosten(Integer kosten) {
        this.kosten = kosten;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public String getGebrek() {
        return gebrek;
    }

    public void setGebrek(String gebrek) {
        this.gebrek = gebrek;
    }

    public String getBelang_gebrek() {
        return belang_gebrek;
    }

    public void setBelang_gebrek(String belang_gebrek) {
        this.belang_gebrek = belang_gebrek;
    }

    public String getIntensiteit_gebrek() {
        return intensiteit_gebrek;
    }

    public void setIntensiteit_gebrek(String intensiteit_gebrek) {
        this.intensiteit_gebrek = intensiteit_gebrek;
    }

    public String getOmvang_gebrek() {
        return omvang_gebrek;
    }

    public void setOmvang_gebrek(String omvang_gebrek) {
        this.omvang_gebrek = omvang_gebrek;
    }

    public String getConditie_gebrek() {
        return conditie_gebrek;
    }

    public void setConditie_gebrek(String conditie_gebrek) {
        this.conditie_gebrek = conditie_gebrek;
    }

    public String getVerzorging_gebrek() {
        return verzorging_gebrek;
    }

    public void setVerzorging_gebrek(String verzorging_gebrek) {
        this.verzorging_gebrek = verzorging_gebrek;
    }

    public String getReliability_gebrek() {
        return reliability_gebrek;
    }

    public void setReliability_gebrek(String reliability_gebrek) {
        this.reliability_gebrek = reliability_gebrek;
    }

    public String getAvailability_gebrek() {
        return availability_gebrek;
    }

    public void setAvailability_gebrek(String availability_gebrek) {
        this.availability_gebrek = availability_gebrek;
    }

    public String getMaintainability_gebrek() {
        return maintainability_gebrek;
    }

    public void setMaintainability_gebrek(String maintainability_gebrek) {
        this.maintainability_gebrek = maintainability_gebrek;
    }

    public String getSafety_gebrek() {
        return safety_gebrek;
    }

    public void setSafety_gebrek(String safety_gebrek) {
        this.safety_gebrek = safety_gebrek;
    }

    public String getMemo_gebrek() {
        return memo_gebrek;
    }

    public void setMemo_gebrek(String memo_gebrek) {
        this.memo_gebrek = memo_gebrek;
    }

    public String getAfbeelding_gebrek() {
        return afbeelding_gebrek;
    }

    public void setAfbeelding_gebrek(String afbeelding_gebrek) {
        this.afbeelding_gebrek = afbeelding_gebrek;
    }

    public String getAfbeelding_detail_gebrek() {
        return afbeelding_detail_gebrek;
    }

    public void setAfbeelding_detail_gebrek(String afbeelding_detail_gebrek) {
        this.afbeelding_detail_gebrek = afbeelding_detail_gebrek;
    }

    public Integer getCyclus() {
        return cyclus;
    }

    public void setCyclus(Integer cyclus) {
        this.cyclus = cyclus;
    }

    public String getKl_correctiefactor() {
        return kl_correctiefactor;
    }

    public void setKl_correctiefactor(String kl_correctiefactor) {
        this.kl_correctiefactor = kl_correctiefactor;
    }

    public String getHealth_gebrek() {
        return health_gebrek;
    }

    public void setHealth_gebrek(String health_gebrek) {
        this.health_gebrek = health_gebrek;
    }

    public String getEnvironment_gebrek() {
        return environment_gebrek;
    }

    public void setEnvironment_gebrek(String environment_gebrek) {
        this.environment_gebrek = environment_gebrek;
    }

    public String getEconomics_gebrek() {
        return economics_gebrek;
    }

    public void setEconomics_gebrek(String economics_gebrek) {
        this.economics_gebrek = economics_gebrek;
    }

    public String getPolitics_gebrek() {
        return politics_gebrek;
    }

    public void setPolitics_gebrek(String politics_gebrek) {
        this.politics_gebrek = politics_gebrek;
    }

    public Boolean getVerversen() {
        return verversen;
    }

    public void setVerversen(Boolean verversen) {
        this.verversen = verversen;
    }

    public String getKl_inspectierapport() {
        return kl_inspectierapport;
    }

    public void setKl_inspectierapport(String kl_inspectierapport) {
        this.kl_inspectierapport = kl_inspectierapport;
    }

    @Override
    public String getObjectGuid() {
        return objectGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }
}
