package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import nl.b3p.formendpoint.resource.Feature;
import nl.b3p.formendpoint.resource.WellInspection;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Entity(name = "gb_plantenbak_planning")
@Schema(
        name = "PlantenbakPlanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PlanterPlanning implements Feature, Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @Schema(name="data_guid")
    private String dataGuid;
    private String maatregel_pbak;
    private String maatregeltype;
    private Integer jaarvanuitvoering;
    private Integer hoeveelheid;
    private Integer kosten;
    private Boolean gepland_uitgevoerd;
    private String planstatus;
    private String werkeenheid;
    private Integer frequentie;
    private String plantenbak_id;
    private String calc_plan_id;
    private String calc_plan_code;
    private String calc_plan_name;
    private Integer belang;
    private String maatregelgroep;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getMaatregel_pbak() {
        return maatregel_pbak;
    }

    public void setMaatregel_pbak(String maatregel_pbak) {
        this.maatregel_pbak = maatregel_pbak;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Integer getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Integer jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Integer getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Integer hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Integer getKosten() {
        return kosten;
    }

    public void setKosten(Integer kosten) {
        this.kosten = kosten;
    }

    public Boolean getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(Boolean gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public String getWerkeenheid() {
        return werkeenheid;
    }

    public void setWerkeenheid(String werkeenheid) {
        this.werkeenheid = werkeenheid;
    }

    public Integer getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Integer frequentie) {
        this.frequentie = frequentie;
    }

    public String getPlantenbak_id() {
        return plantenbak_id;
    }

    public void setPlantenbak_id(String plantenbak_id) {
        this.plantenbak_id = plantenbak_id;
    }

    public String getCalc_plan_id() {
        return calc_plan_id;
    }

    public void setCalc_plan_id(String calc_plan_id) {
        this.calc_plan_id = calc_plan_id;
    }

    public String getCalc_plan_code() {
        return calc_plan_code;
    }

    public void setCalc_plan_code(String calc_plan_code) {
        this.calc_plan_code = calc_plan_code;
    }

    public String getCalc_plan_name() {
        return calc_plan_name;
    }

    public void setCalc_plan_name(String calc_plan_name) {
        this.calc_plan_name = calc_plan_name;
    }

    public Integer getBelang() {
        return belang;
    }

    public void setBelang(Integer belang) {
        this.belang = belang;
    }

    public String getMaatregelgroep() {
        return maatregelgroep;
    }

    public void setMaatregelgroep(String maatregelgroep) {
        this.maatregelgroep = maatregelgroep;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
