package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

@Entity(name = "gb_wegvakonderdeel_planning")
@Schema(
        name = "Wegvakonderdeelplanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RoadsectionPlanning implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(name="data_guid")
    private String dataGuid;
    private String maatregel_wvko;
    private String maatregeltype;
    private Integer jaarvanuitvoering;
    private Integer hoeveelheid;
    private Integer kosten;
    private Boolean gepland_uitgevoerd;
    private String planstatus;
    private Integer frequentie;
    private String memo;
    @Schema(name="wegvakonderdeel_id")
    @Column(name="wegvakonderdeel_id")
    private String wegvakonderdeelId;
    private String std_verhardingssoort;
    private String wegtype;
    private String verhardingstype;
    private Boolean binnen_kom;
    private String maatregel_kopie;
    private Integer kosten_per_eenheid;
    private String calc_plan_id;
    private String calc_plan_code;
    private String calc_plan_name;
    private Integer eenheidsprijs;
    private Integer kostenfactor;
    private String dekkingscode;
    private String toeslagen;
    private Integer vaste_kosten;
    private Integer belang;
    private String maatregelgroep;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getMaatregel_wvko() {
        return maatregel_wvko;
    }

    public void setMaatregel_wvko(String maatregel_wvko) {
        this.maatregel_wvko = maatregel_wvko;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Integer getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Integer jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Integer getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Integer hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Integer getKosten() {
        return kosten;
    }

    public void setKosten(Integer kosten) {
        this.kosten = kosten;
    }

    public Boolean getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(Boolean gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public Integer getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Integer frequentie) {
        this.frequentie = frequentie;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getWegvakonderdeelId() {
        return wegvakonderdeelId;
    }

    public void setWegvakonderdeelId(String wegvakonderdeelId) {
        this.wegvakonderdeelId = wegvakonderdeelId;
    }

    public String getStd_verhardingssoort() {
        return std_verhardingssoort;
    }

    public void setStd_verhardingssoort(String std_verhardingssoort) {
        this.std_verhardingssoort = std_verhardingssoort;
    }

    public String getWegtype() {
        return wegtype;
    }

    public void setWegtype(String wegtype) {
        this.wegtype = wegtype;
    }

    public String getVerhardingstype() {
        return verhardingstype;
    }

    public void setVerhardingstype(String verhardingstype) {
        this.verhardingstype = verhardingstype;
    }

    public Boolean getBinnen_kom() {
        return binnen_kom;
    }

    public void setBinnen_kom(Boolean binnen_kom) {
        this.binnen_kom = binnen_kom;
    }

    public String getMaatregel_kopie() {
        return maatregel_kopie;
    }

    public void setMaatregel_kopie(String maatregel_kopie) {
        this.maatregel_kopie = maatregel_kopie;
    }

    public Integer getKosten_per_eenheid() {
        return kosten_per_eenheid;
    }

    public void setKosten_per_eenheid(Integer kosten_per_eenheid) {
        this.kosten_per_eenheid = kosten_per_eenheid;
    }

    public String getCalc_plan_id() {
        return calc_plan_id;
    }

    public void setCalc_plan_id(String calc_plan_id) {
        this.calc_plan_id = calc_plan_id;
    }

    public String getCalc_plan_code() {
        return calc_plan_code;
    }

    public void setCalc_plan_code(String calc_plan_code) {
        this.calc_plan_code = calc_plan_code;
    }

    public String getCalc_plan_name() {
        return calc_plan_name;
    }

    public void setCalc_plan_name(String calc_plan_name) {
        this.calc_plan_name = calc_plan_name;
    }

    public Integer getEenheidsprijs() {
        return eenheidsprijs;
    }

    public void setEenheidsprijs(Integer eenheidsprijs) {
        this.eenheidsprijs = eenheidsprijs;
    }

    public Integer getKostenfactor() {
        return kostenfactor;
    }

    public void setKostenfactor(Integer kostenfactor) {
        this.kostenfactor = kostenfactor;
    }

    public String getDekkingscode() {
        return dekkingscode;
    }

    public void setDekkingscode(String dekkingscode) {
        this.dekkingscode = dekkingscode;
    }

    public String getToeslagen() {
        return toeslagen;
    }

    public void setToeslagen(String toeslagen) {
        this.toeslagen = toeslagen;
    }

    public Integer getVaste_kosten() {
        return vaste_kosten;
    }

    public void setVaste_kosten(Integer vaste_kosten) {
        this.vaste_kosten = vaste_kosten;
    }

    public Integer getBelang() {
        return belang;
    }

    public void setBelang(Integer belang) {
        this.belang = belang;
    }

    public String getMaatregelgroep() {
        return maatregelgroep;
    }

    public void setMaatregelgroep(String maatregelgroep) {
        this.maatregelgroep = maatregelgroep;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
