package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

@Entity(name = "gb_boom_onderhoud")
@Schema(
        name = "Boomonderhoud",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TreeSupport implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @Schema(name = "data_guid")
    private String dataGuid;
    private String uitgevoerde_maatregel;
    private String omschrijving;
    private String uitgevoerd_door;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date datum_uitgevoerd;
    private Character akkoord;
    private String boom_id;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getUitgevoerde_maatregel() {
        return uitgevoerde_maatregel;
    }

    public void setUitgevoerde_maatregel(String uitgevoerde_maatregel) {
        this.uitgevoerde_maatregel = uitgevoerde_maatregel;
    }

    public String getOmschrijving() {
        return omschrijving;
    }

    public void setOmschrijving(String omschrijving) {
        this.omschrijving = omschrijving;
    }

    public String getUitgevoerd_door() {
        return uitgevoerd_door;
    }

    public void setUitgevoerd_door(String uitgevoerd_door) {
        this.uitgevoerd_door = uitgevoerd_door;
    }

    public Date getDatum_uitgevoerd() {
        return datum_uitgevoerd;
    }

    public void setDatum_uitgevoerd(Date datum_uitgevoerd) {
        this.datum_uitgevoerd = datum_uitgevoerd;
    }

    public Character getAkkoord() {
        return akkoord;
    }

    public void setAkkoord(Character akkoord) {
        this.akkoord = akkoord;
    }

    public String getBoom_id() {
        return boom_id;
    }

    public void setBoom_id(String boom_id) {
        this.boom_id = boom_id;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
