/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.repository.RoadsectionplanningRepository;
import nl.b3p.formendpoint.resource.Roadsection;
import nl.b3p.formendpoint.resource.RoadsectionPlanning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wegvakonderdeelplanning"})
public class FormRoadsectionPartPlanningController
implements FormController<RoadsectionPlanning> {
    @Autowired
    RoadsectionplanningRepository repo;
    @Autowired
    RoadsectionRepository wvRepo;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/{objectGuid}"})
    public RoadsectionPlanning get(@PathVariable String objectGuid) {
        return (RoadsectionPlanning)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
    }

    public List<RoadsectionPlanning> onPoint(double x, double y, double scale) {
        return new ArrayList<RoadsectionPlanning>();
    }

    @GetMapping
    public Page<RoadsectionPlanning> getAllPaged(Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    @GetMapping(value={"/unpaged"})
    public List<RoadsectionPlanning> getAll() {
        return this.repo.findAll();
    }

    @PostMapping
    public RoadsectionPlanning save(@RequestBody RoadsectionPlanning wv, String parentId) {
        Roadsection parent = (Roadsection)this.wvRepo.findByObjectGuid(parentId).orElseThrow(() -> new IllegalArgumentException("Parent niet gevonden"));
        wv.setWegvakonderdeelId(parent.getObjectGuid());
        return (RoadsectionPlanning)this.repo.save((Object)wv);
    }

    @PutMapping(value={"/{objectGuid}"})
    public RoadsectionPlanning update(@PathVariable String objectGuid, @RequestBody RoadsectionPlanning wv) {
        RoadsectionPlanning orig = (RoadsectionPlanning)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)wv, (Object)orig);
        RoadsectionPlanning nieuw = (RoadsectionPlanning)this.repo.save((Object)orig);
        return nieuw;
    }

    @DeleteMapping(value={"/{objectGuid}"})
    public void delete(@PathVariable String objectGuid) {
        this.repo.deleteByDataGuid(objectGuid);
    }

    public Class getMaintainingClass() {
        return RoadsectionPlanning.class;
    }
}

